/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceUrlParser {
    @NotNull
    private String resourceUrl = "";
    private int colonPos;
    private int slashPos;
    private int typeStart;
    private int namespacePrefixStart;
    private int nameStart;

    /*
     * Enabled aggressive block sorting
     */
    public void parseResourceUrl(@NotNull String resourceUrl) {
        if (resourceUrl == null) {
            ResourceUrlParser.$$$reportNull$$$0(0);
        }
        this.resourceUrl = resourceUrl;
        this.colonPos = -1;
        this.slashPos = -1;
        this.typeStart = -1;
        this.namespacePrefixStart = -1;
        int prefixEnd = resourceUrl.startsWith("@") ? (resourceUrl.startsWith("@+") ? 2 : 1) : (resourceUrl.startsWith("?") ? 1 : 0);
        if (resourceUrl.startsWith("*", prefixEnd)) {
            ++prefixEnd;
        }
        int len = resourceUrl.length();
        int start = prefixEnd;
        block4: for (int i2 = prefixEnd; i2 < len; ++i2) {
            char c = resourceUrl.charAt(i2);
            switch (c) {
                case '/': {
                    if (this.slashPos >= 0) break;
                    this.slashPos = i2;
                    this.typeStart = start;
                    start = i2 + 1;
                    if (this.colonPos < 0) break;
                    break block4;
                }
                case ':': {
                    if (this.colonPos >= 0) break;
                    this.colonPos = i2;
                    this.namespacePrefixStart = start;
                    start = i2 + 1;
                    if (this.slashPos >= 0) break block4;
                }
            }
        }
        this.nameStart = start;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.colonPos >= 0 ? this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos) : null;
    }

    @Nullable
    public String getType() {
        return this.slashPos >= 0 ? this.resourceUrl.substring(this.typeStart, this.slashPos) : null;
    }

    @NotNull
    public String getName() {
        String string = this.resourceUrl.substring(this.nameStart);
        if (string == null) {
            ResourceUrlParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.colonPos < 0) {
            String string = this.getName();
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (this.nameStart == this.colonPos + 1) {
            String string = this.resourceUrl.substring(this.namespacePrefixStart);
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.resourceUrl.substring(this.namespacePrefixStart, this.colonPos + 1) + this.getName();
        if (string == null) {
            ResourceUrlParser.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean hasType(@NotNull String type) {
        if (type == null) {
            ResourceUrlParser.$$$reportNull$$$0(5);
        }
        if (this.slashPos < 0) {
            return false;
        }
        return this.slashPos == this.typeStart + type.length() && this.resourceUrl.startsWith(type, this.typeStart);
    }

    public boolean hasNamespacePrefix(@NotNull String namespacePrefix) {
        if (namespacePrefix == null) {
            ResourceUrlParser.$$$reportNull$$$0(6);
        }
        if (this.colonPos < 0) {
            return false;
        }
        return this.colonPos == this.namespacePrefixStart + namespacePrefix.length() && this.resourceUrl.startsWith(namespacePrefix, this.namespacePrefixStart);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceUrl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/ResourceUrlParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/ResourceUrlParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseResourceUrl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasNamespacePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

