/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.update;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.IndexBundle;
import com.android.tools.idea.room.migrations.update.SchemaDiffUtil;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class EntityUpdate {
    private EntityBundle oldState;
    private EntityBundle newState;
    private List<FieldBundle> allFields;
    private Map<String, FieldBundle> unmodifiedFields;
    private Map<String, FieldBundle> modifiedFields;
    private Map<String, FieldBundle> deletedFields;
    private Map<String, FieldBundle> newFields;
    private Map<FieldBundle, String> valuesForUninitializedFields;
    private Map<FieldBundle, String> renamedFields;
    private boolean containsUninitializedNotNullFields;
    private boolean containsRenamedAndModifiedFields;
    private List<IndexBundle> unmodifiedIndices;
    private List<IndexBundle> deletedIndices;
    private List<IndexBundle> newOrModifiedIndices;
    private boolean primaryKeyUpdate;
    private boolean foreignKeysUpdate;

    public EntityUpdate(@NotNull EntityBundle oldEntity, @NotNull EntityBundle newEntity) {
        if (oldEntity == null) {
            EntityUpdate.$$$reportNull$$$0(0);
        }
        if (newEntity == null) {
            EntityUpdate.$$$reportNull$$$0(1);
        }
        this.checkEntity(oldEntity);
        this.checkEntity(newEntity);
        this.oldState = oldEntity;
        this.newState = newEntity;
        this.allFields = new ArrayList<FieldBundle>(newEntity.getFields());
        this.unmodifiedFields = new HashMap<String, FieldBundle>();
        this.deletedFields = new HashMap<String, FieldBundle>();
        this.modifiedFields = new HashMap<String, FieldBundle>();
        this.newFields = new HashMap<String, FieldBundle>();
        this.renamedFields = new HashMap<FieldBundle, String>();
        this.valuesForUninitializedFields = new HashMap<FieldBundle, String>();
        this.containsUninitializedNotNullFields = false;
        HashMap<String, FieldBundle> oldEntityFields = new HashMap<String, FieldBundle>(oldEntity.getFieldsByColumnName());
        for (FieldBundle newField : newEntity.getFields()) {
            if (oldEntityFields.containsKey(newField.getColumnName())) {
                FieldBundle oldField = (FieldBundle)oldEntityFields.remove(newField.getColumnName());
                if (!oldField.isSchemaEqual(newField)) {
                    this.modifiedFields.put(newField.getColumnName(), newField);
                    continue;
                }
                this.unmodifiedFields.put(newField.getColumnName(), newField);
                continue;
            }
            this.newFields.put(newField.getColumnName(), newField);
            if (!newField.isNonNull() || newField.getDefaultValue() != null && !newField.getDefaultValue().isEmpty()) continue;
            this.containsUninitializedNotNullFields = true;
        }
        this.deletedFields = oldEntityFields;
        this.unmodifiedIndices = new ArrayList<IndexBundle>();
        this.deletedIndices = new ArrayList<IndexBundle>();
        this.newOrModifiedIndices = new ArrayList<IndexBundle>();
        if (oldEntity.getIndices().isEmpty()) {
            this.newOrModifiedIndices.addAll(newEntity.getIndices());
        } else if (newEntity.getIndices().isEmpty()) {
            this.deletedIndices.addAll(oldEntity.getIndices());
        } else {
            Map<String, IndexBundle> oldIndices = oldEntity.getIndices().stream().collect(Collectors.toMap(IndexBundle::getName, index -> index));
            if (newEntity.getIndices() != null) {
                for (IndexBundle newIndex : newEntity.getIndices()) {
                    IndexBundle oldIndex = oldIndices.get(newIndex.getName());
                    if (oldIndex != null) {
                        if (!oldIndex.isSchemaEqual(newIndex)) {
                            this.newOrModifiedIndices.add(newIndex);
                            continue;
                        }
                        this.unmodifiedIndices.add(newIndex);
                        oldIndices.remove(newIndex.getName());
                        continue;
                    }
                    this.newOrModifiedIndices.add(newIndex);
                }
            }
            this.deletedIndices.addAll(oldIndices.values());
        }
        this.primaryKeyUpdate = !oldEntity.getPrimaryKey().isSchemaEqual(newEntity.getPrimaryKey());
        this.foreignKeysUpdate = !SchemaDiffUtil.tablesHaveSameForeignKeyConstraints(oldEntity, newEntity);
        this.containsRenamedAndModifiedFields = false;
    }

    @NotNull
    public EntityBundle getOldState() {
        EntityBundle entityBundle = this.oldState;
        if (entityBundle == null) {
            EntityUpdate.$$$reportNull$$$0(2);
        }
        return entityBundle;
    }

    @NotNull
    public EntityBundle getNewState() {
        EntityBundle entityBundle = this.newState;
        if (entityBundle == null) {
            EntityUpdate.$$$reportNull$$$0(3);
        }
        return entityBundle;
    }

    @NotNull
    public String getOldTableName() {
        String string = this.oldState.getTableName();
        if (string == null) {
            EntityUpdate.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getNewTableName() {
        String string = this.newState.getTableName();
        if (string == null) {
            EntityUpdate.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean shouldCreateAnFtsEntity() {
        return this.newState instanceof FtsEntityBundle;
    }

    public boolean shouldRenameTable() {
        return !this.newState.getTableName().equals(this.oldState.getTableName());
    }

    @NotNull
    public List<FieldBundle> getAllFields() {
        List<FieldBundle> list = this.allFields;
        if (list == null) {
            EntityUpdate.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Map<String, FieldBundle> getUnmodifiedFields() {
        Map<String, FieldBundle> map2 = this.unmodifiedFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    public Map<String, FieldBundle> getModifiedFields() {
        Map<String, FieldBundle> map2 = this.modifiedFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    public Map<String, FieldBundle> getDeletedFields() {
        Map<String, FieldBundle> map2 = this.deletedFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    public Map<String, FieldBundle> getNewFields() {
        Map<String, FieldBundle> map2 = this.newFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    public List<IndexBundle> getIndicesToBeDropped() {
        List<IndexBundle> list = this.deletedIndices;
        if (list == null) {
            EntityUpdate.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<IndexBundle> getIndicesToBeCreated() {
        if (this.isComplexUpdate()) {
            ArrayList<IndexBundle> indicesToCreate = new ArrayList<IndexBundle>();
            Stream.of(this.unmodifiedIndices, this.newOrModifiedIndices).forEach(indicesToCreate::addAll);
            ArrayList<IndexBundle> arrayList = indicesToCreate;
            if (arrayList == null) {
                EntityUpdate.$$$reportNull$$$0(12);
            }
            return arrayList;
        }
        List<IndexBundle> list = this.newOrModifiedIndices;
        if (list == null) {
            EntityUpdate.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setValuesForUninitializedFields(@NotNull Map<FieldBundle, String> valuesForUninitializedFields) {
        if (valuesForUninitializedFields == null) {
            EntityUpdate.$$$reportNull$$$0(14);
        }
        this.valuesForUninitializedFields = valuesForUninitializedFields;
    }

    @NotNull
    public Map<FieldBundle, String> getValuesForUninitializedFields() {
        Map<FieldBundle, String> map2 = this.valuesForUninitializedFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(15);
        }
        return map2;
    }

    public void applyRenameMapping(@NotNull Map<String, String> oldToNewNameMapping) {
        if (oldToNewNameMapping == null) {
            EntityUpdate.$$$reportNull$$$0(16);
        }
        for (Map.Entry<String, String> columnNames : oldToNewNameMapping.entrySet()) {
            FieldBundle oldField = this.deletedFields.remove(columnNames.getKey());
            FieldBundle newField = this.newFields.remove(columnNames.getValue());
            if (oldField == null || newField == null) {
                throw new IllegalArgumentException("Invalid old column name to new column name mapping");
            }
            if (!SchemaDiffUtil.isFieldStructureTheSame(oldField, newField)) {
                this.containsRenamedAndModifiedFields = true;
            }
            this.renamedFields.put(newField, oldField.getColumnName());
        }
    }

    @NotNull
    public Map<FieldBundle, String> getRenamedFields() {
        Map<FieldBundle, String> map2 = this.renamedFields;
        if (map2 == null) {
            EntityUpdate.$$$reportNull$$$0(17);
        }
        return map2;
    }

    public boolean keysWereUpdated() {
        return this.primaryKeyUpdate | this.foreignKeysUpdate;
    }

    public boolean foreignKeysWereUpdated() {
        return this.foreignKeysUpdate;
    }

    public boolean isComplexUpdate() {
        return !this.deletedFields.isEmpty() || !this.modifiedFields.isEmpty() || this.keysWereUpdated() || this.containsUninitializedNotNullFields || this.containsRenamedAndModifiedFields || this.shouldCreateAnFtsEntity();
    }

    private void checkEntity(@NotNull EntityBundle entityBundle) {
        if (entityBundle == null) {
            EntityUpdate.$$$reportNull$$$0(18);
        }
        Preconditions.checkArgument((entityBundle.getFields() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the field list is null.");
        Preconditions.checkArgument((entityBundle.getIndices() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the list of indices is null.");
        Preconditions.checkArgument((entityBundle.getPrimaryKey() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the primary key is null.");
        Preconditions.checkArgument((entityBundle.getForeignKeys() != null ? 1 : 0) != 0, (Object)"Invalid EntityBundle object: the foreign key list is null.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/update/EntityUpdate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesForUninitializedFields";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewNameMapping";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/update/EntityUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldTableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewTableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmodifiedFields";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedFields";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFields";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesToBeDropped";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesToBeCreated";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesForUninitializedFields";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenamedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setValuesForUninitializedFields";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyRenameMapping";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkEntity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

