/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    @NotNull
    private final String myExecutorId;
    @NotNull
    private final String myExecutorActionName;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    @NotNull
    private final ExecutionTarget myExecutionTarget;

    @NotNull
    public static AndroidSessionInfo create(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull String executorActionName, @NotNull ExecutionTarget executionTarget) {
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            AndroidSessionInfo.$$$reportNull$$$0(1);
        }
        if (executorId == null) {
            AndroidSessionInfo.$$$reportNull$$$0(2);
        }
        if (executorActionName == null) {
            AndroidSessionInfo.$$$reportNull$$$0(3);
        }
        if (executionTarget == null) {
            AndroidSessionInfo.$$$reportNull$$$0(4);
        }
        AndroidSessionInfo result2 = new AndroidSessionInfo(processHandler, descriptor2, runConfiguration, executorId, executorActionName, executionTarget);
        processHandler.putUserData(KEY, (Object)result2);
        AndroidSessionInfo androidSessionInfo = result2;
        if (androidSessionInfo == null) {
            AndroidSessionInfo.$$$reportNull$$$0(5);
        }
        return androidSessionInfo;
    }

    private AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull String executorActionName, @NotNull ExecutionTarget executionTarget) {
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            AndroidSessionInfo.$$$reportNull$$$0(7);
        }
        if (executorId == null) {
            AndroidSessionInfo.$$$reportNull$$$0(8);
        }
        if (executorActionName == null) {
            AndroidSessionInfo.$$$reportNull$$$0(9);
        }
        if (executionTarget == null) {
            AndroidSessionInfo.$$$reportNull$$$0(10);
        }
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor2;
        this.myRunConfiguration = runConfiguration;
        this.myExecutorId = executorId;
        this.myExecutorActionName = executorActionName;
        this.myExecutionTarget = executionTarget;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(11);
        }
        return processHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        RunContentDescriptor runContentDescriptor = this.myDescriptor;
        if (runContentDescriptor == null) {
            AndroidSessionInfo.$$$reportNull$$$0(12);
        }
        return runContentDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        String string = this.myExecutorId;
        if (string == null) {
            AndroidSessionInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Executor getExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(this.getExecutorId());
    }

    @NotNull
    public String getExecutorActionName() {
        String string = this.myExecutorActionName;
        if (string == null) {
            AndroidSessionInfo.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myExecutionTarget;
        if (executionTarget == null) {
            AndroidSessionInfo.$$$reportNull$$$0(15);
        }
        return executionTarget;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, @NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        if (project == null) {
            AndroidSessionInfo.$$$reportNull$$$0(16);
        }
        if (runConfiguration == null) {
            AndroidSessionInfo.$$$reportNull$$$0(17);
        }
        if (executionTarget == null) {
            AndroidSessionInfo.$$$reportNull$$$0(18);
        }
        List infos = Arrays.stream(ExecutionManager.getInstance((Project)project).getRunningProcesses()).filter(handler -> !handler.isProcessTerminating() && !handler.isProcessTerminated()).map(handler -> (AndroidSessionInfo)handler.getUserData(KEY)).filter(info -> info != null && runConfiguration == info.getRunConfiguration() && (executor == null || executor.getId().equals(info.getExecutorId()))).collect(Collectors.toList());
        if (executionTarget instanceof AndroidExecutionTarget) {
            for (AndroidSessionInfo info2 : infos) {
                ExecutionTarget sessionExecutionTarget = info2.getExecutionTarget();
                if (!(sessionExecutionTarget instanceof AndroidExecutionTarget ? sessionExecutionTarget.getId().equals(executionTarget.getId()) : AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(runConfiguration, (AndroidExecutionTarget)executionTarget, info2.getProcessHandler()))) continue;
                return info2;
            }
            return null;
        }
        for (AndroidSessionInfo info3 : infos) {
            ExecutionTarget sessionExecutionTarget = info3.getExecutionTarget();
            if (sessionExecutionTarget instanceof AndroidExecutionTarget) {
                assert (info3.myRunConfiguration != null);
                if (!AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(info3.myRunConfiguration, (AndroidExecutionTarget)sessionExecutionTarget, info3.getProcessHandler())) continue;
                return info3;
            }
            return info3;
        }
        return null;
    }

    private static boolean checkIfIDeviceRunningInProcessHandler(@NotNull RunConfiguration runConfiguration, @NotNull AndroidExecutionTarget executionTarget, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            AndroidSessionInfo.$$$reportNull$$$0(19);
        }
        if (executionTarget == null) {
            AndroidSessionInfo.$$$reportNull$$$0(20);
        }
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(21);
        }
        IDevice iDevice = executionTarget.getIDevice();
        if (processHandler instanceof AndroidProcessHandler) {
            if (iDevice == null) {
                return false;
            }
            return ((AndroidProcessHandler)processHandler).isAssociated(iDevice);
        }
        if (processHandler instanceof AndroidRemoteDebugProcessHandler) {
            return ((AndroidRemoteDebugProcessHandler)processHandler).isRunningWith(runConfiguration, executionTarget);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorActionName";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionTarget";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidSessionInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidSessionInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findOldSession";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkIfIDeviceRunningInProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

