/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunOnMultipleDevicesAction
extends AnAction {
    @NotNull
    private final Function<Project, RunnerAndConfigurationSettings> myGetSelectedConfiguration;
    @NotNull
    private final Function<Project, Collection<Device>> myGetDevices;

    RunOnMultipleDevicesAction() {
        this(project -> RunManager.getInstance((Project)project).getSelectedConfiguration(), project -> ((AsyncDevicesGetter)ServiceManager.getService((Project)project, AsyncDevicesGetter.class)).get());
    }

    @VisibleForTesting
    RunOnMultipleDevicesAction(@NotNull Function<Project, RunnerAndConfigurationSettings> getSelectedConfiguration, @NotNull Function<Project, Collection<Device>> getDevices) {
        if (getSelectedConfiguration == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(0);
        }
        if (getDevices == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(1);
        }
        super("Run on Multiple Devices", null, AllIcons.Actions.Execute);
        this.myGetSelectedConfiguration = getSelectedConfiguration;
        this.myGetDevices = getDevices;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(2);
        }
        Project project = event.getProject();
        Presentation presentation = event.getPresentation();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        RunnerAndConfigurationSettings settings = this.myGetSelectedConfiguration.apply(project);
        if (settings == null) {
            presentation.setEnabled(false);
            return;
        }
        if (!RunOnMultipleDevicesAction.isSupportedRunConfigurationType(settings.getType())) {
            presentation.setEnabled(false);
            return;
        }
        if (this.myGetDevices.apply(project).isEmpty()) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(3);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        DeviceAndSnapshotComboBoxTargetProvider provider2 = RunOnMultipleDevicesAction.findProvider();
        if (provider2 == null) {
            return;
        }
        provider2.setProvidingMultipleTargets(true);
        ExecutionEnvironmentBuilder builder2 = RunOnMultipleDevicesAction.createBuilder(event.getDataContext());
        if (builder2 == null) {
            return;
        }
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.build());
    }

    @Nullable
    private static DeviceAndSnapshotComboBoxTargetProvider findProvider() {
        Optional<DeployTargetProvider> optionalProvider = DeployTargetProvider.getProviders().stream().filter(DeviceAndSnapshotComboBoxTargetProvider.class::isInstance).findFirst();
        return optionalProvider.orElse(null);
    }

    @Nullable
    private static ExecutionEnvironmentBuilder createBuilder(@NotNull DataContext context) {
        if (context == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(4);
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            return null;
        }
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder2 == null) {
            return null;
        }
        builder2.dataContext(context);
        return builder2;
    }

    private static boolean isSupportedRunConfigurationType(@NotNull ConfigurationType type) {
        if (type == null) {
            RunOnMultipleDevicesAction.$$$reportNull$$$0(5);
        }
        if (type instanceof AndroidRunConfigurationType) {
            return true;
        }
        return (Boolean)StudioFlags.MULTIDEVICE_INSTRUMENTATION_TESTS.get() != false && type instanceof AndroidTestRunConfigurationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getSelectedConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getDevices";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/deployment/RunOnMultipleDevicesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedRunConfigurationType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

