/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialogTable;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialogTableModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectDeploymentTargetsDialog
extends DialogWrapper {
    private static final String SELECTED_DEVICES = "SelectDeploymentTargetsDialog.selectedDevices";
    @NotNull
    private final Project myProject;
    @Nullable
    private SelectDeploymentTargetsDialogTable myTable;
    @Nullable
    private Collection<Device> mySelectedDevices;

    SelectDeploymentTargetsDialog(@NotNull Project project) {
        if (project == null) {
            SelectDeploymentTargetsDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.initTable();
        this.init();
        this.setTitle("Select Deployment Targets");
    }

    private void initTable() {
        List<Device> devices2 = ((AsyncDevicesGetter)ServiceManager.getService((Project)this.myProject, AsyncDevicesGetter.class)).get();
        this.myTable = new SelectDeploymentTargetsDialogTable();
        this.myTable.setModel(new SelectDeploymentTargetsDialogTableModel(devices2, (JTable)((Object)this.myTable)));
        this.myTable.getSelectionModel().addListSelectionListener(event -> this.getOKAction().setEnabled(this.myTable.getSelectedRowCount() != 0));
        String[] array = PropertiesComponent.getInstance((Project)this.myProject).getValues(SELECTED_DEVICES);
        if (array == null) {
            return;
        }
        Collection collection2 = Arrays.stream(array).map(Key::new).collect(Collectors.toSet());
        this.myTable.setSelectedDevices(collection2);
    }

    @NotNull
    Collection<Device> getSelectedDevices() {
        assert (this.mySelectedDevices != null);
        Collection<Device> collection2 = this.mySelectedDevices;
        if (collection2 == null) {
            SelectDeploymentTargetsDialog.$$$reportNull$$$0(1);
        }
        return collection2;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        GroupLayout layout2 = new GroupLayout(panel2);
        JLabel label = new JLabel("Available devices");
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.myTable));
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(label).addComponent((Component)scrollPane);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(label).addComponent((Component)scrollPane);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            SelectDeploymentTargetsDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
        this.myOKAction.putValue("Name", "Run");
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        assert (this.myTable != null);
        SelectDeploymentTargetsDialogTable selectDeploymentTargetsDialogTable = this.myTable;
        if (selectDeploymentTargetsDialogTable == null) {
            SelectDeploymentTargetsDialog.$$$reportNull$$$0(3);
        }
        return selectDeploymentTargetsDialogTable;
    }

    protected void doOKAction() {
        super.doOKAction();
        assert (this.myTable != null);
        this.mySelectedDevices = this.myTable.getSelectedDevices();
        String[] keys = (String[])this.mySelectedDevices.stream().map(Device::getKey).map(Key::toString).toArray(String[]::new);
        PropertiesComponent.getInstance((Project)this.myProject).setValues(SELECTED_DEVICES, keys);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/SelectDeploymentTargetsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/SelectDeploymentTargetsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDevices";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

