/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Vm;
import com.android.tools.idea.welcome.install.VmType;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class VmWizard
extends DynamicWizard {
    @NotNull
    VmType myType;
    @NotNull
    VmPath myVmPath;
    boolean myInvokedToUninstall;

    public VmWizard(boolean invokedToUninstall, @NotNull VmType type) {
        if (type == null) {
            VmWizard.$$$reportNull$$$0(0);
        }
        super(null, null, type.toString());
        this.myType = type;
        this.myInvokedToUninstall = invokedToUninstall;
        this.myVmPath = new VmPath(type);
        this.addPath(this.myVmPath);
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    public void doCancelAction() {
        if (this.myVmPath.canPerformFinishingActions()) {
            this.doFinishAction();
            return;
        }
        if (!this.myInvokedToUninstall) {
            try {
                AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                sdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
                componentInstaller.ensureSdkPackagesUninstalled(this.myVmPath.myVm.getRequiredSdkPackages(), (ProgressIndicator)progress);
            }
            catch (Exception e) {
                Messages.showErrorDialog((String)VmWizard.sdkPackageCleanupFailedMessage(this.myType), (String)"Cleanup Error");
                LOG.warn("Failed to make sure " + this.myType + " SDK package is uninstalled after " + this.myType + " wizard was cancelled", (Throwable)e);
            }
        }
        super.doCancelAction();
    }

    @Override
    public void doFinishAction() {
        if (!this.myVmPath.canPerformFinishingActions()) {
            this.doCancelAction();
            return;
        }
        super.doFinishAction();
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return this.myType + " Installation";
    }

    private static String sdkPackageCleanupFailedMessage(@NotNull VmType type) {
        if (type == null) {
            VmWizard.$$$reportNull$$$0(1);
        }
        return type + " installer cleanup failed. The status of the package in the SDK manager may be reflected incorrectly. Reinstalling the package may solve the issue" + (SystemInfo.isWindows ? " (is the SDK folder opened in another program?)" : ".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/android/tools/idea/sdk/wizard/VmWizard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sdkPackageCleanupFailedMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class VmPath
    extends DynamicWizardPath {
        @NotNull
        SetupProgressStep mySetupProgressStep;
        @NotNull
        VmType myType;
        @NotNull
        Vm myVm;

        private VmPath(VmType type) {
            if (type == null) {
                VmPath.$$$reportNull$$$0(0);
            }
            this.myType = type;
        }

        @Override
        protected void init() {
            String key = "Show" + this.myType + "Steps";
            ScopedStateStore.Key<Boolean> canShow = ScopedStateStore.createKey(key, ScopedStateStore.Scope.PATH, Boolean.class);
            this.myState.put(canShow, true);
            InstallationIntention vmInstallationIntention = VmWizard.this.myInvokedToUninstall ? InstallationIntention.UNINSTALL : InstallationIntention.INSTALL_WITH_UPDATES;
            this.myVm = this.myType == VmType.HAXM ? new Haxm(vmInstallationIntention, this.getState(), canShow) : new Gvm(vmInstallationIntention, this.getState(), canShow);
            for (DynamicWizardStep step : this.myVm.createSteps()) {
                this.addStep(step);
            }
            if (!VmWizard.this.myInvokedToUninstall) {
                this.addStep(new LicenseAgreementStep(this.getWizard().getDisposable()));
            }
            this.mySetupProgressStep = new SetupProgressStep(this.getWizard().getDisposable(), this.myVm, VmWizard.this.myHost, this.myType);
            this.addStep(this.mySetupProgressStep);
            this.myVm.init(this.mySetupProgressStep);
        }

        @Override
        @NotNull
        public String getPathName() {
            String string = this.myType + " Path";
            if (string == null) {
                VmPath.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean canPerformFinishingActions() {
            return this.mySetupProgressStep.isSuccessfullyCompleted();
        }

        @Override
        public boolean performFinishingActions() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/sdk/wizard/VmWizard$VmPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/sdk/wizard/VmWizard$VmPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SetupProgressStep
    extends ProgressStep {
        @NotNull
        VmType myType;
        @NotNull
        private Vm myVm;
        @NotNull
        private final AtomicBoolean myIsSuccessfullyCompleted;
        @NotNull
        private DynamicWizardHost myHost;
        @NotNull
        private StudioLoggerProgressIndicator myProgressIndicator;

        SetupProgressStep(@NotNull Disposable parentDisposable, @NotNull Vm vm, @NotNull DynamicWizardHost host, @NotNull VmType type) {
            if (parentDisposable == null) {
                SetupProgressStep.$$$reportNull$$$0(0);
            }
            if (vm == null) {
                SetupProgressStep.$$$reportNull$$$0(1);
            }
            if (host == null) {
                SetupProgressStep.$$$reportNull$$$0(2);
            }
            if (type == null) {
                SetupProgressStep.$$$reportNull$$$0(3);
            }
            super(parentDisposable, "Invoking installer");
            this.myIsSuccessfullyCompleted = new AtomicBoolean(false);
            this.myType = type;
            this.myVm = vm;
            this.myHost = host;
            this.myProgressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        public boolean isSuccessfullyCompleted() {
            return this.myIsSuccessfullyCompleted.get();
        }

        @Override
        protected void execute() {
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, () -> {
                try {
                    this.setupVm();
                    this.myIsSuccessfullyCompleted.set(this.myVm.isInstallerSuccessfullyCompleted());
                }
                catch (Exception e) {
                    DynamicWizard.LOG.warn("Exception caught while trying to configure " + this.myType, (Throwable)e);
                    this.showConsole();
                    this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        private void setupVm() throws IOException {
            InstallOperation opChain;
            File tmpDir = FileUtil.createTempDirectory((String)PlatformUtils.getPlatformPrefix(), (String)this.myType.toString(), (boolean)true);
            InstallContext installContext = new InstallContext(tmpDir, this);
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            this.myVm.updateState(sdkHandler);
            ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
            ArrayList selectedComponents = Lists.newArrayList((Object[])new Vm[]{this.myVm});
            double configureVmProgressRatio = 1.0;
            if (this.myVm.installationIntention == InstallationIntention.INSTALL_WITH_UPDATES) {
                configureVmProgressRatio = 0.5;
            }
            InstallOperation configureVmOperation = InstallOperation.wrap(installContext, input -> {
                this.myVm.configure(installContext, sdkHandler);
                return input;
            }, configureVmProgressRatio);
            if (this.myVm.installationIntention == InstallationIntention.INSTALL_WITH_UPDATES) {
                InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, componentInstaller, 0.5);
                opChain = install.then(configureVmOperation);
            } else {
                opChain = configureVmOperation;
            }
            try {
                opChain.execute(sdkHandler.getLocation());
            }
            catch (InstallationCancelledException e) {
                installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            }
            catch (WizardException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.myVm.isInstallerSuccessfullyCompleted() && this.myVm.installationIntention != InstallationIntention.UNINSTALL) {
                    try {
                        sdkHandler.getSdkManager((ProgressIndicator)this.myProgressIndicator).reloadLocalIfNeeded((ProgressIndicator)this.myProgressIndicator);
                        componentInstaller.ensureSdkPackagesUninstalled(this.myVm.getRequiredSdkPackages(), (ProgressIndicator)this.myProgressIndicator);
                    }
                    catch (WizardException e) {
                        DynamicWizard.LOG.warn(this.myType + " SDK package cleanup failed due to an exception", (Throwable)e);
                        installContext.print(VmWizard.sdkPackageCleanupFailedMessage(this.myType), ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            }
            installContext.print("Done", ConsoleViewContentType.NORMAL_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vm";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "host";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/sdk/wizard/VmWizard$SetupProgressStep";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

