/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcDatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0003J\b\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\n0\u00162\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0016R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R.\u0010\u0015\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \u0017*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n0\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00110\u00110\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "service", "Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;", "connection", "Ljava/sql/Connection;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "(Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;Ljava/sql/Connection;Lcom/android/tools/idea/sqlite/model/SqliteStatement;)V", "_columns", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "get_columns", "()Ljava/util/List;", "_columns$delegate", "Lkotlin/Lazy;", "_rowCount", "", "get_rowCount", "()I", "_rowCount$delegate", "columns", "Lcom/google/common/util/concurrent/ListenableFuture;", "kotlin.jvm.PlatformType", "getColumns", "()Lcom/google/common/util/concurrent/ListenableFuture;", "rowCount", "getRowCount", "createCurrentRow", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "resultSet", "Ljava/sql/ResultSet;", "dispose", "", "getRowBatch", "rowOffset", "rowBatchSize", "intellij.android.debuggers"})
public final class JdbcSqliteResultSet
implements SqliteResultSet {
    private final Lazy _columns$delegate;
    private final Lazy _rowCount$delegate;
    private final JdbcDatabaseConnection service;
    private final Connection connection;
    private final SqliteStatement sqliteStatement;

    private final List<SqliteColumn> get_columns() {
        Lazy lazy = this._columns$delegate;
        JdbcSqliteResultSet jdbcSqliteResultSet = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private final int get_rowCount() {
        Lazy lazy = this._rowCount$delegate;
        JdbcSqliteResultSet jdbcSqliteResultSet = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @NotNull
    public ListenableFuture<List<SqliteColumn>> getColumns() {
        ListenableFuture listenableFuture = this.service.getSequentialTaskExecutor().executeAsync((Callable)new Callable<List<? extends SqliteColumn>>(this){
            final /* synthetic */ JdbcSqliteResultSet this$0;

            public final List<SqliteColumn> call() {
                return JdbcSqliteResultSet.access$get_columns$p(this.this$0);
            }
            {
                this.this$0 = jdbcSqliteResultSet;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"service.sequentialTaskEx\u2026executeAsync { _columns }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> getRowCount() {
        ListenableFuture listenableFuture = this.service.getSequentialTaskExecutor().executeAsync((Callable)new Callable<Integer>(this){
            final /* synthetic */ JdbcSqliteResultSet this$0;

            public final Integer call() {
                return JdbcSqliteResultSet.access$get_rowCount$p(this.this$0);
            }
            {
                this.this$0 = jdbcSqliteResultSet;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"service.sequentialTaskEx\u2026xecuteAsync { _rowCount }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<List<SqliteRow>> getRowBatch(int rowOffset, int rowBatchSize) {
        boolean bl = rowOffset >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Offset must be >= 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = rowBatchSize > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Row batch size must be > 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ListenableFuture listenableFuture = this.service.getSequentialTaskExecutor().executeAsync((Callable)new Callable<List<? extends SqliteRow>>(this, rowOffset, rowBatchSize){
            final /* synthetic */ JdbcSqliteResultSet this$0;
            final /* synthetic */ int $rowOffset;
            final /* synthetic */ int $rowBatchSize;

            public final List<SqliteRow> call() {
                boolean bl = !Disposer.isDisposed((Disposable)this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "ResultSet has already been closed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl = !JdbcSqliteResultSet.access$getConnection$p(this.this$0).isClosed();
                bl2 = false;
                bl3 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "The connection has been closed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String limitOffsetQuery = "SELECT * FROM (" + JdbcSqliteResultSet.access$getSqliteStatement$p(this.this$0).getSqliteStatementText() + ") LIMIT " + this.$rowOffset + ", " + this.$rowBatchSize;
                PreparedStatement preparedStatement = JdbcUtilsKt.resolvePreparedStatement(JdbcSqliteResultSet.access$getConnection$p(this.this$0), new SqliteStatement(limitOffsetQuery, JdbcSqliteResultSet.access$getSqliteStatement$p(this.this$0).getParametersValues()));
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<SqliteRow> rows = new ArrayList<SqliteRow>();
                while (resultSet.next()) {
                    ResultSet resultSet2 = resultSet;
                    Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"resultSet");
                    rows.add(JdbcSqliteResultSet.access$createCurrentRow(this.this$0, resultSet2));
                }
                resultSet.close();
                preparedStatement.close();
                return rows;
            }
            {
                this.this$0 = jdbcSqliteResultSet;
                this.$rowOffset = n;
                this.$rowBatchSize = n2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"service.sequentialTaskEx\u2026close()\n\n      rows\n    }");
        return listenableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final SqliteRow createCurrentRow(ResultSet resultSet) {
        Collection<SqliteColumnValue> collection2;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.get_columns();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i2;
            void column;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqliteColumn sqliteColumn = (SqliteColumn)item$iv$iv;
            int n2 = n;
            collection2 = destination$iv$iv;
            boolean bl2 = false;
            SqliteColumnValue sqliteColumnValue = new SqliteColumnValue((SqliteColumn)column, resultSet.getObject((int)(i2 + true)));
            collection2.add(sqliteColumnValue);
        }
        collection2 = (List)destination$iv$iv;
        List list = collection2;
        return new SqliteRow(list);
    }

    public void dispose() {
    }

    public JdbcSqliteResultSet(@NotNull JdbcDatabaseConnection service, @NotNull Connection connection, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.service = service;
        this.connection = connection;
        this.sqliteStatement = sqliteStatement;
        this._columns$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends SqliteColumn>>(this){
            final /* synthetic */ JdbcSqliteResultSet this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<SqliteColumn> invoke() {
                void $this$mapTo$iv$iv;
                ResultSet resultSet;
                PreparedStatement preparedStatement = JdbcUtilsKt.resolvePreparedStatement(JdbcSqliteResultSet.access$getConnection$p(this.this$0), JdbcSqliteResultSet.access$getSqliteStatement$p(this.this$0));
                ResultSet resultSet2 = resultSet = preparedStatement.executeQuery();
                Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"resultSet");
                ResultSetMetaData metaData = resultSet2.getMetaData();
                int n = 1;
                ResultSetMetaData resultSetMetaData = metaData;
                Intrinsics.checkNotNullExpressionValue((Object)resultSetMetaData, (String)"metaData");
                Iterable $this$map$iv = (Iterable)new IntRange(n, resultSetMetaData.getColumnCount());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void i2;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    String tableName = metaData.getTableName((int)i2);
                    String columnName = metaData.getColumnName((int)i2);
                    Connection connection = JdbcSqliteResultSet.access$getConnection$p(this.this$0);
                    String string = tableName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tableName");
                    List<String> keyColumnsNames = JdbcUtilsKt.getColumnNamesInPrimaryKey(connection, string);
                    String string2 = metaData.getColumnName((int)i2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"metaData.getColumnName(i)");
                    JDBCType jDBCType = JDBCType.valueOf(metaData.getColumnType((int)i2));
                    Intrinsics.checkNotNullExpressionValue((Object)jDBCType, (String)"JDBCType.valueOf(metaData.getColumnType(i))");
                    SqliteColumn sqliteColumn = new SqliteColumn(string2, jDBCType, keyColumnsNames.contains(columnName));
                    collection2.add(sqliteColumn);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = jdbcSqliteResultSet;
                super(0);
            }
        }));
        this._rowCount$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ JdbcSqliteResultSet this$0;

            public final int invoke() {
                boolean bl = !Disposer.isDisposed((Disposable)this.this$0);
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "ResultSet has already been closed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl = !JdbcSqliteResultSet.access$getConnection$p(this.this$0).isClosed();
                bl2 = false;
                bl3 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "The connection has been closed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String countQuery = "SELECT COUNT(*) FROM (" + JdbcSqliteResultSet.access$getSqliteStatement$p(this.this$0).getSqliteStatementText() + ')';
                PreparedStatement preparedStatement = JdbcUtilsKt.resolvePreparedStatement(JdbcSqliteResultSet.access$getConnection$p(this.this$0), new SqliteStatement(countQuery, JdbcSqliteResultSet.access$getSqliteStatement$p(this.this$0).getParametersValues()));
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                int count = resultSet.getInt(1);
                resultSet.close();
                preparedStatement.close();
                return count;
            }
            {
                this.this$0 = jdbcSqliteResultSet;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ List access$get_columns$p(JdbcSqliteResultSet $this) {
        return $this.get_columns();
    }

    public static final /* synthetic */ int access$get_rowCount$p(JdbcSqliteResultSet $this) {
        return $this.get_rowCount();
    }

    public static final /* synthetic */ Connection access$getConnection$p(JdbcSqliteResultSet $this) {
        return $this.connection;
    }

    public static final /* synthetic */ SqliteStatement access$getSqliteStatement$p(JdbcSqliteResultSet $this) {
        return $this.sqliteStatement;
    }

    public static final /* synthetic */ SqliteRow access$createCurrentRow(JdbcSqliteResultSet $this, ResultSet resultSet) {
        return $this.createCurrentRow(resultSet);
    }
}

