/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.CreateClassAction;
import com.android.tools.idea.actions.MakeIdeaModuleAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.GcPauseWatcher;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationProducer;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioInitializer
implements Runnable {
    @Override
    public void run() {
        AndroidStudioInitializer.checkInstallation();
        AndroidStudioInitializer.setUpNewFilePopupActions();
        AndroidStudioInitializer.setUpMakeActions();
        AndroidStudioInitializer.disableGroovyLanguageInjection();
        if (((Boolean)StudioFlags.CUSTOM_JAVA_NEW_CLASS_DIALOG.get()).booleanValue()) {
            AndroidStudioInitializer.replaceNewClassDialog();
        }
        AndroidStudioInitializer.setupAnalytics();
        AndroidStudioInitializer.disableIdeaJUnitConfigurations();
        AndroidStudioInitializer.hideRarelyUsedIntellijActions();
        AndroidStudioInitializer.setupResourceManagerActions();
        if (((Boolean)StudioFlags.TWEAK_COLOR_SCHEME.get()).booleanValue()) {
            AndroidStudioInitializer.tweakDefaultColorScheme();
        }
    }

    private static void tweakDefaultColorScheme() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        TextAttributes xmlTagAttributes = colorsScheme.getAttributes(XmlHighlighterColors.XML_TAG);
        xmlTagAttributes.setBackgroundColor(textAttributes.getBackgroundColor());
    }

    private static void setupResourceManagerActions() {
        Actions.hideAction("Images.ShowThumbnails");
        AnAction servicesAction = ActionManager.getInstance().getAction("ServiceView.ShowServices");
        Actions.replaceAction("ServiceView.ShowServices", servicesAction);
    }

    private static void setupAnalytics() {
        Application application;
        if (!(AnalyticsSettings.getOptedIn() || (application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment() || Boolean.getBoolean("disable.android.analytics.consent.dialog.for.test"))) {
            AppUIUtil.showConsentsAgreementIfNeeded((Logger)AndroidStudioInitializer.getLog());
        }
        application = ApplicationInfo.getInstance();
        UsageTracker.setVersion((String)application.getStrictVersion());
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioInitializer.getIdeBrand());
        if (ApplicationManager.getApplication().isInternal()) {
            UsageTracker.setIdeaIsInternal((boolean)true);
        }
        AndroidStudioUsageTracker.setup(JobScheduler.getScheduler());
        new GcPauseWatcher();
    }

    private static AndroidStudioEvent.IdeBrand getIdeBrand() {
        return Arrays.stream(PluginManagerCore.getPlugins()).anyMatch(plugin -> plugin.isBundled() && plugin.getName().contains("Blaze")) ? AndroidStudioEvent.IdeBrand.ANDROID_STUDIO_WITH_BLAZE : AndroidStudioEvent.IdeBrand.ANDROID_STUDIO;
    }

    private static void checkInstallation() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            AndroidStudioInitializer.getLog().info("Unable to find Studio home directory");
            return;
        }
        File studioHomePath = FilePaths.toSystemDependentPath((String)studioHome);
        if (!studioHomePath.isDirectory()) {
            AndroidStudioInitializer.getLog().info(String.format("The path '%1$s' does not belong to an existing directory", studioHomePath.getPath()));
            return;
        }
        File androidPluginLibFolderPath = new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android", "lib"}));
        if (!androidPluginLibFolderPath.isDirectory()) {
            AndroidStudioInitializer.getLog().info(String.format("The path '%1$s' does not belong to an existing directory", androidPluginLibFolderPath.getPath()));
            return;
        }
        if (new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android-designer"})).exists()) {
            String msg = "Your Android Studio installation is corrupt and will not work properly.\n(Found plugins/android-designer which should not be present.)\nThis usually happens if Android Studio is extracted into an existing older version.\n\nPlease reinstall (and make sure the new installation directory is empty first.)";
            String title = "Corrupt Installation";
            int option = Messages.showDialog((String)msg, (String)title, (String[])new String[]{"Quit", "Proceed Anyway"}, (int)0, (Icon)Messages.getErrorIcon());
            if (option == 0) {
                ApplicationManager.getApplication().exit();
            }
        }
    }

    private static void setUpNewFilePopupActions() {
        Actions.hideAction("NewHtmlFile");
        Actions.hideAction("NewPackageInfo");
        Actions.hideAction("NewForm");
        Actions.hideAction("NewDialog");
        Actions.hideAction("NewFormSnapshot");
        Actions.hideAction("Groovy.NewClass");
        Actions.hideAction("Groovy.NewScript");
    }

    private static void setUpMakeActions() {
        Actions.hideAction("CompileDirty");
        Actions.replaceAction("MakeModule", new MakeIdeaModuleAction());
        Actions.hideAction("CompileProject");
        Actions.hideAction("Compile");
    }

    private static void disableGroovyLanguageInjection() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExtensionPoint extensionPoint = MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getPoint((AreaInstance)project);
                for (MultiHostInjector injector : (MultiHostInjector[])extensionPoint.getExtensions()) {
                    if (!(injector instanceof GrConcatenationInjector)) continue;
                    extensionPoint.unregisterExtension(injector.getClass());
                    return;
                }
                AndroidStudioInitializer.getLog().info("Failed to disable 'org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector'");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/startup/AndroidStudioInitializer$1", "projectOpened"));
            }
        });
    }

    private static void replaceNewClassDialog() {
        Actions.replaceAction("NewClass", new CreateClassAction());
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        for (String templateName : new String[]{"Singleton", "Class", "Interface", "Enum", "AnnotationType"}) {
            FileTemplate template = fileTemplateManager.getInternalTemplate(templateName);
            template.setText(fileTemplateManager.getJ2eeTemplate(templateName).getText());
        }
    }

    private static void disableIdeaJUnitConfigurations() {
        ExtensionPoint configurationProducerExtensionPoint = RunConfigurationProducer.EP_NAME.getPoint();
        for (RunConfigurationProducer runConfigurationProducer : (RunConfigurationProducer[])configurationProducerExtensionPoint.getExtensions()) {
            if (!(runConfigurationProducer instanceof JUnitConfigurationProducer) || runConfigurationProducer instanceof AndroidJUnitConfigurationProducer) continue;
            configurationProducerExtensionPoint.unregisterExtension(runConfigurationProducer.getClass());
        }
        ExtensionPoint configurationTypeExtensionPoint = ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
        for (ConfigurationType configurationType : (ConfigurationType[])configurationTypeExtensionPoint.getExtensions()) {
            if (!(configurationType instanceof JUnitConfigurationType) || configurationType instanceof AndroidJUnitConfigurationType) continue;
            configurationTypeExtensionPoint.unregisterExtension(configurationType.getClass());
        }
        Actions.hideAction("excludeFromSuite");
        Actions.hideAction("AddToISuite");
    }

    private static void hideRarelyUsedIntellijActions() {
        Actions.hideAction("SaveFileAsTemplate");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(AndroidStudioInitializer.class);
        if (logger2 == null) {
            AndroidStudioInitializer.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/startup/AndroidStudioInitializer", "getLog"));
    }
}

