/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.stats.EditorStatsUtil$WhenMappings;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getEditorFileTypeForAnalytics", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.core"})
@JvmName(name="EditorStatsUtil")
public final class EditorStatsUtil {
    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final EditorFileType getEditorFileTypeForAnalytics(@NotNull VirtualFile file) {
        EditorFileType editorFileType;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        switch (fileType.getName()) {
            case "JAVA": {
                editorFileType = EditorFileType.JAVA;
                return editorFileType;
            }
            case "Kotlin": {
                if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"kts")) {
                    editorFileType = EditorFileType.KOTLIN_SCRIPT;
                    return editorFileType;
                }
                editorFileType = EditorFileType.KOTLIN;
                return editorFileType;
            }
            case "Groovy": {
                editorFileType = EditorFileType.GROOVY;
                return editorFileType;
            }
            case "Properties": {
                editorFileType = EditorFileType.PROPERTIES;
                return editorFileType;
            }
            case "JSON": {
                editorFileType = EditorFileType.JSON;
                return editorFileType;
            }
            case "ObjectiveC": {
                editorFileType = EditorFileType.NATIVE;
                return editorFileType;
            }
            case "XML": {
                ResourceFolderType resourceFolderType = ResourceHelper.getFolderType(file);
                if (resourceFolderType == null) {
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml")) {
                        editorFileType = EditorFileType.XML;
                        return editorFileType;
                    }
                } else {
                    switch (EditorStatsUtil$WhenMappings.$EnumSwitchMapping$0[resourceFolderType.ordinal()]) {
                        case 1: {
                            editorFileType = EditorFileType.XML_RES_ANIM;
                            return editorFileType;
                        }
                        case 2: {
                            editorFileType = EditorFileType.XML_RES_ANIMATOR;
                            return editorFileType;
                        }
                        case 3: {
                            editorFileType = EditorFileType.XML_RES_COLOR;
                            return editorFileType;
                        }
                        case 4: {
                            editorFileType = EditorFileType.XML_RES_DRAWABLE;
                            return editorFileType;
                        }
                        case 5: {
                            editorFileType = EditorFileType.XML_RES_FONT;
                            return editorFileType;
                        }
                        case 6: {
                            editorFileType = EditorFileType.XML_RES_INTERPOLATOR;
                            return editorFileType;
                        }
                        case 7: {
                            editorFileType = EditorFileType.XML_RES_LAYOUT;
                            return editorFileType;
                        }
                        case 8: {
                            editorFileType = EditorFileType.XML_RES_MENU;
                            return editorFileType;
                        }
                        case 9: {
                            editorFileType = EditorFileType.XML_RES_MIPMAP;
                            return editorFileType;
                        }
                        case 10: {
                            editorFileType = EditorFileType.XML_RES_NAVIGATION;
                            return editorFileType;
                        }
                        case 11: {
                            editorFileType = EditorFileType.XML_RES_RAW;
                            return editorFileType;
                        }
                        case 12: {
                            editorFileType = EditorFileType.XML_RES_TRANSITION;
                            return editorFileType;
                        }
                        case 13: {
                            editorFileType = EditorFileType.XML_RES_VALUES;
                            return editorFileType;
                        }
                        case 14: {
                            editorFileType = EditorFileType.XML_RES_XML;
                            return editorFileType;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                editorFileType = EditorFileType.XML_MANIFEST;
                return editorFileType;
            }
        }
        editorFileType = EditorFileType.UNKNOWN;
        return editorFileType;
    }
}

