/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import com.intellij.openapi.util.io.FileUtil;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioTemplateLoader
implements TemplateLoader {
    private final File myTemplateRootFolder;
    private final Stack<File> myLastTemplateFolders;
    private static final String ROOT = "root://";
    private static final String ROOT_FILE = "root:" + File.separator;

    public StudioTemplateLoader(@NotNull File templateFolder) {
        if (templateFolder == null) {
            StudioTemplateLoader.$$$reportNull$$$0(0);
        }
        this.myTemplateRootFolder = StudioTemplateLoader.findTemplateRootFolder(templateFolder);
        this.myLastTemplateFolders = new Stack();
        this.myLastTemplateFolders.push(templateFolder);
    }

    public void pushTemplateFolder(@NotNull File folder) {
        if (folder == null) {
            StudioTemplateLoader.$$$reportNull$$$0(1);
        }
        this.myLastTemplateFolders.push(folder);
    }

    public void pushTemplateFolder(@NotNull String folderName) throws IOException {
        if (folderName == null) {
            StudioTemplateLoader.$$$reportNull$$$0(2);
        }
        this.myLastTemplateFolders.push(this.resolveName(folderName));
    }

    public void popTemplateFolder() {
        this.myLastTemplateFolders.pop();
    }

    @NotNull
    public String findTemplate(@NotNull File file) throws IOException {
        String path2;
        if (file == null) {
            StudioTemplateLoader.$$$reportNull$$$0(3);
        }
        if (!file.isAbsolute()) {
            file = this.resolveName(file.getPath());
        }
        if ((path2 = FileUtil.getRelativePath((File)this.myTemplateRootFolder, (File)file)) == null) {
            throw new IOException("Absolute paths must start with: " + this.myTemplateRootFolder.getPath());
        }
        String string = ROOT + FileUtil.toSystemIndependentName((String)path2);
        if (string == null) {
            StudioTemplateLoader.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public File getSourceFile(@NotNull File file) throws IOException {
        if (file == null) {
            StudioTemplateLoader.$$$reportNull$$$0(5);
        }
        String name = this.findTemplate(file);
        return this.resolveName(name);
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        if (name == null) {
            StudioTemplateLoader.$$$reportNull$$$0(6);
        }
        File file = this.resolveName(name);
        TemplateSource templateSource = TemplateSource.open(file);
        this.pushTemplateFolder(file.getParentFile());
        return templateSource;
    }

    public long getLastModified(Object source) {
        TemplateSource templateSource = (TemplateSource)source;
        return templateSource.getLastModified();
    }

    @NotNull
    public Reader getReader(@NotNull Object source, @NotNull String encoding) throws IOException {
        if (source == null) {
            StudioTemplateLoader.$$$reportNull$$$0(7);
        }
        if (encoding == null) {
            StudioTemplateLoader.$$$reportNull$$$0(8);
        }
        TemplateSource templateSource = (TemplateSource)source;
        return new InputStreamReader(templateSource.getInputStream(), encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        TemplateSource templateSource = (TemplateSource)source;
        this.popTemplateFolder();
        templateSource.close();
    }

    @NotNull
    private File resolveName(@NotNull String name) throws IOException {
        if (name == null) {
            StudioTemplateLoader.$$$reportNull$$$0(9);
        }
        File file = name.startsWith(ROOT) ? new File(this.myTemplateRootFolder, name.substring(ROOT.length())) : (name.startsWith(ROOT_FILE) ? new File(this.myTemplateRootFolder, name.substring(ROOT_FILE.length())) : (this.myLastTemplateFolders != null ? new File(this.myLastTemplateFolders.peek(), name) : new File(this.myTemplateRootFolder, name)));
        File file2 = file;
        if (file2 == null) {
            StudioTemplateLoader.$$$reportNull$$$0(10);
        }
        return file2;
    }

    @NotNull
    private static File findTemplateRootFolder(@NotNull File templateFolder) {
        File folder;
        if (templateFolder == null) {
            StudioTemplateLoader.$$$reportNull$$$0(11);
        }
        for (folder = templateFolder; folder != null && !folder.getName().equals("templates"); folder = folder.getParentFile()) {
        }
        File file = folder != null ? folder : templateFolder;
        if (file == null) {
            StudioTemplateLoader.$$$reportNull$$$0(12);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/StudioTemplateLoader";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/StudioTemplateLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findTemplateRootFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pushTemplateFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTemplate";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReader";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateRootFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TemplateSource {
        private final InputStream myInputStream;
        private final long myLastModifiedTime;

        private TemplateSource(@NotNull InputStream inputStream, long lastModified) {
            if (inputStream == null) {
                TemplateSource.$$$reportNull$$$0(0);
            }
            this.myInputStream = inputStream;
            this.myLastModifiedTime = lastModified;
        }

        public static TemplateSource open(@NotNull File file) throws IOException {
            if (file == null) {
                TemplateSource.$$$reportNull$$$0(1);
            }
            if (!file.exists() && !file.isFile()) {
                return null;
            }
            return new TemplateSource(SdkUtils.fileToUrl((File)file).openStream(), file.lastModified());
        }

        @NotNull
        public InputStream getInputStream() {
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                TemplateSource.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        public long getLastModified() {
            return this.myLastModifiedTime;
        }

        public void close() throws IOException {
            this.myInputStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputStream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/templates/StudioTemplateLoader$TemplateSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/templates/StudioTemplateLoader$TemplateSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "open";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

