/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.templates.Parameter;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateMetadata {
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_FORM_FACTOR = "formfactor";
    public static final String ATTR_DEPENDENCIES_MULTIMAP = "dependenciesMultimap";
    private static final String ATTR_TEMPLATE_REVISION = "revision";
    private static final String ATTR_MIN_BUILD_API = "minBuildApi";
    private static final String ATTR_MIN_API = "minApi";
    private final Document myDocument;
    private final Map<String, Parameter> myParameterMap;
    private String myFormFactor;
    private String myCategory;
    private final Multimap<Parameter, Parameter> myRelatedParameters;

    TemplateMetadata(@NotNull Document document) {
        NodeList formFactors2;
        Element element;
        Element element2;
        if (document == null) {
            TemplateMetadata.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        NodeList parameters2 = this.myDocument.getElementsByTagName("parameter");
        this.myParameterMap = new LinkedHashMap<String, Parameter>(parameters2.getLength());
        int max = parameters2.getLength();
        for (int index = 0; index < max; ++index) {
            element2 = (Element)parameters2.item(index);
            Parameter parameter = new Parameter(this, element2);
            if (parameter.id == null) continue;
            this.myParameterMap.put(parameter.id, parameter);
        }
        NodeList categories = this.myDocument.getElementsByTagName(TAG_CATEGORY);
        if (categories.getLength() > 0 && (element = (Element)categories.item(0)).hasAttribute("value")) {
            this.myCategory = element.getAttribute("value");
        }
        if ((formFactors2 = this.myDocument.getElementsByTagName(TAG_FORM_FACTOR)).getLength() > 0 && (element2 = (Element)formFactors2.item(0)).hasAttribute("value")) {
            this.myFormFactor = element2.getAttribute("value");
        }
        this.myRelatedParameters = this.computeRelatedParameters();
    }

    private Multimap<Parameter, Parameter> computeRelatedParameters() {
        ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
        for (Parameter p : this.myParameterMap.values()) {
            for (Parameter p2 : this.myParameterMap.values()) {
                if (p == p2 || !p.isRelated(p2)) continue;
                builder2.put((Object)p, (Object)p2);
            }
        }
        return builder2.build();
    }

    @Nullable
    public String getTitle() {
        return this.getAttrNonEmpty("name");
    }

    @Nullable
    public String getDescription() {
        return this.getAttrNonEmpty("description");
    }

    public int getMinSdk() {
        return this.getInteger(ATTR_MIN_API, 1);
    }

    public int getMinBuildApi() {
        return this.getInteger(ATTR_MIN_BUILD_API, 1);
    }

    @NotNull
    public EnumSet<TemplateConstraint> getConstraints() {
        String constraintString = this.myDocument.getDocumentElement().getAttribute("constraints");
        if (!Strings.isNullOrEmpty((String)constraintString)) {
            ArrayList<TemplateConstraint> constraintsList = new ArrayList<TemplateConstraint>();
            for (String constraint : Splitter.on((char)'|').omitEmptyStrings().trimResults().split((CharSequence)constraintString)) {
                constraintsList.add(TemplateConstraint.valueOf(constraint.toUpperCase(Locale.US)));
            }
            EnumSet<TemplateConstraint> enumSet = EnumSet.copyOf(constraintsList);
            if (enumSet == null) {
                TemplateMetadata.$$$reportNull$$$0(1);
            }
            return enumSet;
        }
        EnumSet<TemplateConstraint> enumSet = EnumSet.noneOf(TemplateConstraint.class);
        if (enumSet == null) {
            TemplateMetadata.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    public int getRevision() {
        return this.getInteger(ATTR_TEMPLATE_REVISION, 1);
    }

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Nullable
    public String getFormFactor() {
        return this.myFormFactor;
    }

    @Nullable
    public String getThumbnailPath() {
        return this.getThumbnailPath(null);
    }

    @Nullable
    public String getThumbnailPath(Function<String, Object> produceParameterValue) {
        NodeList thumbs = this.myDocument.getElementsByTagName("thumb");
        if (thumbs.getLength() == 0) {
            return null;
        }
        int bestMatchCount = 0;
        Node bestMatch = null;
        int n = thumbs.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Element thumb = (Element)thumbs.item(i2);
            NamedNodeMap attributes = thumb.getAttributes();
            if (bestMatch == null && attributes.getLength() == 0) {
                bestMatch = thumb;
                continue;
            }
            if (attributes.getLength() <= bestMatchCount) continue;
            boolean match2 = true;
            int max = attributes.getLength();
            for (int j = 0; j < max; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                String variableName = attribute.getName();
                String thumbNailValue = attribute.getValue();
                if (produceParameterValue != null && thumbNailValue.equals(produceParameterValue.apply((Object)variableName))) continue;
                match2 = false;
                break;
            }
            if (!match2) continue;
            bestMatch = thumb;
            bestMatchCount = attributes.getLength();
        }
        if (bestMatch != null) {
            NodeList children = bestMatch.getChildNodes();
            int n2 = children.getLength();
            for (int i3 = 0; i3 < n2; ++i3) {
                Node child = children.item(i3);
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue().trim();
            }
        }
        return null;
    }

    public boolean isSupported() {
        String versionString = this.myDocument.getDocumentElement().getAttribute("format");
        if (versionString != null && !versionString.isEmpty()) {
            try {
                int version2 = Integer.parseInt(versionString);
                return version2 <= 5;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public boolean useImplicitRootFolder() {
        String format = this.myDocument.getDocumentElement().getAttribute("format");
        if (format == null || format.isEmpty()) {
            return true;
        }
        try {
            int version2 = Integer.parseInt(format);
            return version2 < 5;
        }
        catch (NumberFormatException ignore) {
            return true;
        }
    }

    @NotNull
    public Collection<Parameter> getParameters() {
        Collection<Parameter> collection2 = this.myParameterMap.values();
        if (collection2 == null) {
            TemplateMetadata.$$$reportNull$$$0(3);
        }
        return collection2;
    }

    @Nullable
    public Parameter getParameter(@NotNull String id) {
        if (id == null) {
            TemplateMetadata.$$$reportNull$$$0(4);
        }
        return this.myParameterMap.get(id);
    }

    @Nullable
    private String getAttrNonEmpty(@NotNull String attrName) {
        String attr;
        if (attrName == null) {
            TemplateMetadata.$$$reportNull$$$0(5);
        }
        return (attr = this.myDocument.getDocumentElement().getAttribute(attrName)) == null || attr.isEmpty() ? null : attr;
    }

    private int getInteger(@NotNull String attrName, int defaultValue2) {
        if (attrName == null) {
            TemplateMetadata.$$$reportNull$$$0(6);
        }
        try {
            return Integer.parseInt(this.myDocument.getDocumentElement().getAttribute(attrName));
        }
        catch (NumberFormatException nfe) {
            return defaultValue2;
        }
        catch (RuntimeException e) {
            return defaultValue2;
        }
    }

    @NotNull
    public static String getBuildApiString(@NotNull AndroidVersion version2) {
        if (version2 == null) {
            TemplateMetadata.$$$reportNull$$$0(7);
        }
        String string = version2.isPreview() ? AndroidTargetHash.getPlatformHashString((AndroidVersion)version2) : version2.getApiString();
        if (string == null) {
            TemplateMetadata.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Collection<Parameter> getRelatedParams(Parameter param) {
        Collection collection2 = this.myRelatedParameters.get((Object)param);
        if (collection2 == null) {
            TemplateMetadata.$$$reportNull$$$0(9);
        }
        return collection2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/TemplateMetadata";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/TemplateMetadata";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraints";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildApiString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttrNonEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuildApiString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TemplateConstraint {
        ANDROIDX,
        KOTLIN;

    }
}

