/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.StringFileAdapter;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeInstruction;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="recipe")
public class Recipe
implements RecipeInstruction {
    @XmlElements(value={@XmlElement(name="copy", type=CopyInstruction.class), @XmlElement(name="instantiate", type=InstantiateInstruction.class), @XmlElement(name="merge", type=MergeInstruction.class), @XmlElement(name="mkdir", type=MkDirInstruction.class), @XmlElement(name="open", type=OpenInstruction.class), @XmlElement(name="recipe", type=Recipe.class), @XmlElement(name="global", type=GlobalInstruction.class), @XmlElement(name="apply", type=ApplyInstruction.class), @XmlElement(name="classpath", type=ClasspathInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class), @XmlElement(name="moduleDependency", type=ModuleDependencyInstruction.class), @XmlElement(name="sourceSet", type=SourceSetInstruction.class), @XmlElement(name="setExtVar", type=SetExtVarInstruction.class), @XmlElement(name="addIncludeToSettings", type=AddIncludeToSettingsInstruction.class), @XmlElement(name="setBuildFeature", type=SetBuildFeatureInstruction.class), @XmlElement(name="requireJavaVersion", type=RequireJavaVersionInstruction.class), @XmlElement(name="addDynamicFeature", type=AddDynamicFeatureInstruction.class)})
    private List<RecipeInstruction> instructions = new ArrayList<RecipeInstruction>();
    @XmlAttribute(name="folder")
    @Nullable
    private String myFolder;

    public static Recipe parse(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            Recipe.$$$reportNull$$$0(0);
        }
        Recipe recipe2 = Recipe.unmarshal(xmlReader);
        recipe2.addUpdateAndSyncGradleInstruction();
        return recipe2;
    }

    private static Recipe unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            Recipe.$$$reportNull$$$0(1);
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Recipe.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (Recipe)unmarshaller.unmarshal(xmlReader);
    }

    @NotNull
    private static File cloneWithoutFreemarkerSuffix(@NotNull File file) {
        if (file == null) {
            Recipe.$$$reportNull$$$0(2);
        }
        File clone = new File(file.getPath());
        File file2 = TemplateUtils.stripSuffix(clone, ".ftl");
        if (file2 == null) {
            Recipe.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @Override
    public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        if (executor == null) {
            Recipe.$$$reportNull$$$0(4);
        }
        if (this.myFolder == null) {
            this.executeInstructions(executor);
        } else {
            executor.pushFolder(this.myFolder);
            try {
                this.executeInstructions(executor);
            }
            finally {
                executor.popFolder();
            }
        }
    }

    private void executeInstructions(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        if (executor == null) {
            Recipe.$$$reportNull$$$0(5);
        }
        for (RecipeInstruction instruction : this.instructions) {
            instruction.execute(executor);
        }
    }

    public void addUpdateAndSyncGradleInstruction() {
        this.instructions.add(new UpdateAndSyncInstruction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/recipe/Recipe";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/recipe/Recipe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutFreemarkerSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "unmarshal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithoutFreemarkerSuffix";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeInstructions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateAndSyncInstruction
    implements RecipeInstruction {
        private UpdateAndSyncInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                UpdateAndSyncInstruction.$$$reportNull$$$0(0);
            }
            executor.updateAndSync();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$UpdateAndSyncInstruction", "execute"));
        }
    }

    private static final class GlobalInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String id;
        @XmlAttribute
        @NotNull
        private String value;
        @XmlAttribute
        private String type;

        private GlobalInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            TypedVariable.Type typeVariable;
            Object result2;
            if (executor == null) {
                GlobalInstruction.$$$reportNull$$$0(0);
            }
            executor.addGlobalVariable(this.id, (result2 = TypedVariable.parse(typeVariable = TypedVariable.Type.get(this.type), this.value)) != null ? result2 : this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$GlobalInstruction", "execute"));
        }
    }

    private static final class AddDynamicFeatureInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String name;
        @XmlAttribute(required=true)
        @NotNull
        private String to;

        private AddDynamicFeatureInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                AddDynamicFeatureInstruction.$$$reportNull$$$0(0);
            }
            executor.addDynamicFeature(this.name, this.to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$AddDynamicFeatureInstruction", "execute"));
        }
    }

    private static final class ModuleDependencyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String name;
        @XmlAttribute(required=true)
        @NotNull
        private String to;
        @XmlAttribute
        private String gradleConfiguration;

        private ModuleDependencyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                ModuleDependencyInstruction.$$$reportNull$$$0(0);
            }
            String configuration = (String)MoreObjects.firstNonNull((Object)this.gradleConfiguration, (Object)"compile");
            executor.addModuleDependency(configuration, this.name, this.to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$ModuleDependencyInstruction", "execute"));
        }
    }

    private static final class DependencyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;
        @XmlAttribute
        private String gradleConfiguration;

        private DependencyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                DependencyInstruction.$$$reportNull$$$0(0);
            }
            String configuration = (String)MoreObjects.firstNonNull((Object)this.gradleConfiguration, (Object)"compile");
            executor.addDependency(configuration, this.mavenUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$DependencyInstruction", "execute"));
        }
    }

    private static final class ClasspathInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;

        private ClasspathInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                ClasspathInstruction.$$$reportNull$$$0(0);
            }
            executor.addClasspath(this.mavenUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$ClasspathInstruction", "execute"));
        }
    }

    private static final class RequireJavaVersionInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String version;
        @XmlAttribute
        @Nullable
        private String kotlinSupport;

        private RequireJavaVersionInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                RequireJavaVersionInstruction.$$$reportNull$$$0(0);
            }
            executor.requireJavaVersion(this.version, this.kotlinSupport != null ? this.kotlinSupport : "false");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$RequireJavaVersionInstruction", "execute"));
        }
    }

    private static final class SetBuildFeatureInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String name;
        @XmlAttribute(required=true)
        @NotNull
        private String value;

        private SetBuildFeatureInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                SetBuildFeatureInstruction.$$$reportNull$$$0(0);
            }
            executor.setBuildFeature(this.name, this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$SetBuildFeatureInstruction", "execute"));
        }
    }

    private static final class SetExtVarInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String name;
        @XmlAttribute(required=true)
        @NotNull
        private String value;

        private SetExtVarInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                SetExtVarInstruction.$$$reportNull$$$0(0);
            }
            executor.setExtVar(this.name, this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$SetExtVarInstruction", "execute"));
        }
    }

    private static final class SourceSetInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String type;
        @XmlAttribute(required=true)
        @NotNull
        private String name;
        @XmlAttribute(required=true)
        @NotNull
        private String dir;

        private SourceSetInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                SourceSetInstruction.$$$reportNull$$$0(0);
            }
            executor.addSourceSet(this.type, this.name, this.dir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$SourceSetInstruction", "execute"));
        }
    }

    private static final class ApplyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String plugin;

        private ApplyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                ApplyInstruction.$$$reportNull$$$0(0);
            }
            executor.applyPlugin(this.plugin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$ApplyInstruction", "execute"));
        }
    }

    private static final class OpenInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File file;

        private OpenInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                OpenInstruction.$$$reportNull$$$0(0);
            }
            executor.addFilesToOpen(this.file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$OpenInstruction", "execute"));
        }
    }

    private static final class AddIncludeToSettingsInstruction
    implements RecipeInstruction {
        @XmlAttribute
        @Nullable
        private String moduleName;

        private AddIncludeToSettingsInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                AddIncludeToSettingsInstruction.$$$reportNull$$$0(0);
            }
            executor.addIncludeToSettings(this.moduleName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$AddIncludeToSettingsInstruction", "execute"));
        }
    }

    private static final class MkDirInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File at;

        private MkDirInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                MkDirInstruction.$$$reportNull$$$0(0);
            }
            executor.mkDir(this.at);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$MkDirInstruction", "execute"));
        }
    }

    private static final class MergeInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private MergeInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            if (executor == null) {
                MergeInstruction.$$$reportNull$$$0(0);
            }
            assert (this.to != null);
            executor.merge(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$MergeInstruction", "execute"));
        }
    }

    private static final class InstantiateInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private InstantiateInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            if (executor == null) {
                InstantiateInstruction.$$$reportNull$$$0(0);
            }
            assert (this.to != null);
            executor.instantiate(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$InstantiateInstruction", "execute"));
        }
    }

    private static final class CopyInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private CopyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            if (executor == null) {
                CopyInstruction.$$$reportNull$$$0(0);
            }
            assert (this.to != null);
            executor.copy(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/templates/recipe/Recipe$CopyInstruction", "execute"));
        }
    }
}

