/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite;

import com.android.tools.idea.testartifacts.instrumented.testsuite.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.AndroidTestResultsTable;
import com.android.tools.idea.testartifacts.instrumented.testsuite.AndroidTestSuiteConstantsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.google.common.base.Preconditions;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestSuiteView
implements ConsoleView,
AndroidTestResultListener {
    private JPanel myRootPanel;
    private JProgressBar myProgressBar;
    private JBLabel myStatusText;
    private JBLabel myStatusBreakdownText;
    private JPanel myTableViewContainer;
    private final AndroidTestResultsTable myTable;
    private int scheduledTestCases = 0;
    private int passedTestCases = 0;
    private int failedTestCases = 0;
    private int skippedTestCases = 0;

    public AndroidTestSuiteView() {
        this.$$$setupUI$$$();
        this.myTable = new AndroidTestResultsTable();
        this.myTableViewContainer.add(this.myTable.getComponent());
        this.updateProgress();
    }

    private void updateProgress() {
        int completedTestCases = this.passedTestCases + this.failedTestCases + this.skippedTestCases;
        if (this.scheduledTestCases == 0) {
            this.myProgressBar.setIndeterminate(true);
        } else {
            float progress = (float)completedTestCases / (float)this.scheduledTestCases;
            this.myProgressBar.setValue(Math.round((float)(this.myProgressBar.getMaximum() - this.myProgressBar.getMinimum()) * progress));
            this.myProgressBar.setIndeterminate(false);
        }
        this.myStatusText.setText(AndroidBundle.message("android.testartifacts.instrumented.testsuite.status.summary", completedTestCases));
        this.myStatusBreakdownText.setText(AndroidBundle.message("android.testartifacts.instrumented.testsuite.status.breakdown", this.failedTestCases, this.passedTestCases, this.skippedTestCases, 0));
    }

    @Override
    public void onTestSuiteScheduled(@NotNull AndroidDevice device) {
        if (device == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(0);
        }
        this.myTable.addDevice(device);
    }

    @Override
    public void onTestSuiteStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        if (device == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(1);
        }
        if (testSuite == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(2);
        }
        this.scheduledTestCases += testSuite.getTestCaseCount();
        this.updateProgress();
    }

    @Override
    public void onTestCaseStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        if (device == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(3);
        }
        if (testSuite == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(4);
        }
        if (testCase == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(5);
        }
        this.myTable.addTestCase(device, testCase);
    }

    @Override
    public void onTestCaseFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        if (device == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(6);
        }
        if (testSuite == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(7);
        }
        if (testCase == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(8);
        }
        switch ((AndroidTestCaseResult)((Object)Preconditions.checkNotNull((Object)((Object)testCase.getResult())))) {
            case PASSED: {
                ++this.passedTestCases;
                break;
            }
            case FAILED: {
                ++this.failedTestCases;
                break;
            }
            case SKIPPED: {
                ++this.skippedTestCases;
            }
        }
        this.updateProgress();
        this.myTable.refreshTable();
    }

    @Override
    public void onTestSuiteFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        if (device == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(9);
        }
        if (testSuite == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(10);
        }
        this.myTable.refreshTable();
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(11);
        }
        if (contentType == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(12);
        }
    }

    public void clear() {
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(13);
        }
        processHandler.putCopyableUserData(AndroidTestSuiteConstantsKt.ANDROID_TEST_RESULT_LISTENER_KEY, (Object)this);
    }

    public void setOutputPaused(boolean value2) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(14);
        }
        runnable2.run();
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(15);
        }
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(16);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(17);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(18);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            AndroidTestSuiteView.$$$reportNull$$$0(19);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myRootPanel;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSuite";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/testsuite/AndroidTestSuiteView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/testsuite/AndroidTestSuiteView";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onTestSuiteScheduled";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestSuiteStarted";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onTestCaseStarted";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onTestCaseFinished";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onTestSuiteFinished";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JProgressBar jProgressBar;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Status");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel3.add((Component)jProgressBar, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStatusText = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(1);
        jPanel3.add((Component)jSeparator, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 2, null, null, null));
        this.myStatusBreakdownText = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        SearchTextField searchTextField = new SearchTextField();
        jPanel3.add((Component)searchTextField, new GridConstraints(0, 6, 1, 1, 0, 0, 1, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("TODO: implement filter buttons here");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTableViewContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

