/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.icons;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderTaskContext;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.icons.AsyncIcon;
import com.android.tools.idea.ui.resourcechooser.icons.ResourceChooserColorIcon;
import com.android.tools.idea.ui.resourcechooser.icons.ResourceChooserImageIcon;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.RowIcon;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconFactory {
    private final Supplier<RenderTask> myRenderTaskSupplier;

    public IconFactory(@NotNull Supplier<RenderTask> task2) {
        if (task2 == null) {
            IconFactory.$$$reportNull$$$0(0);
        }
        this.myRenderTaskSupplier = task2;
    }

    @Nullable
    public Icon createIconFromPath(int size, int checkerboardSize, boolean interpolate, @NotNull String path2) {
        if (path2 == null) {
            IconFactory.$$$reportNull$$$0(1);
        }
        if (!IconDetector.isDrawableFile((String)path2) || path2.endsWith(".xml")) {
            return null;
        }
        if (path2.endsWith(".webp")) {
            try {
                BufferedImage image = ImageIO.read(new File(path2));
                if (image != null) {
                    return new ResourceChooserImageIcon(size, image, checkerboardSize, interpolate);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ResourceChooserImageIcon(size, new ImageIcon(path2).getImage(), checkerboardSize, interpolate);
    }

    @NotNull
    public Icon createAsyncIconFromResourceValue(int size, int checkerboardSize, boolean interpolate, @NotNull ResourceValue resourceValue2, @NotNull Icon placeHolderIcon, @Nullable Runnable onIconLoaded) {
        if (resourceValue2 == null) {
            IconFactory.$$$reportNull$$$0(2);
        }
        if (placeHolderIcon == null) {
            IconFactory.$$$reportNull$$$0(3);
        }
        ResourceType type = resourceValue2.getResourceType();
        Icon icon2 = null;
        if (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP) {
            int width = size;
            int height = size;
            RenderTask renderTask = this.myRenderTaskSupplier.get();
            renderTask.setOverrideRenderSize(width, height).setMaxRenderSize(width, height);
            CompletionStage futureIcon = renderTask.renderDrawable(resourceValue2).thenApply(drawable -> {
                if (drawable != null) {
                    return new ResourceChooserImageIcon(size, (Image)drawable, checkerboardSize, interpolate);
                }
                return null;
            });
            return new AsyncIcon((CompletableFuture<? extends Icon>)futureIcon, placeHolderIcon, onIconLoaded);
        }
        if (type == ResourceType.COLOR) {
            RenderTask renderTask = this.myRenderTaskSupplier.get();
            RenderTaskContext context = renderTask.getContext();
            ResourceResolver resolver = context.getConfiguration().getResourceResolver();
            assert (resolver != null);
            List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resolver, resourceValue2, context.getModule().getProject());
            if (colors.size() == 1) {
                icon2 = new ResourceChooserColorIcon(size, colors.get(0), checkerboardSize);
            } else if (colors.size() > 1) {
                Icon[] colorIcons = new ResourceChooserColorIcon[colors.size()];
                for (int i2 = 0; i2 < colors.size(); ++i2) {
                    int sectionSize = size / colors.size();
                    if (i2 == colors.size() - 1) {
                        sectionSize = size - sectionSize * (colors.size() - 1);
                    }
                    colorIcons[i2] = new ResourceChooserColorIcon(sectionSize, size, colors.get(i2), checkerboardSize);
                }
                icon2 = new RowIcon(colorIcons);
            }
        }
        if (icon2 == null) {
            Logger.getInstance(IconFactory.class).warn("Unable to load AsyncIcon for value" + resourceValue2);
            icon2 = placeHolderIcon;
        }
        if (onIconLoaded != null) {
            onIconLoaded.run();
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            IconFactory.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolderIcon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/icons/IconFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/icons/IconFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAsyncIconFromResourceValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createIconFromPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncIconFromResourceValue";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

