/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchArtboard;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchBitmap;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapeGroup;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapePath;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSlice;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolInstance;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchText;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchLayerDeserializer
implements JsonDeserializer<SketchLayer> {
    public static final String ARTBOARD_CLASS_TYPE = "artboard";
    public static final String BITMAP_CLASS_TYPE = "bitmap";
    public static final String GROUP_CLASS_TYPE = "group";
    public static final String OVAL_CLASS_TYPE = "oval";
    public static final String PAGE_CLASS_TYPE = "page";
    public static final String POLYGON_CLASS_TYPE = "polygon";
    public static final String RECTANGLE_CLASS_TYPE = "rectangle";
    public static final String SHAPE_GROUP_CLASS_TYPE = "shapeGroup";
    public static final String SHAPE_PATH_CLASS_TYPE = "shapePath";
    public static final String SLICE_CLASS_TYPE = "slice";
    public static final String STAR_CLASS_TYPE = "star";
    public static final String SYMBOL_INSTANCE_CLASS_TYPE = "symbolInstance";
    public static final String SYMBOL_MASTER_CLASS_TYPE = "symbolMaster";
    public static final String TEXT_CLASS_TYPE = "text";
    public static final String TRIANGLE_CLASS_TYPE = "triangle";

    @Nullable
    public SketchLayer deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        String classType;
        if (json == null) {
            SketchLayerDeserializer.$$$reportNull$$$0(0);
        }
        if (typeOfT == null) {
            SketchLayerDeserializer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SketchLayerDeserializer.$$$reportNull$$$0(2);
        }
        JsonObject jsonObject = json.getAsJsonObject();
        switch (classType = jsonObject.get("_class").getAsString()) {
            case "artboard": {
                return (SketchLayer)context.deserialize(json, SketchArtboard.class);
            }
            case "bitmap": {
                return (SketchLayer)context.deserialize(json, SketchBitmap.class);
            }
            case "group": 
            case "page": {
                return (SketchLayer)context.deserialize(json, SketchPage.class);
            }
            case "oval": 
            case "polygon": 
            case "rectangle": 
            case "shapePath": 
            case "star": 
            case "triangle": {
                return (SketchLayer)context.deserialize(json, SketchShapePath.class);
            }
            case "shapeGroup": {
                return (SketchLayer)context.deserialize(json, SketchShapeGroup.class);
            }
            case "slice": {
                return (SketchLayer)context.deserialize(json, SketchSlice.class);
            }
            case "symbolInstance": {
                return (SketchLayer)context.deserialize(json, SketchSymbolInstance.class);
            }
            case "symbolMaster": {
                return (SketchLayer)context.deserialize(json, SketchSymbolMaster.class);
            }
            case "text": {
                return (SketchLayer)context.deserialize(json, SketchText.class);
            }
        }
        Logger.getInstance(SketchLayerDeserializer.class).warn("Class " + classType + " not found.");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "json";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "typeOfT";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/parser/deserializers/SketchLayerDeserializer";
        objectArray[2] = "deserialize";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

