/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing;

import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ConnectionDraw;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;

public class WidgetDraw {
    public static final long TOOLTIP_DELAY = 800L;
    public static Image sGuidelinePercent = null;
    public static Image sGuidelineArrowLeft = null;
    public static Image sGuidelineArrowRight = null;
    public static Image sGuidelineArrowUp = null;
    public static Image sGuidelineArrowDown = null;
    private static final RoundRectangle2D.Float sCachedRoundRect = new RoundRectangle2D.Float();
    private static final Stroke sLineShadowStroke = new BasicStroke(5.0f);
    private static final Stroke sBasicStroke = new BasicStroke(1.0f);
    private static final Polygon sTooltipTriangleDown = new Polygon();
    private static final Polygon sTooltipTriangleUp = new Polygon();
    private static final int sArrowBase = 3;
    private static final int sArrowHeight = 3;

    public static void drawTooltip(Graphics2D g, ColorSet colorSet, String[] lines, int x, int y, boolean above) {
        if (lines == null) {
            return;
        }
        Font prefont = g.getFont();
        Color precolor = g.getColor();
        Stroke prestroke = g.getStroke();
        g.setFont(ConnectionDraw.sFont);
        FontMetrics fm = g.getFontMetrics(ConnectionDraw.sFont);
        int offset = 12;
        int margin = 2;
        int padding = 5;
        int textWidth = 0;
        int textHeight = 2 * padding;
        for (String line : lines) {
            textWidth = Math.max(textWidth, fm.stringWidth(line));
            int th = (int)fm.getStringBounds(line, g).getHeight();
            textHeight += th + margin;
        }
        textWidth += 2 * padding;
        int rectX = x - offset;
        int rectY = y - (textHeight -= margin) - 6 - offset;
        if (!above) {
            rectY = y + offset + 6;
        }
        Polygon triangle = sTooltipTriangleDown;
        int triangleY = rectY + textHeight;
        if (!above) {
            triangle = sTooltipTriangleUp;
            triangleY = rectY;
        }
        sCachedRoundRect.setRoundRect(rectX, rectY, textWidth, textHeight, 2.0f, 2.0f);
        g.setColor(colorSet.getBackground());
        g.setStroke(sLineShadowStroke);
        triangle.translate(x, triangleY);
        g.fillPolygon(triangle);
        g.draw(triangle);
        triangle.translate(-x, -triangleY);
        g.fill(sCachedRoundRect);
        g.draw(sCachedRoundRect);
        g.setColor(colorSet.getTooltipBackground());
        g.setStroke(sBasicStroke);
        triangle.translate(x, triangleY);
        g.fillPolygon(triangle);
        g.draw(triangle);
        triangle.translate(-x, -triangleY);
        g.fill(sCachedRoundRect);
        g.draw(sCachedRoundRect);
        int ty = rectY + padding;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int tw = fm.stringWidth(lines[i2]);
            int tx = rectX + textWidth / 2 - tw / 2;
            g.setColor(colorSet.getTooltipText());
            g.drawString(lines[i2], tx, ty + fm.getMaxAscent());
            ty = (int)((double)ty + (fm.getStringBounds(lines[i2], g).getHeight() + (double)margin));
        }
        g.setFont(prefont);
        g.setColor(precolor);
        g.setStroke(prestroke);
    }

    static {
        sTooltipTriangleDown.addPoint(-3, 0);
        sTooltipTriangleDown.addPoint(0, 3);
        sTooltipTriangleDown.addPoint(3, 0);
        sTooltipTriangleUp.addPoint(-3, 0);
        sTooltipTriangleUp.addPoint(0, -3);
        sTooltipTriangleUp.addPoint(3, 0);
    }
}

