/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.TextWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class ButtonWidget
extends TextWidget {
    public ButtonWidget(ConstraintWidget widget, String text) {
        super(widget, text);
        this.mHorizontalPadding = 4;
        this.mVerticalPadding = 8;
        this.mHorizontalMargin = 4;
        this.mVerticalMargin = 6;
        this.mToUpperCase = true;
        this.mAlignmentX = 4;
        this.mAlignmentY = 4;
        this.mWidget.setMinWidth(48);
        this.mWidget.setMinHeight(48);
    }

    @Override
    public void onPaintBackground(ViewTransform transform, Graphics2D g) {
        super.onPaintBackground(transform, g);
        if (this.mColorSet.drawBackground()) {
            int x = transform.getSwingX(this.mWidget.getDrawX() + this.mHorizontalMargin);
            int y = transform.getSwingY(this.mWidget.getDrawY() + this.mVerticalMargin);
            int w = transform.getSwingDimension(this.mWidget.getDrawWidth() - this.mHorizontalMargin * 2);
            int h = transform.getSwingDimension(this.mWidget.getDrawHeight() - this.mVerticalMargin * 2);
            int round = transform.getSwingDimension(5);
            Stroke stroke = g.getStroke();
            int strokeWidth = transform.getSwingDimension(3);
            g.setStroke(new BasicStroke(strokeWidth));
            g.drawRoundRect(x, y, w, h, round, round);
            g.setStroke(stroke);
        }
    }
}

