/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import android.view.View;
import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.utils.Pair;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public final class MotionLayoutComponentHelper {
    private static final boolean USE_MOTIONLAYOUT_HELPER_CACHE = true;
    private InvokeMethod myGetKeyframeAtLocation;
    private InvokeMethod myGetKeyframe;
    private Method myCallSetTransitionPosition;
    private Method myCallSetState;
    private Method myCallGetState;
    private Method myCallGetStartState;
    private Method myCallGetEndState;
    private Method myCallDisableAutoTransition;
    private Method myCallGetProgress;
    private Method myCallSetTransition;
    private Method myGetMaxTimeMethod;
    private Method mySetKeyframePositionMethod;
    private Method motionLayoutAccess;
    private Method mySetAttributesMethod;
    private Method myGetKeyframeMethod;
    private Method myGetKeyFramePositionsMethod;
    private Method mySetKeyframeMethod;
    private Method myGetPositionKeyframeMethod;
    private Method myGetKeyframeAtLocationMethod;
    private Method myCallIsInTransition;
    private Method myUpdateLiveAttributesMethod;
    private Method myGetAnimationPathMethod;
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    private final Object myDesignTool;
    private final NlComponent myMotionLayoutComponent;
    private final boolean DEBUG = false;
    private static boolean mShowPaths = true;
    static WeakHashMap<NlComponent, MotionLayoutComponentHelper> sCache = new WeakHashMap();

    public static void clearCache() {
        sCache.clear();
    }

    public static MotionLayoutComponentHelper create(@NotNull NlComponent component3) {
        MotionLayoutComponentHelper helper2;
        if (component3 == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(0);
        }
        if ((helper2 = sCache.get(component3)) == null || helper2.myDesignTool == null) {
            helper2 = new MotionLayoutComponentHelper(component3);
            sCache.put(component3, helper2);
        }
        return helper2;
    }

    private MotionLayoutComponentHelper(@NotNull NlComponent component3) {
        ViewInfo info;
        if (component3 == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(1);
        }
        this.myGetKeyframeAtLocation = new InvokeMethod("getKeyframeAtLocation", Object.class, Float.TYPE, Float.TYPE);
        this.myGetKeyframe = new InvokeMethod("getKeyframe", Object.class, Integer.TYPE, Integer.TYPE);
        this.DEBUG = false;
        component3 = MotionUtils.getMotionLayoutAncestor(component3);
        ViewInfo viewInfo = info = component3 != null ? NlComponentHelperKt.getViewInfo(component3) : null;
        if (info == null) {
            this.myDesignTool = null;
            this.myMotionLayoutComponent = null;
            return;
        }
        Object instance = info.getViewObject();
        if (instance == null) {
            this.myDesignTool = null;
            this.myMotionLayoutComponent = null;
            return;
        }
        Object designInstance = null;
        try {
            Method accessor = instance.getClass().getMethod("getDesignTool", new Class[0]);
            if (accessor != null) {
                try {
                    designInstance = RenderService.runRenderAction(() -> accessor.invoke(instance, new Object[0]));
                }
                catch (Exception exception) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.myMotionLayoutComponent = component3;
        this.myDesignTool = designInstance;
        this.myGetKeyframeAtLocation.update(this.myDesignTool);
        this.myGetKeyframe.update(this.myDesignTool);
    }

    public int getPath(NlComponent nlComponent, float[] path2, int size) {
        if (this.myDesignTool == null) {
            return -1;
        }
        if (this.myGetAnimationPathMethod == null) {
            try {
                Method[] methods = this.myDesignTool.getClass().getMethods();
                this.myGetAnimationPathMethod = this.myDesignTool.getClass().getMethod("getAnimationPath", Object.class, float[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.myGetAnimationPathMethod != null) {
            try {
                return (Integer)RenderService.runRenderAction(() -> {
                    try {
                        ViewInfo info = NlComponentHelperKt.getViewInfo(nlComponent);
                        if (info == null) {
                            return -1;
                        }
                        return this.myGetAnimationPathMethod.invoke(this.myDesignTool, info.getViewObject(), path2, size);
                    }
                    catch (Exception e) {
                        this.myGetAnimationPathMethod = null;
                        e.printStackTrace();
                        return -1;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public Object getKeyframeAtLocation(Object view, float x, float y) {
        return this.myGetKeyframeAtLocation.invoke(view, Float.valueOf(x), Float.valueOf(y));
    }

    public Object getKeyframe(Object view, int type, int position) {
        return this.myGetKeyframe.invoke(view, type, position);
    }

    public Object __getKeyframeAtLocation(Object view, float x, float y) {
        if (this.myDesignTool == null) {
            return null;
        }
        if (this.myGetKeyframeAtLocationMethod == null) {
            try {
                this.myGetKeyframeAtLocationMethod = this.myDesignTool.getClass().getMethod("getKeyframeAtLocation", Object.class, Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetKeyframeAtLocationMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return this.myGetKeyframeAtLocationMethod.invoke(this.myDesignTool, view, Float.valueOf(x), Float.valueOf(y));
                    }
                    catch (Exception e) {
                        this.myGetKeyframeAtLocationMethod = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean getPositionKeyframe(Object keyframe, Object view, float x, float y, String[] attributes, float[] values) {
        if (this.myDesignTool == null) {
            return false;
        }
        if (this.myGetPositionKeyframeMethod == null) {
            try {
                this.myGetPositionKeyframeMethod = this.myDesignTool.getClass().getMethod("getPositionKeyframe", Object.class, Object.class, Float.TYPE, Float.TYPE, String[].class, float[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetPositionKeyframeMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return this.myGetPositionKeyframeMethod.invoke(this.myDesignTool, keyframe, view, Float.valueOf(x), Float.valueOf(y), attributes, values);
                    }
                    catch (Exception e) {
                        this.myGetPositionKeyframeMethod = null;
                        return false;
                    }
                }) == Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public Object getKeyframe(int type, int target, int position) {
        if (this.myDesignTool == null) {
            return null;
        }
        if (this.myGetKeyframeMethod == null) {
            try {
                this.myGetKeyframeMethod = this.myDesignTool.getClass().getMethod("getKeyframe", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetKeyframeMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return this.myGetKeyframeMethod.invoke(this.myDesignTool, type, target, position);
                    }
                    catch (Exception e) {
                        this.myGetKeyframeMethod = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setKeyframe(Object keyframe, String tag, Object value2) {
        if (this.myDesignTool == null) {
            return;
        }
        if (this.mySetKeyframeMethod == null) {
            try {
                this.mySetKeyframeMethod = this.myDesignTool.getClass().getMethod("setKeyframe", Object.class, String.class, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.mySetKeyframeMethod != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.mySetKeyframeMethod.invoke(this.myDesignTool, keyframe, tag, value2);
                    }
                    catch (Exception e) {
                        this.mySetKeyframeMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAttributes(int dpiValue, String constraintSetId, Object view, Object attributes) {
        if (this.myDesignTool == null) {
            return;
        }
        if (this.mySetAttributesMethod == null) {
            try {
                this.mySetAttributesMethod = this.myDesignTool.getClass().getMethod("setAttributes", Integer.TYPE, String.class, Object.class, Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.mySetAttributesMethod != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.mySetAttributesMethod.invoke(this.myDesignTool, dpiValue, constraintSetId, view, attributes);
                    }
                    catch (Exception e) {
                        this.mySetAttributesMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean setKeyframePosition(Object view, int position, int type, float x, float y) {
        if (this.myDesignTool == null) {
            return false;
        }
        if (this.mySetKeyframePositionMethod == null) {
            try {
                this.mySetKeyframePositionMethod = this.myDesignTool.getClass().getMethod("setKeyFramePosition", Object.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        boolean[] didUpdate = new boolean[]{false};
        if (this.mySetKeyframePositionMethod != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        didUpdate[0] = (Boolean)this.mySetKeyframePositionMethod.invoke(this.myDesignTool, view, position, type, Float.valueOf(x), Float.valueOf(y));
                        NlModel model2 = this.myMotionLayoutComponent.getModel();
                        model2.notifyLiveUpdate(false);
                    }
                    catch (Exception e) {
                        this.mySetKeyframePositionMethod = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return didUpdate[0];
    }

    private boolean setTransitionPosition(float position) {
        if (this.myDesignTool == null) {
            return false;
        }
        if (this.myCallSetTransitionPosition == null) {
            try {
                this.myCallSetTransitionPosition = this.myDesignTool.getClass().getMethod("setToolPosition", Float.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetTransitionPosition = null;
                return false;
            }
        }
        if (this.myCallSetTransitionPosition != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.myCallSetTransitionPosition.invoke(this.myDesignTool, Float.valueOf(position));
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetTransitionPosition = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myCallSetTransitionPosition != null;
    }

    public boolean setProgress(float value2) {
        if (this.myDesignTool == null) {
            return false;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        if (!this.setTransitionPosition(value2)) {
            return false;
        }
        model2.notifyLiveUpdate(false);
        MotionLayoutComponentHelper.refresh(this.myMotionLayoutComponent);
        return true;
    }

    public void setTransition(String start, String end) {
        if (this.myDesignTool == null) {
            return;
        }
        if (this.myCallSetTransition == null) {
            this.disableAutoTransition(true);
            try {
                this.myCallSetTransition = this.myDesignTool.getClass().getMethod("setTransition", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetTransition = null;
                return;
            }
        }
        if (this.myCallSetTransition != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.myCallSetTransition.invoke(this.myDesignTool, start, end);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetTransition = null;
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myCallSetTransition == null) {
            return;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        model2.notifyLiveUpdate(false);
    }

    public void setState(String state) {
        if (this.myDesignTool == null) {
            return;
        }
        if (this.myCallSetState == null) {
            try {
                this.myCallSetState = this.myDesignTool.getClass().getMethod("setState", String.class);
            }
            catch (NoSuchMethodException e) {
                this.myCallSetState = null;
                return;
            }
        }
        if (this.myCallSetState != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.myCallSetState.invoke(this.myDesignTool, state);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetState = null;
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myCallSetState == null) {
            return;
        }
        NlModel model2 = this.myMotionLayoutComponent.getModel();
        model2.notifyLiveUpdate(false);
    }

    public void disableAutoTransition(boolean disable) {
        if (this.myDesignTool == null) {
            return;
        }
        if (this.myCallDisableAutoTransition == null) {
            try {
                this.myCallDisableAutoTransition = this.myDesignTool.getClass().getMethod("disableAutoTransition", Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.myCallDisableAutoTransition = null;
                return;
            }
        }
        if (this.myCallDisableAutoTransition != null) {
            try {
                RenderService.runRenderAction(() -> {
                    try {
                        this.myCallDisableAutoTransition.invoke(this.myDesignTool, disable);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallDisableAutoTransition = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getState() {
        String state = null;
        if (this.myDesignTool == null) {
            return state;
        }
        if (this.myCallGetState == null) {
            try {
                this.myCallGetState = this.myDesignTool.getClass().getMethod("getState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetState = null;
                return state;
            }
        }
        if (this.myCallGetState != null) {
            try {
                state = RenderService.runRenderAction(() -> {
                    try {
                        return (String)this.myCallGetState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallSetState = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    public String getStartState() {
        String state = null;
        if (this.myDesignTool == null) {
            return state;
        }
        if (this.myCallGetStartState == null) {
            try {
                this.myCallGetStartState = this.myDesignTool.getClass().getMethod("getStartState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetStartState = null;
                return state;
            }
        }
        if (this.myCallGetStartState != null) {
            try {
                state = RenderService.runRenderAction(() -> {
                    try {
                        return (String)this.myCallGetStartState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetStartState = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    public String getEndState() {
        String state = null;
        if (this.myDesignTool == null) {
            return state;
        }
        if (this.myCallGetEndState == null) {
            try {
                this.myCallGetEndState = this.myDesignTool.getClass().getMethod("getEndState", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetEndState = null;
                return state;
            }
        }
        if (this.myCallGetEndState != null) {
            try {
                state = RenderService.runRenderAction(() -> {
                    try {
                        return (String)this.myCallGetEndState.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetEndState = null;
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    public float getProgress() {
        float progress = 0.0f;
        if (this.myDesignTool == null) {
            return progress;
        }
        if (this.myCallGetProgress == null) {
            try {
                this.myCallGetProgress = this.myDesignTool.getClass().getMethod("getProgress", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallGetProgress = null;
                return progress;
            }
        }
        if (this.myCallGetProgress != null) {
            try {
                progress = RenderService.runRenderAction(() -> {
                    try {
                        return (Float)this.myCallGetProgress.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallGetProgress = null;
                        return Float.valueOf(0.0f);
                    }
                }).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return progress;
    }

    public boolean isInTransition() {
        boolean isInTransition = false;
        if (this.myDesignTool == null) {
            return isInTransition;
        }
        if (this.myCallIsInTransition == null) {
            try {
                this.myCallIsInTransition = this.myDesignTool.getClass().getMethod("isInTransition", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.myCallIsInTransition = null;
                return isInTransition;
            }
        }
        if (this.myCallIsInTransition != null) {
            try {
                isInTransition = RenderService.runRenderAction(() -> {
                    try {
                        return (Boolean)this.myCallIsInTransition.invoke(this.myDesignTool, new Object[0]);
                    }
                    catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                        this.myCallIsInTransition = null;
                        return false;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isInTransition;
    }

    public long getMaxTimeMs() {
        if (this.myDesignTool == null) {
            return 0L;
        }
        if (this.myGetMaxTimeMethod == null) {
            try {
                this.myGetMaxTimeMethod = this.myDesignTool.getClass().getMethod("getTransitionTimeMs", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.myGetMaxTimeMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return (long)((Long)this.myGetMaxTimeMethod.invoke(this.myDesignTool, new Object[0]));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.myGetMaxTimeMethod = null;
                        return 0;
                    }
                }).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public int motionLayoutAccess(int cmd, String type, Object view, float[] in, int inLength, float[] out, int outLength) {
        if (this.myDesignTool == null) {
            return -1;
        }
        if (this.motionLayoutAccess == null) {
            try {
                this.motionLayoutAccess = this.myDesignTool.getClass().getMethod("designAccess", Integer.TYPE, String.class, Object.class, float[].class, Integer.TYPE, float[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                return -1;
            }
        }
        try {
            return (Integer)this.motionLayoutAccess.invoke(this.myDesignTool, cmd, type, view, in, inLength, out, outLength);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.myGetMaxTimeMethod = null;
            return -1;
        }
    }

    private void updateIds(@NotNull NlComponent component3) {
        if (component3 == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(2);
        }
        ResourceIdManager manager = ResourceIdManager.get(component3.getModel().getModule());
        this.updateId(manager, component3);
        if (NlComponentHelperKt.isOrHasSuperclass(component3, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component3.getChildren()) {
                this.updateId(manager, child);
            }
        }
        if ((component3 = component3.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component3, SdkConstants.CLASS_MOTION_LAYOUT)) {
            for (NlComponent child : component3.getChildren()) {
                this.updateId(manager, child);
            }
        }
    }

    private void updateId(@NotNull ResourceIdManager manager, @NotNull NlComponent component3) {
        ViewInfo view;
        String id;
        ResourceReference reference2;
        Integer resolved;
        if (manager == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(3);
        }
        if (component3 == null) {
            MotionLayoutComponentHelper.$$$reportNull$$$0(4);
        }
        if ((resolved = manager.getCompiledId(reference2 = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, id = component3.getId()))) == null && (resolved = Integer.valueOf(manager.getOrGenerateId(reference2))) != null && (view = NlComponentHelperKt.getViewInfo(component3)) != null && view.getViewObject() != null) {
            View androidView = (View)view.getViewObject();
            androidView.setId(resolved.intValue());
        }
    }

    public void updateLiveAttributes(NlComponent component3, ComponentModification modification, String state) {
        Configuration configuration = modification.getComponent().getModel().getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        ResourceIdManager manager = ResourceIdManager.get(modification.getComponent().getModel().getModule());
        ViewInfo info = NlComponentHelperKt.getViewInfo(modification.getComponent());
        if (info == null || info != null && info.getViewObject() == null) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Pair<String, String> key : modification.getAttributes().keySet()) {
            String value2 = modification.getAttributes().get(key);
            if (value2 != null) {
                if (value2.startsWith("@id/") || value2.startsWith("@+id/")) {
                    Integer resolved = manager.getCompiledId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2 = value2.substring(value2.indexOf(47) + 1)));
                    if (resolved == null) {
                        this.updateIds(modification.getComponent());
                        resolved = manager.getOrGenerateId(new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, value2));
                    }
                    if (resolved != null) {
                        value2 = resolved.toString();
                    }
                } else if (value2.equalsIgnoreCase("parent")) {
                    value2 = "0";
                }
            }
            attributes.put((String)key.getSecond(), value2);
        }
        this.setAttributes(dpiValue, state, info.getViewObject(), attributes);
    }

    public int getKeyframePos(NlComponent component3, int[] type, float[] pos) {
        if (this.myDesignTool == null) {
            return -1;
        }
        ViewInfo info = NlComponentHelperKt.getViewInfo(component3);
        if (info == null || info != null && info.getViewObject() == null) {
            return -1;
        }
        if (this.myGetKeyFramePositionsMethod == null) {
            try {
                this.myGetKeyFramePositionsMethod = this.myDesignTool.getClass().getMethod("getKeyFramePositions", Object.class, int[].class, float[].class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.myGetKeyFramePositionsMethod != null) {
            try {
                return RenderService.runRenderAction(() -> {
                    try {
                        return (Integer)this.myGetKeyFramePositionsMethod.invoke(this.myDesignTool, info.getViewObject(), type, pos);
                    }
                    catch (Exception e) {
                        this.myGetKeyFramePositionsMethod = null;
                        e.printStackTrace();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public void setShowPaths(boolean show) {
        mShowPaths = show;
    }

    public boolean getShowPaths() {
        return mShowPaths;
    }

    public static void refresh(NlComponent component3) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component3);
        if (viewInfo != null) {
            ((View)viewInfo.getViewObject()).forceLayout();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutComponentHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateIds";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class InvokeMethod<T> {
        String myMethodName;
        Method myMethod = null;
        Object myDesignTool = null;
        Class[] myParameters = null;

        public InvokeMethod(String methodName, Class ... parameters2) {
            this.myMethodName = methodName;
            this.myParameters = (Class[])ArrayUtil.copyOf((Object[])parameters2);
        }

        public void update(Object designTool) {
            if (designTool == null) {
                return;
            }
            this.myDesignTool = designTool;
            try {
                this.myMethod = designTool.getClass().getMethod(this.myMethodName, this.myParameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public T invoke(Object ... parameters2) {
            if (this.myMethod != null) {
                try {
                    return (T)RenderService.runRenderAction(() -> {
                        try {
                            Object result2 = this.myMethod.invoke(this.myDesignTool, parameters2);
                            return result2;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

