/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

class MotionLayoutSceneInteraction
extends ConstraintSceneInteraction {
    private static final double SLOPE = 20.0;
    private final NlDesignSurface mySurface;
    private int startX;
    private int startY;
    private NlComponent mySelectedComponent;
    private KeyframeCandidate myKeyframeCandidate;
    private static final int MAX_KEY_POSITIONS = 101;
    private String[] myPositionAttributes;
    private float[] myPositionsValues;
    private final DecimalFormat myFloatFormatter;

    public MotionLayoutSceneInteraction(@NotNull SceneView sceneView, @NotNull NlComponent primary) {
        if (sceneView == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(0);
        }
        if (primary == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(1);
        }
        super(sceneView, primary);
        this.myKeyframeCandidate = new KeyframeCandidate();
        this.myPositionAttributes = new String[2];
        this.myPositionsValues = new float[2];
        this.myFloatFormatter = MotionLayoutSceneInteraction.createFloatFormatter();
        this.mySelectedComponent = primary;
        this.mySurface = (NlDesignSurface)sceneView.getSurface();
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        float fy;
        float fx;
        this.startX = x;
        this.startY = y;
        MotionLayoutComponentHelper helper2 = MotionLayoutComponentHelper.create(this.mySelectedComponent);
        if (MotionLayoutSceneInteraction.hitKeyframe(helper2, this.mySelectedComponent, fx = (float)Coordinates.getAndroidX(this.mySceneView, x), fy = (float)Coordinates.getAndroidY(this.mySceneView, y), this.myKeyframeCandidate)) {
            this.mySurface.setRenderSynchronously(true);
            this.mySurface.setAnimationScrubbing(true);
        }
    }

    public static boolean hitKeyframe(@NotNull MotionLayoutComponentHelper helper2, @NotNull NlComponent component3, float fx, float fy, @NotNull KeyframeCandidate keyframeCandidate) {
        if (helper2 == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(2);
        }
        if (component3 == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(3);
        }
        if (keyframeCandidate == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(4);
        }
        keyframeCandidate.clear();
        int keyFrameCount = helper2.getKeyframePos(component3, keyframeCandidate.keyFrameTypes, keyframeCandidate.keyFramePos);
        if (keyFrameCount <= 0) {
            return false;
        }
        Object view = NlComponentHelperKt.getViewInfo(component3).getViewObject();
        for (int i2 = 0; i2 < keyframeCandidate.keyFrameTypes.length; ++i2) {
            if (keyframeCandidate.keyFrameTypes[i2] / 1000 != 2) continue;
            float kx = keyframeCandidate.keyFramePos[i2 * 2];
            float ky = keyframeCandidate.keyFramePos[i2 * 2 + 1];
            double dx = Math.sqrt((kx - fx) * (kx - fx));
            double dy = Math.sqrt((ky - fy) * (ky - fy));
            if (!(dx < 20.0) || !(dy < 20.0)) continue;
            int framePosition = keyframeCandidate.keyFrameTypes[i2] - 2000;
            keyframeCandidate.keyframe = helper2.getKeyframe(view, 2, framePosition);
            keyframeCandidate.position = framePosition;
        }
        return keyframeCandidate.keyframe != null;
    }

    public static boolean hitKeyFrame(@NotNull SceneView sceneView, int x, int y, MotionLayoutComponentHelper helper2, NlComponent component3) {
        if (sceneView == null) {
            MotionLayoutSceneInteraction.$$$reportNull$$$0(5);
        }
        float fx = Coordinates.getAndroidX(sceneView, x);
        float fy = Coordinates.getAndroidY(sceneView, y);
        return MotionLayoutSceneInteraction.hitKeyframe(helper2, component3, fx, fy, new KeyframeCandidate());
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.myKeyframeCandidate.keyframe == null) {
            return;
        }
        this.myPositionAttributes[0] = "percentX";
        this.myPositionAttributes[1] = "percentY";
        ViewInfo info = NlComponentHelperKt.getViewInfo(this.mySelectedComponent);
        if (info != null) {
            float fx = Coordinates.getAndroidX(this.mySceneView, x);
            float fy = Coordinates.getAndroidY(this.mySceneView, y);
            Object view = info.getViewObject();
            MotionLayoutComponentHelper helper2 = MotionLayoutComponentHelper.create(this.mySelectedComponent);
            if (helper2.getPositionKeyframe(this.myKeyframeCandidate.keyframe, view, fx, fy, this.myPositionAttributes, this.myPositionsValues)) {
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[0], Float.valueOf(this.myPositionsValues[0]));
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[1], Float.valueOf(this.myPositionsValues[1]));
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, "drawPath", 4);
                this.mySelectedComponent.getModel().notifyLiveUpdate(false);
            }
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.mySurface.setRenderSynchronously(false);
        this.mySurface.setAnimationScrubbing(false);
        if (this.myKeyframeCandidate.keyframe == null || this.mySelectedComponent == null) {
            return;
        }
        this.myPositionAttributes[0] = "percentX";
        this.myPositionAttributes[1] = "percentY";
        ViewInfo info = NlComponentHelperKt.getViewInfo(this.mySelectedComponent);
        String selectedId = this.mySelectedComponent.ensureId();
        if (info != null) {
            float fx = Coordinates.getAndroidX(this.mySceneView, x);
            float fy = Coordinates.getAndroidY(this.mySceneView, y);
            Object view = info.getViewObject();
            MotionLayoutComponentHelper helper2 = MotionLayoutComponentHelper.create(this.mySelectedComponent);
            if (helper2.getPositionKeyframe(this.myKeyframeCandidate.keyframe, view, fx, fy, this.myPositionAttributes, this.myPositionsValues)) {
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[0], Float.valueOf(this.myPositionsValues[0]));
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[1], Float.valueOf(this.myPositionsValues[1]));
                helper2.setKeyframe(this.myKeyframeCandidate.keyframe, "drawPath", 0);
                NlComponent motionLayoutComponent = MotionUtils.getMotionLayoutAncestor(this.mySelectedComponent);
                if (motionLayoutComponent != null) {
                    MotionSceneTag motionScene = MotionUtils.getMotionScene(motionLayoutComponent);
                    MTag[] transitions = motionScene.getChildTags("Transition");
                    String startState = helper2.getStartState();
                    String endState = helper2.getEndState();
                    MTag[] keyframes = null;
                    if (startState != null && endState != null) {
                        int i2;
                        for (i2 = 0; i2 < transitions.length; ++i2) {
                            MTag[] keyframesSet;
                            MTag transition = transitions[i2];
                            String transitionStart = transition.getAttributeValue("constraintSetStart");
                            String transitionEnd = transition.getAttributeValue("constraintSetEnd");
                            if (!startState.equals(Utils.stripID(transitionStart)) || !endState.equals(Utils.stripID(transitionEnd)) || (keyframesSet = transition.getChildTags("KeyFrameSet")) == null || keyframesSet.length <= 0) continue;
                            keyframes = keyframesSet[0].getChildTags("KeyPosition");
                            break;
                        }
                        if (keyframes != null) {
                            for (i2 = 0; i2 < keyframes.length; ++i2) {
                                String motionTarget;
                                int framePosition;
                                void keyframe = keyframes[i2];
                                String framePositionValue = keyframe.getAttributeValue("framePosition");
                                int n = framePosition = framePositionValue != null ? Integer.parseInt(framePositionValue) : -1;
                                if (framePosition != this.myKeyframeCandidate.position || (motionTarget = keyframe.getAttributeValue("motionTarget")) == null || !selectedId.equals(Utils.stripID(motionTarget))) continue;
                                MTag.TagWriter keyframeModification = keyframe.getTagWriter();
                                keyframeModification.setAttribute("http://schemas.android.com/apk/res-auto", this.myPositionAttributes[0], this.formatValue(this.myPositionsValues[0]));
                                keyframeModification.setAttribute("http://schemas.android.com/apk/res-auto", this.myPositionAttributes[1], this.formatValue(this.myPositionsValues[1]));
                                keyframeModification.commit("Modified Position Keyframe");
                            }
                        }
                    }
                }
                this.mySelectedComponent.getModel().notifyLiveUpdate(false);
            }
        }
        this.myKeyframeCandidate.clear();
    }

    @NotNull
    private static DecimalFormat createFloatFormatter() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
        return new DecimalFormat("#.###", symbols);
    }

    private String formatValue(float value2) {
        return this.myFloatFormatter.format(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyframeCandidate";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutSceneInteraction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hitKeyframe";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hitKeyFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class KeyframeCandidate {
        Object keyframe;
        int position = -1;
        int[] keyFrameTypes = new int[101];
        float[] keyFramePos = new float[202];

        private KeyframeCandidate() {
        }

        public void clear() {
            this.keyframe = null;
            this.position = -1;
        }
    }
}

