/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreateKey;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CreateKeyTrigger
extends BaseCreateKey {
    static String TITLE = "Create ConstraintSet";
    private static final String KEY_TAG = "KeyTrigger";
    private String[] options = new String[]{"Position", "Collision"};
    JComboBox<String> comboBox = MEUI.makeComboBox(this.options);
    MTag mKeyFrameSet;
    private String mPosPrompt = "0-100";
    private MTag mSelectedTransition;
    private final JTextField mOnCross;
    BaseCreatePanel.PromptedTextField mMainParameter;

    public CreateKeyTrigger() {
        this.icon = MEIcons.CREATE_TRANSITION;
        GridBagConstraints gbc = new GridBagConstraints();
        int y = this.createTop(gbc, "CREATE KEY TRIGGER");
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Type"), gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.anchor = 10;
        gbc.insets = MEUI.dialogControlInsets();
        this.add(this.comboBox, gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        final JLabel title = new JLabel("Position");
        this.add((Component)title, gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mMainParameter = this.newTextField("0-100", 15);
        this.add((Component)this.mMainParameter, gbc);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateKeyTrigger.this.comboBox.getSelectedIndex() == 0) {
                    title.setText("Position");
                    CreateKeyTrigger.this.mPosPrompt = "0-100";
                    CreateKeyTrigger.this.mMainParameter.setPromptText("0-100");
                } else {
                    title.setText("Collide width");
                    CreateKeyTrigger.this.mPosPrompt = "id of view";
                    CreateKeyTrigger.this.mMainParameter.setPromptText("id of view");
                }
            }
        });
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Collide width"), gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add((Component)this.newTextField("triggerId", 15), gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("onCross"), gbc);
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mOnCross = this.newTextField("method", 15);
        this.add((Component)this.mOnCross, gbc);
        gbc.weighty = 1.0;
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateKeyTrigger.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.populateTags(model2.getLayoutViewNames());
        MotionEditorSelector.Type selectionType = model2.getSelectedType();
        if (selectionType == null) {
            return false;
        }
        MTag[] selected = model2.getSelected();
        switch (selectionType) {
            case KEY_FRAME: 
            case KEY_FRAME_GROUP: {
                this.mKeyFrameSet = selected[0].getParent();
                this.mMatchTag.setText(selected[0].getAttributeValue("motionTarget"));
                break;
            }
            case TRANSITION: {
                MTag[] tag = selected[0].getChildTags("KeyFrameSet");
                if (tag != null && tag.length > 0) {
                    this.mKeyFrameSet = tag[0];
                }
                this.mSelectedTransition = selected[0];
            }
        }
        float pos = model2.getCurrentProgress();
        if (!Float.isNaN(pos)) {
            this.mMainParameter.setText(Integer.toString((int)(pos * 100.0f)));
        }
        return true;
    }

    @Override
    public MTag create() {
        String pos;
        MTag.TagWriter keyPosition;
        MTag.TagWriter toCommit;
        if (this.mKeyFrameSet == null) {
            toCommit = this.mSelectedTransition.getChildTagWriter("KeyFrameSet");
            this.mKeyFrameSet = toCommit;
            keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        } else {
            toCommit = keyPosition = this.mKeyFrameSet.getChildTagWriter(KEY_TAG);
        }
        keyPosition.setAttribute("motion", "motionTarget", this.getMotionTarget());
        if (this.comboBox.getSelectedIndex() == 0) {
            pos = this.mMainParameter.getText();
            if (pos.trim().length() == 0 || pos.equals(this.mPosPrompt)) {
                this.showErrorDialog("Must define the position of the view");
                return null;
            }
            try {
                int posInt = Integer.parseInt(pos.trim());
                keyPosition.setAttribute("motion", "framePosition", pos.trim());
            }
            catch (Exception ex) {
                this.showErrorDialog("was not able to parse \"" + pos.trim() + "\"");
                return null;
            }
        } else {
            pos = this.mMainParameter.getText();
            if (pos.trim().length() == 0 || pos.equals(this.mPosPrompt)) {
                this.showErrorDialog("Must define the id of the colliding view");
                return null;
            }
            keyPosition.setAttribute("motion", "motion_triggerOnCollision", pos);
        }
        keyPosition.setAttribute("motion", "onCross", this.mOnCross.getText());
        MTag ret = toCommit.commit("Create KeyTrigger");
        Track.createKeyTrigger(this.mMotionEditor.myTrack);
        this.mMotionEditor.dataChanged();
        super.create();
        return ret;
    }

    @Override
    public String getName() {
        return KEY_TAG;
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame(TITLE);
        f.setDefaultCloseOperation(3);
        f.setContentPane(new CreateKeyTrigger());
        f.pack();
        f.validate();
        f.setVisible(true);
    }
}

