/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRowData;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimelineStructure;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.MonotoneSpline;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.Oscillator;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class GraphRender {
    private static final boolean DEBUG = false;
    private Cycle mCycle = null;
    private Attribute[] mAttribute = null;
    private String[] mStartEndString = new String[2];
    static String[] ourWaveTypes = new String[]{"sin", "square", "triangle", "sawtooth", "reverseSawtooth", "cos", "bounce"};
    static HashMap<String, Integer> ourWaveTypeMap = new HashMap();
    int[] xPoints = new int[1000];
    int[] yPoints = new int[1000];

    public boolean setUp(MeModel model2, TimeLineRowData row) {
        this.mAttribute = null;
        this.mCycle = null;
        switch (row.mType) {
            case "Att": {
                return this.buildAttributeGraph(model2, row);
            }
            case "Cyc": {
                return this.buildCycleGraph(row);
            }
            case "Pos": {
                break;
            }
            case "TCyc": {
                break;
            }
        }
        return false;
    }

    public String getValue(MTag kf, String keyProp) {
        MTag[] tag = kf.getChildTags();
        if (tag != null && tag.length > 0) {
            String value2 = tag[0].getAttributeValue("customFloatValue");
            return value2;
        }
        return kf.getAttributeValue(keyProp);
    }

    private boolean buildCycleGraph(TimeLineRowData row) {
        MTag[] keyFrames = row.mKeyFrames.toArray(new MTag[0]);
        if (row.mKeyProp.contains(",")) {
            return false;
        }
        Arrays.sort(keyFrames, new Comparator<MTag>(){

            @Override
            public int compare(MTag t1, MTag t2) {
                int p1 = Integer.parseInt(t1.getAttributeValue("framePosition"));
                int p2 = Integer.parseInt(t2.getAttributeValue("framePosition"));
                return Integer.compare(p1, p2);
            }
        });
        double[] pos = new double[keyFrames.length];
        double[] period = new double[keyFrames.length];
        double[] amp = new double[keyFrames.length];
        double[] offset = new double[keyFrames.length];
        int curveType = 0;
        for (int i2 = 0; i2 < pos.length; ++i2) {
            MTag kf = keyFrames[i2];
            pos[i2] = (double)Integer.parseInt(kf.getAttributeValue("framePosition")) / 100.0;
            offset[i2] = GraphRender.parse(0.0, kf.getAttributeValue("waveOffset"));
            period[i2] = GraphRender.parse(0.0, kf.getAttributeValue("wavePeriod"));
            amp[i2] = GraphRender.parse(0.0, this.getValue(kf, row.mKeyProp));
            String str = kf.getAttributeValue("waveShape");
            if (str == null) {
                str = "sin";
            }
            if (!ourWaveTypeMap.containsKey(str)) continue;
            curveType = Math.max(curveType, ourWaveTypeMap.get(str));
        }
        this.mCycle = new Cycle();
        this.mCycle.setCycle(pos, period, amp, offset, curveType);
        this.mCycle.fixRange(row.mKeyProp);
        return true;
    }

    static double parse(double def, String str) {
        if (str == null) {
            return def;
        }
        if (str.endsWith("dp")) {
            str = str.substring(0, str.length() - 2);
        }
        return Double.parseDouble(str);
    }

    private boolean buildAttributeGraph(MeModel model2, TimeLineRowData row) {
        String[] attrs = new String[]{row.mKeyProp};
        if (row.mKeyProp.contains(",")) {
            attrs = attrs[0].split(",");
        }
        this.mAttribute = new Attribute[attrs.length];
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            String attr = attrs[i2];
            model2.findStartAndEndValues(model2.layout, attr, row.mKeyFrames.get(0), this.mStartEndString);
            if (this.mStartEndString[0] == null || this.mStartEndString[1] == null) {
                return false;
            }
            double startValue = GraphRender.parse(this.mStartEndString[0]);
            double endValue = GraphRender.parse(this.mStartEndString[0]);
            this.mAttribute[i2] = new Attribute(row, attr, startValue, endValue);
        }
        return true;
    }

    static double parse(String str) {
        if (str.endsWith("dp")) {
            str = str.substring(0, str.length() - 2);
        }
        return Double.parseDouble(str);
    }

    public void draw(Graphics g, TimelineStructure mTimelineStructure, int x, int y, int w, int h) {
        if (this.mAttribute == null && this.mCycle == null) {
            return;
        }
        int gx = x + mTimelineStructure.mTimeLineInsetLeft;
        int gw = w - mTimelineStructure.mTimeLineInsetLeft - mTimelineStructure.mTimeLineInsetRight;
        Color c = g.getColor();
        g.setColor(MEUI.Graph.ourG_Background);
        g.fillRect(x + 1, y, w - 1, h);
        g.setColor(MEUI.ourBorder);
        g.drawRect(x, y, w, h - 1);
        g.setColor(MEUI.Graph.ourG_line);
        if (this.mCycle != null) {
            this.mCycle.plot(g, gx, y, gw, h);
        }
        if (this.mAttribute != null) {
            for (int i2 = 0; i2 < this.mAttribute.length; ++i2) {
                Attribute attribute = this.mAttribute[i2];
                attribute.plot(g, gx, y, gw, h);
            }
        }
        g.setColor(c);
    }

    static double lockAttributeMin(String attr, double current) {
        switch (attr) {
            case "alpha": {
                return 0.0;
            }
            case "scaleX": {
                return 0.0;
            }
            case "scaleY": {
                return 0.0;
            }
            case "elevation": {
                return 0.0;
            }
        }
        return current;
    }

    static double lockAttributeMax(String attr, double current) {
        switch (attr) {
            case "alpha": {
                return 1.0;
            }
        }
        return current;
    }

    static float lockAttributeMax(String attr, float current) {
        switch (attr) {
            case "alpha": {
                return 1.0f;
            }
        }
        return current;
    }

    static float lockAttributeMin(String attr, float current) {
        switch (attr) {
            case "alpha": {
                return 0.0f;
            }
            case "scaleX": {
                return 0.0f;
            }
            case "scaleY": {
                return 0.0f;
            }
            case "elevation": {
                return 0.0f;
            }
        }
        return current;
    }

    static {
        for (int i2 = 0; i2 < ourWaveTypes.length; ++i2) {
            ourWaveTypeMap.put(ourWaveTypes[i2], i2);
        }
    }

    static class Cycle {
        MonotoneSpline mMonotoneSpline;
        Oscillator mOscillator;
        float[] xpos = new float[400];
        double[] ypos = new double[this.xpos.length];
        float[] yMax = new float[this.xpos.length];
        float[] yMin = new float[this.xpos.length];
        float mMaxY;
        float mMinY;
        int[] xPoints = new int[this.xpos.length];
        int[] yPoints = new int[this.xpos.length];

        Cycle() {
        }

        void setCycle(double[] pos, double[] period, double[] amplitude, double[] offset, int curveType) {
            int i2;
            if (pos.length == 1) {
                pos = new double[]{0.0, pos[0], 1.0};
                period = new double[]{period[0], period[0], period[0]};
                amplitude = new double[]{amplitude[0], amplitude[0], amplitude[0]};
                offset = new double[]{offset[0], offset[0], offset[0]};
            }
            double[] t = new double[pos.length];
            double[][] v = new double[pos.length][2];
            for (int i3 = 0; i3 < pos.length; ++i3) {
                t[i3] = pos[i3];
                v[i3][0] = amplitude[i3];
                v[i3][1] = offset[i3];
            }
            MonotoneSpline ms = new MonotoneSpline(t, v);
            Oscillator osc = new Oscillator();
            osc.setType(curveType);
            for (i2 = 0; i2 < pos.length; ++i2) {
                osc.addPoint(pos[i2], (float)period[i2]);
            }
            osc.normalize();
            this.mMonotoneSpline = ms;
            this.mOscillator = osc;
            this.mMaxY = -3.4028235E38f;
            this.mMinY = Float.MAX_VALUE;
            for (i2 = 0; i2 < this.xpos.length; ++i2) {
                this.xpos[i2] = (float)i2 / ((float)this.xpos.length - 1.0f);
                double amp = this.mMonotoneSpline.getPos((double)this.xpos[i2], 0);
                double off = this.mMonotoneSpline.getPos((double)this.xpos[i2], 1);
                try {
                    this.ypos[i2] = this.mOscillator.getValue(this.xpos[i2]) * amp + off;
                }
                catch (Exception e) {
                    this.ypos[i2] = Math.random();
                }
                this.yMax[i2] = (float)(amp + off);
                this.yMin[i2] = (float)(-amp + off);
                this.mMaxY = Math.max(this.mMaxY, (float)this.ypos[i2]);
                this.mMaxY = Math.max(this.mMaxY, this.yMax[i2]);
                this.mMinY = Math.min(this.mMinY, this.yMin[i2]);
            }
        }

        void fixRange(String attr) {
            this.mMinY = GraphRender.lockAttributeMin(attr, this.mMinY);
            this.mMaxY = GraphRender.lockAttributeMax(attr, this.mMaxY);
            this.mMaxY = (float)((double)this.mMaxY + 0.06 * (double)(this.mMaxY - this.mMinY));
            this.mMinY = (float)((double)this.mMinY - 0.06 * (double)(this.mMaxY - this.mMinY));
        }

        void plot(Graphics g, int x, int y, int w, int h) {
            g.setColor(MEUI.Graph.ourG_line);
            for (int i2 = 0; i2 < this.xpos.length; ++i2) {
                int xp = (int)((float)w * this.xpos[i2] + (float)x);
                int yp = y + (int)((double)h - (double)h * (this.ypos[i2] - (double)this.mMinY) / (double)(this.mMaxY - this.mMinY));
                this.xPoints[i2] = xp;
                this.yPoints[i2] = yp;
            }
            g.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length);
        }

        float getComputedValue(float v) {
            if (this.mMonotoneSpline == null) {
                return 0.0f;
            }
            double amp = this.mMonotoneSpline.getPos((double)v, 0);
            double off = this.mMonotoneSpline.getPos((double)v, 1);
            return (float)(this.mOscillator.getValue(v) * amp + off);
        }
    }

    static class Attribute {
        String mType;
        MonotoneSpline spline;
        int[] xPoints = new int[1000];
        int[] yPoints = new int[1000];
        double mMin;
        double mMax;

        public Attribute(TimeLineRowData row, String attr, double startValue, double endValue) {
            this.mType = attr;
            this.setup(row, attr, startValue, endValue);
        }

        public boolean setup(TimeLineRowData row, String attr, double startValue, double endValue) {
            MTag[] keyFrames = row.mKeyFrames.toArray(new MTag[0]);
            Arrays.sort(keyFrames, new Comparator<MTag>(){

                @Override
                public int compare(MTag t1, MTag t2) {
                    int p1 = Integer.parseInt(t1.getAttributeValue("framePosition"));
                    int p2 = Integer.parseInt(t2.getAttributeValue("framePosition"));
                    return Integer.compare(p1, p2);
                }
            });
            if (attr.contains(",")) {
                return false;
            }
            double[] pos = new double[keyFrames.length + 2];
            int[] int_pos = new int[pos.length];
            double[][] values = new double[pos.length][1];
            double min2 = Math.min(startValue, endValue);
            double max = Math.max(startValue, endValue);
            pos[0] = 0.0;
            pos[pos.length - 1] = 1.0;
            values[0][0] = startValue;
            values[pos.length - 1][0] = endValue;
            for (int i2 = 0; i2 < keyFrames.length; ++i2) {
                MTag kf = row.mKeyFrames.get(i2);
                int x = Integer.parseInt(kf.getAttributeValue("framePosition"));
                double y = GraphRender.parse(kf.getAttributeValue(attr));
                int_pos[i2 + 1] = x;
                pos[i2 + 1] = (double)x / 100.0;
                values[i2 + 1][0] = y;
                if (y > max) {
                    max = y;
                }
                if (!(y < min2)) continue;
                min2 = y;
            }
            this.mMin = min2;
            this.mMax = max;
            this.mMin = GraphRender.lockAttributeMin(attr, this.mMin);
            this.mMax = GraphRender.lockAttributeMax(attr, this.mMax);
            this.mMin -= 0.06 * (this.mMax - this.mMin);
            this.mMax += 0.06 * (this.mMax - this.mMin);
            this.spline = new MonotoneSpline(pos, values);
            return true;
        }

        public void plot(Graphics g, int x, int y, int w, int h) {
            if (this.spline != null) {
                double steps = 1.0 / (double)w;
                int count = 0;
                for (double i2 = 0.0; i2 <= 1.0; i2 += steps) {
                    double yp = this.spline.getPos(i2, 0);
                    this.xPoints[count] = (int)((double)x + i2 * (double)w);
                    this.yPoints[count] = (int)((double)(y + h) - (yp - this.mMin) * (double)h / (this.mMax - this.mMin));
                    ++count;
                }
                g.drawPolyline(this.xPoints, this.yPoints, count);
            }
        }
    }
}

