/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyAttribute;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyCycle;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyPosition;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyTimeCycle;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateKeyTrigger;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLinePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditor;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TransitionPanel
extends JPanel {
    TimeLinePanel mTimeLinePanel = new TimeLinePanel();
    MTag mTransitionTag;
    private MeModel mMeModel;
    MotionEditorSelector mMotionEditorSelector;
    CreateKeyPosition mCreateKeyPosition = new CreateKeyPosition();
    CreateKeyAttribute mCreateKeyAttribute = new CreateKeyAttribute();
    CreateKeyTrigger mCreateKeyTrigger = new CreateKeyTrigger();
    CreateKeyCycle mCreateKeyCycle = new CreateKeyCycle();
    CreateKeyTimeCycle mCreateKeyTimeCycle = new CreateKeyTimeCycle();
    JPopupMenu myPopupMenu = new JPopupMenu();

    public TransitionPanel(MotionEditor motionEditor) {
        super(new BorderLayout());
        JPanel left2 = new JPanel(new FlowLayout(0));
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)left2, "West");
        top.add((Component)right2, "East");
        left2.add(new JLabel("Transition ", MEIcons.LIST_TRANSITION, 2));
        JButton create2 = MEUI.createToolBarButton(MEIcons.CREATE_KEYFRAME, "Create KeyFrames");
        create2.setContentAreaFilled(false);
        right2.add(create2);
        this.myPopupMenu.add(this.mCreateKeyPosition.getAction(create2, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyAttribute.getAction(create2, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyTrigger.getAction(create2, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyCycle.getAction(create2, motionEditor));
        this.myPopupMenu.add(this.mCreateKeyTimeCycle.getAction(create2, motionEditor));
        create2.addActionListener(e -> this.myPopupMenu.show(create2, 0, 0));
        this.add((Component)top, "North");
        this.add((Component)this.mTimeLinePanel, "Center");
        this.mTimeLinePanel.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                if (TransitionPanel.this.mMeModel != null) {
                    TransitionPanel.this.mMeModel.setProgress(pos);
                }
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myPopupMenu != null) {
            this.myPopupMenu.updateUI();
            int n = this.myPopupMenu.getComponentCount();
            for (int i2 = 0; i2 < n; ++i2) {
                Component component3 = this.myPopupMenu.getComponent(i2);
                if (!(component3 instanceof JComponent)) continue;
                ((JComponent)component3).updateUI();
            }
        }
    }

    public void setMTag(MTag transitionTag, MeModel model2) {
        this.mTransitionTag = transitionTag;
        this.mMeModel = model2;
        this.mTimeLinePanel.setMTag(transitionTag, model2);
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mMotionEditorSelector = listeners;
        this.mTimeLinePanel.setListeners(listeners);
    }

    public void addTimeLineListener(MotionEditorSelector.TimeLineListener timeLineListener) {
        this.mTimeLinePanel.addTimeLineListener(timeLineListener);
    }

    public void clearSelection() {
        this.mTimeLinePanel.clearSelection();
    }

    public void setActionListener(MTagActionListener listener2) {
        this.mTimeLinePanel.setActionListener(listener2);
    }

    public void stopAnimation() {
        this.mTimeLinePanel.stopAnimation();
    }
}

