/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.property2.ConstraintSetPanel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.SelectedTagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.TransitionPanel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.property.panel.api.InspectorBuilder;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertiesTable;
import icons.StudioIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectedTargetBuilder
implements InspectorBuilder<NelePropertyItem> {
    private static final String UNNAMED_TARGET = "<unnamed>";

    SelectedTargetBuilder() {
    }

    @Override
    public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<NelePropertyItem> properties) {
        NelePropertyItem any;
        if (inspector == null) {
            SelectedTargetBuilder.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            SelectedTargetBuilder.$$$reportNull$$$0(1);
        }
        if ((any = properties.getFirst()) == null) {
            return;
        }
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(any);
        if (selection == null) {
            return;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        NelePropertyItem idProperty = properties.getOrNull("http://schemas.android.com/apk/res/android", "id");
        String label = motionTag != null ? motionTag.getTagName() : "";
        String id = idProperty != null ? idProperty.getValue() : null;
        Icon icon2 = null;
        boolean includeTopBorder = false;
        switch (selection.getType()) {
            case CONSTRAINT_SET: {
                inspector.addComponent((JComponent)((Object)new ConstraintSetPanel(id)), null);
                return;
            }
            case CONSTRAINT: {
                inspector.addComponent((JComponent)((Object)new ConstraintSetPanel(selection.getConstraintSetId())), null);
                includeTopBorder = true;
                label = "Constraint";
                icon2 = selection.getComponentIcon();
                if (id != null) break;
                id = selection.getComponentId();
                break;
            }
            case TRANSITION: {
                if (SelectedTargetBuilder.addTransitionPanel(inspector, motionTag)) {
                    return;
                }
                id = "";
                icon2 = StudioIcons.LayoutEditor.Motion.TRANSITION;
                break;
            }
            case KEY_FRAME: 
            case KEY_FRAME_GROUP: {
                if (motionTag != null) {
                    includeTopBorder = SelectedTargetBuilder.addTransitionPanel(inspector, motionTag.getParent());
                }
                icon2 = StudioIcons.LayoutEditor.Motion.KEYFRAME;
                id = "";
                break;
            }
            case LAYOUT: 
            case LAYOUT_VIEW: {
                icon2 = selection.getComponentIcon();
            }
        }
        if (id == null) {
            id = UNNAMED_TARGET;
        }
        if (icon2 == null) {
            icon2 = StudioIcons.LayoutEditor.Palette.VIEW;
        }
        inspector.addComponent((JComponent)((Object)new SelectedTagPanel(label, Utils.stripID(id), icon2, includeTopBorder)), null);
    }

    private static boolean addTransitionPanel(@NotNull InspectorPanel inspector, @Nullable MTag motionTag) {
        if (inspector == null) {
            SelectedTargetBuilder.$$$reportNull$$$0(2);
        }
        if (motionTag == null) {
            return false;
        }
        if ("KeyFrameSet".equals(motionTag.getTagName())) {
            motionTag = motionTag.getParent();
        }
        if (motionTag == null || !"Transition".equals(motionTag.getTagName())) {
            return false;
        }
        String start = Utils.stripID(motionTag.getAttributeValue("constraintSetStart"));
        String end = Utils.stripID(motionTag.getAttributeValue("constraintSetEnd"));
        inspector.addComponent((JComponent)((Object)new TransitionPanel(start, end)), null);
        return true;
    }

    @Override
    public void resetCache() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/SelectedTargetBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToInspector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addTransitionPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

