/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

public class Quaternion {
    private final double[] x = new double[4];

    public void set(double w, double x, double y, double z) {
        this.x[0] = w;
        this.x[1] = x;
        this.x[2] = y;
        this.x[3] = z;
    }

    private static double[] cross(double[] a, double[] b) {
        double out0 = a[1] * b[2] - b[1] * a[2];
        double out1 = a[2] * b[0] - b[2] * a[0];
        double out2 = a[0] * b[1] - b[0] * a[1];
        return new double[]{out0, out1, out2};
    }

    private static double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private static double[] normal(double[] a) {
        double norm = Math.sqrt(Quaternion.dot(a, a));
        return new double[]{a[0] / norm, a[1] / norm, a[2] / norm};
    }

    public void set(double[] v1, double[] v2) {
        double[] vec1 = Quaternion.normal(v1);
        double[] vec2 = Quaternion.normal(v2);
        double[] axis = Quaternion.normal(Quaternion.cross(vec1, vec2));
        double angle = Math.acos(Quaternion.dot(vec1, vec2));
        this.set(angle, axis);
    }

    public static double calcAngle(double[] v1, double[] v2) {
        double[] vec1 = Quaternion.normal(v1);
        double[] vec2 = Quaternion.normal(v2);
        return Math.acos(Quaternion.dot(vec1, vec2));
    }

    public static double[] calcAxis(double[] v1, double[] v2) {
        double[] vec1 = Quaternion.normal(v1);
        double[] vec2 = Quaternion.normal(v2);
        return Quaternion.normal(Quaternion.cross(vec1, vec2));
    }

    public void set(double angle, double[] axis) {
        this.x[0] = Math.cos(angle / 2.0);
        double sin = Math.sin(angle / 2.0);
        this.x[1] = axis[0] * sin;
        this.x[2] = axis[1] * sin;
        this.x[3] = axis[2] * sin;
    }

    public Quaternion(double x0, double x1, double x2, double x3) {
        this.x[0] = x0;
        this.x[1] = x1;
        this.x[2] = x2;
        this.x[3] = x3;
    }

    public Quaternion conjugate() {
        return new Quaternion(this.x[0], -this.x[1], -this.x[2], -this.x[3]);
    }

    public Quaternion plus(Quaternion b) {
        Quaternion a = this;
        return new Quaternion(a.x[0] + b.x[0], a.x[1] + b.x[1], a.x[2] + b.x[2], a.x[3] + b.x[3]);
    }

    public Quaternion times(Quaternion b) {
        Quaternion a = this;
        double y0 = a.x[0] * b.x[0] - a.x[1] * b.x[1] - a.x[2] * b.x[2] - a.x[3] * b.x[3];
        double y1 = a.x[0] * b.x[1] + a.x[1] * b.x[0] + a.x[2] * b.x[3] - a.x[3] * b.x[2];
        double y2 = a.x[0] * b.x[2] - a.x[1] * b.x[3] + a.x[2] * b.x[0] + a.x[3] * b.x[1];
        double y3 = a.x[0] * b.x[3] + a.x[1] * b.x[2] - a.x[2] * b.x[1] + a.x[3] * b.x[0];
        return new Quaternion(y0, y1, y2, y3);
    }

    public Quaternion inverse() {
        double d = this.x[0] * this.x[0] + this.x[1] * this.x[1] + this.x[2] * this.x[2] + this.x[3] * this.x[3];
        return new Quaternion(this.x[0] / d, -this.x[1] / d, -this.x[2] / d, -this.x[3] / d);
    }

    public Quaternion divides(Quaternion b) {
        Quaternion a = this;
        return a.inverse().times(b);
    }

    public double[] rotateVec(double[] v) {
        double v0 = v[0];
        double v1 = v[1];
        double v2 = v[2];
        double s = this.x[1] * v0 + this.x[2] * v1 + this.x[3] * v2;
        double n0 = 2.0 * (this.x[0] * (v0 * this.x[0] - (this.x[2] * v2 - this.x[3] * v1)) + s * this.x[1]) - v0;
        double n1 = 2.0 * (this.x[0] * (v1 * this.x[0] - (this.x[3] * v0 - this.x[1] * v2)) + s * this.x[2]) - v1;
        double n2 = 2.0 * (this.x[0] * (v2 * this.x[0] - (this.x[1] * v1 - this.x[2] * v0)) + s * this.x[3]) - v2;
        return new double[]{n0, n1, n2};
    }

    void matrix() {
        double xx = this.x[1] * this.x[1];
        double xy = this.x[1] * this.x[2];
        double xz = this.x[1] * this.x[3];
        double xw = this.x[1] * this.x[0];
        double yy = this.x[2] * this.x[2];
        double yz = this.x[2] * this.x[3];
        double yw = this.x[2] * this.x[0];
        double zz = this.x[3] * this.x[3];
        double zw = this.x[3] * this.x[0];
        double[] m = new double[16];
        m[0] = 1.0 - 2.0 * (yy + zz);
        m[1] = 2.0 * (xy - zw);
        m[2] = 2.0 * (xz + yw);
        m[4] = 2.0 * (xy + zw);
        m[5] = 1.0 - 2.0 * (xx + zz);
        m[6] = 2.0 * (yz - xw);
        m[8] = 2.0 * (xz - yw);
        m[9] = 2.0 * (yz + xw);
        m[10] = 1.0 - 2.0 * (xx + yy);
        m[14] = 0.0;
        m[13] = 0.0;
        m[12] = 0.0;
        m[11] = 0.0;
        m[7] = 0.0;
        m[3] = 0.0;
        m[15] = 1.0;
    }
}

