/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.DeviceSelectionPopup;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class MockUpFileChooser {
    public static final MockUpFileChooser INSTANCE = new MockUpFileChooser();
    private String myLastOpenedFileName = null;

    private MockUpFileChooser() {
    }

    public void chooseMockUpFile(@NotNull NlComponent component3, @NotNull Consumer<String> callback2) {
        String fileName;
        VirtualFile file;
        if (component3 == null) {
            MockUpFileChooser.$$$reportNull$$$0(0);
        }
        if (callback2 == null) {
            MockUpFileChooser.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile2 = file = (fileName = component3.getAttribute("http://schemas.android.com/tools", "mockup")) != null ? MockUpFileChooser.getVirtualFile(fileName) : null;
        if (file == null && this.myLastOpenedFileName != null) {
            file = MockUpFileChooser.getVirtualFile(this.myLastOpenedFileName);
        }
        FileChooser.chooseFile((FileChooserDescriptor)MockupFileHelper.getFileChooserDescriptor(), null, null, (VirtualFile)file, virtualFile -> this.handleFileSelection(component3, (VirtualFile)virtualFile, callback2));
    }

    private void handleFileSelection(@NotNull NlComponent component3, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        if (component3 == null) {
            MockUpFileChooser.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            MockUpFileChooser.$$$reportNull$$$0(3);
        }
        if (callback2 == null) {
            MockUpFileChooser.$$$reportNull$$$0(4);
        }
        if (!virtualFile.exists() || virtualFile.isDirectory()) {
            return;
        }
        this.myLastOpenedFileName = virtualFile.getPath();
        if (component3.isRoot()) {
            MockUpFileChooser.openDeviceChoiceDialog(component3, virtualFile, callback2);
        } else {
            MockUpFileChooser.accept(component3, virtualFile, callback2);
        }
    }

    private static void accept(@NotNull NlComponent component3, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        Path path2;
        if (component3 == null) {
            MockUpFileChooser.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            MockUpFileChooser.$$$reportNull$$$0(6);
        }
        if (callback2 == null) {
            MockUpFileChooser.$$$reportNull$$$0(7);
        }
        if ((path2 = MockupFileHelper.getXMLFilePath(component3.getModel().getProject(), virtualFile.getPath())) != null) {
            callback2.accept(path2.toString());
        }
    }

    private static void openDeviceChoiceDialog(@NotNull NlComponent component3, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback2) {
        if (component3 == null) {
            MockUpFileChooser.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            MockUpFileChooser.$$$reportNull$$$0(9);
        }
        if (callback2 == null) {
            MockUpFileChooser.$$$reportNull$$$0(10);
        }
        try {
            Image probe = PixelProbe.probe((InputStream)virtualFile.getInputStream());
            BufferedImage image = probe.getMergedImage();
            if (image == null) {
                return;
            }
            NlModel model2 = component3.getModel();
            Configuration configuration = model2.getConfiguration();
            Device device = configuration.getDevice();
            if (device == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                DeviceSelectionPopup deviceSelectionPopup = new DeviceSelectionPopup(model2.getProject(), configuration, image);
                if (deviceSelectionPopup.showAndGet()) {
                    MockUpFileChooser.accept(component3, virtualFile, callback2);
                }
            });
        }
        catch (IOException e1) {
            Logger.getInstance(MockUpFileChooser.class).warn("Unable to open this file\n" + e1.getMessage());
        }
    }

    private static VirtualFile getVirtualFile(@NotNull String fileName) {
        if (fileName == null) {
            MockUpFileChooser.$$$reportNull$$$0(11);
        }
        return VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)fileName)), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/MockUpFileChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseMockUpFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFileSelection";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "openDeviceChoiceDialog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

