/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.intellij.openapi.Disposable;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            IncludeTagCreator.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            IncludeTagCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            IncludeTagCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            IncludeTagCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model2, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(4);
        }
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component3 = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component3, SdkConstants.CLASS_RECYCLER_VIEW_V7)) {
            this.addListItemAttribute(component3);
            return component3;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component3) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandActionUtil.run(component3, "Add listitem attribute", () -> component3.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(5);
        }
        if (resourceName == null) {
            IncludeTagCreator.$$$reportNull$$$0(6);
        }
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        AndroidFacet facet2 = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet2, ResourceFolderType.LAYOUT, null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        DesignSurface surface2 = this.getScreenView().getSurface();
        final LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
        if (manager != null) {
            final NlModel model2 = NlModel.create((Disposable)newFile.getProject(), null, facet2, newFile.getVirtualFile(), surface2.getComponentRegistrar());
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    manager.removeRenderListener(this);
                    if (model2.getComponents().isEmpty()) {
                        return;
                    }
                    NlComponent component3 = (NlComponent)model2.getComponents().get(0);
                    AttributesTransaction transaction = component3.startAttributeTransaction();
                    IncludeTagCreator.this.addShowInAttribute(transaction);
                    IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                    IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                    NlWriteCommandActionUtil.run(component3, "", transaction::commit);
                }
            });
        }
        return IncludeTagCreator.getResourceName(newFile);
    }

    @NotNull
    private static String getResourceName(@NotNull XmlFile newFile) {
        if (newFile == null) {
            IncludeTagCreator.$$$reportNull$$$0(7);
        }
        String string = AndroidBuildCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        if (string == null) {
            IncludeTagCreator.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(9);
        }
        String showInName = IncludeTagCreator.getResourceName(this.getModel().getFile());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addIncludeAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResourceName";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addShowInAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

