/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.model.NlComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResizePolicy {
    private static final int NONE = 0;
    private static final int LEFT_EDGE = 1;
    private static final int RIGHT_EDGE = 2;
    private static final int TOP_EDGE = 4;
    private static final int BOTTOM_EDGE = 8;
    private static final int PRESERVE_RATIO = 16;
    private static final int HORIZONTAL = 3;
    private static final int VERTICAL = 12;
    private static final int ANY = 15;
    private static final ResizePolicy ourAny = new ResizePolicy(15);
    private static final ResizePolicy ourNone = new ResizePolicy(0);
    private static final ResizePolicy ourHorizontal = new ResizePolicy(3);
    private static final ResizePolicy ourVertical = new ResizePolicy(12);
    private static final ResizePolicy ourScaled = new ResizePolicy(31);
    private final int myFlags;

    private ResizePolicy(int flags) {
        this.myFlags = flags;
    }

    public boolean isResizable() {
        return (this.myFlags & 0xF) != 0;
    }

    public boolean topAllowed() {
        return (this.myFlags & 4) != 0;
    }

    public boolean rightAllowed() {
        return (this.myFlags & 2) != 0;
    }

    public boolean bottomAllowed() {
        return (this.myFlags & 8) != 0;
    }

    public boolean leftAllowed() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isAspectPreserving() {
        return (this.myFlags & 0x10) != 0;
    }

    @NotNull
    public static ResizePolicy full() {
        ResizePolicy resizePolicy = ourAny;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(0);
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy none() {
        ResizePolicy resizePolicy = ourNone;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(1);
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy horizontal() {
        ResizePolicy resizePolicy = ourHorizontal;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(2);
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy vertical() {
        ResizePolicy resizePolicy = ourVertical;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(3);
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy scaled() {
        ResizePolicy resizePolicy = ourScaled;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(4);
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy create(boolean top, boolean right2, boolean bottom2, boolean left2, boolean preserve) {
        int mask = 0;
        if (top) {
            mask |= 4;
        }
        if (right2) {
            mask |= 2;
        }
        if (bottom2) {
            mask |= 8;
        }
        if (left2) {
            mask |= 1;
        }
        if (preserve) {
            mask |= 0x10;
        }
        return new ResizePolicy(mask);
    }

    @Nullable
    public static ResizePolicy get(@Nullable String resize) {
        if (resize != null && !resize.isEmpty()) {
            if ("full".equals(resize)) {
                return ResizePolicy.full();
            }
            if ("none".equals(resize)) {
                return ResizePolicy.none();
            }
            if ("horizontal".equals(resize)) {
                return ResizePolicy.horizontal();
            }
            if ("vertical".equals(resize)) {
                return ResizePolicy.vertical();
            }
            if ("scaled".equals(resize)) {
                return ResizePolicy.scaled();
            }
            assert (false) : resize;
        }
        return null;
    }

    @NotNull
    public static ResizePolicy getResizePolicy(@NotNull NlComponent component3) {
        if (component3 == null) {
            ResizePolicy.$$$reportNull$$$0(5);
        }
        ResizePolicy resizePolicy = ourAny;
        if (resizePolicy == null) {
            ResizePolicy.$$$reportNull$$$0(6);
        }
        return resizePolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/model/ResizePolicy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "full";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "none";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "horizontal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "vertical";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scaled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/model/ResizePolicy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResizePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResizePolicy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

