/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.SdkConstants;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.uibuilder.palette.CategoryListModel;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ItemListModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PatternFilter;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@UiThread
public class DataModel
implements Disposable {
    public static final Palette.Group COMMON = new Palette.Group("Common");
    @VisibleForTesting
    public static final Palette.Group RESULTS = new Palette.Group("All Results");
    @VisibleForTesting
    public static final String FAVORITE_ITEMS = "Palette.Favorite.items";
    private final CategoryListModel myListModel;
    private final ItemListModel myItemModel;
    private final Condition<Palette.Item> myFilterCondition;
    private final PatternFilter myFilterPattern;
    private final DependencyManager myDependencyManager;
    private final List<String> myFavoriteItems;
    private final NlPaletteModel.UpdateListener myUpdateListener;
    private NlPaletteModel myPaletteModel;
    private LayoutEditorFileType myLayoutType;
    private final ReentrantReadWriteLock myPaletteLock;
    @GuardedBy(value="myPaletteLock")
    private Palette myPalette;
    private Palette.Group myCurrentSelectedGroup;
    private boolean myDisposed;

    public DataModel(@NotNull Disposable parent, @NotNull DependencyManager dependencyManager) {
        if (parent == null) {
            DataModel.$$$reportNull$$$0(0);
        }
        if (dependencyManager == null) {
            DataModel.$$$reportNull$$$0(1);
        }
        this.myPaletteLock = new ReentrantReadWriteLock();
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myListModel = new CategoryListModel();
        this.myItemModel = new ItemListModel();
        this.myFavoriteItems = DataModel.readFavoriteItems();
        this.myDependencyManager = dependencyManager;
        this.myPalette = Palette.EMPTY;
        this.myCurrentSelectedGroup = COMMON;
        this.myUpdateListener = this::update;
        this.myDependencyManager.addDependencyChangeListener(() -> this.onDependenciesChanged());
        this.myFilterPattern = new PatternFilter();
        Condition androidxFilter = item -> {
            boolean isOldSupportLibTag;
            String tagName = item.getTagName();
            boolean isAndroidxTag = tagName.startsWith("androidx") || tagName.startsWith("com.google.android.material");
            boolean bl = isOldSupportLibTag = !isAndroidxTag && tagName.startsWith("android.support.");
            if (!isAndroidxTag && !isOldSupportLibTag) {
                return true;
            }
            return this.myDependencyManager.useAndroidXDependencies() ? isAndroidxTag : isOldSupportLibTag;
        };
        this.myFilterCondition = Conditions.and((Condition)androidxFilter, (Condition)this.myFilterPattern);
    }

    @NotNull
    public CategoryListModel getCategoryListModel() {
        CategoryListModel categoryListModel = this.myListModel;
        if (categoryListModel == null) {
            DataModel.$$$reportNull$$$0(2);
        }
        return categoryListModel;
    }

    @NotNull
    public ItemListModel getItemListModel() {
        ItemListModel itemListModel = this.myItemModel;
        if (itemListModel == null) {
            DataModel.$$$reportNull$$$0(3);
        }
        return itemListModel;
    }

    @NotNull
    public CompletableFuture<Void> setLayoutTypeAsync(@NotNull AndroidFacet facet2, @NotNull LayoutEditorFileType layoutType) {
        if (facet2 == null) {
            DataModel.$$$reportNull$$$0(4);
        }
        if (layoutType == null) {
            DataModel.$$$reportNull$$$0(5);
        }
        NlPaletteModel paletteModel = NlPaletteModel.get(facet2);
        if (layoutType.equals(this.myLayoutType) && paletteModel == this.myPaletteModel) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DataModel.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        if (this.myPaletteModel != null) {
            this.myPaletteModel.removeUpdateListener(this.myUpdateListener);
        }
        this.myLayoutType = layoutType;
        this.myPaletteModel = paletteModel;
        this.myPaletteModel.addUpdateListener(this.myUpdateListener);
        CompletionStage completionStage = CompletableFuture.runAsync(() -> {
            Palette palette = paletteModel.getPalette(layoutType);
            this.myPaletteLock.writeLock().lock();
            try {
                this.myPalette = palette;
                this.myDependencyManager.setPalette(this.myPalette, facet2.getModule());
            }
            finally {
                this.myPaletteLock.writeLock().unlock();
            }
        }, AppExecutorUtil.getAppExecutorService()).thenRunAsync(this::update, (Executor)EdtExecutorService.getInstance());
        if (completionStage == null) {
            DataModel.$$$reportNull$$$0(7);
        }
        return completionStage;
    }

    public void dispose() {
        if (this.myPaletteModel != null) {
            this.myPaletteModel.removeUpdateListener(this.myUpdateListener);
        }
        this.myDisposed = true;
    }

    public void setFilterPattern(@NotNull String pattern) {
        if (pattern == null) {
            DataModel.$$$reportNull$$$0(8);
        }
        if (this.myFilterPattern.setPattern(pattern)) {
            this.update();
        }
    }

    public boolean hasFilterPattern() {
        return this.myFilterPattern.hasPattern();
    }

    public int getMatchCount() {
        return this.myListModel.getMatchCountAt(0);
    }

    public void categorySelectionChanged(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(9);
        }
        this.createFilteredItems(selectedGroup);
        this.myCurrentSelectedGroup = selectedGroup;
    }

    public boolean isFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(10);
        }
        return this.myFavoriteItems.contains(item.getId());
    }

    public void addFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(11);
        }
        if (this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.add(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtilRt.toStringArray(this.myFavoriteItems));
        this.update();
    }

    public void removeFavoriteItem(@NotNull Palette.Item item) {
        if (item == null) {
            DataModel.$$$reportNull$$$0(12);
        }
        if (!this.myFavoriteItems.contains(item.getId())) {
            return;
        }
        this.myFavoriteItems.remove(item.getId());
        PropertiesComponent.getInstance().setValues(FAVORITE_ITEMS, ArrayUtilRt.toStringArray(this.myFavoriteItems));
        this.update();
        if (this.myCurrentSelectedGroup == COMMON) {
            this.createFilteredItems(COMMON);
        }
    }

    @NotNull
    @VisibleForTesting
    Palette getPalette() {
        this.myPaletteLock.readLock().lock();
        Palette palette = this.myPalette;
        Palette palette2 = palette;
        if (palette2 == null) {
            DataModel.$$$reportNull$$$0(13);
        }
        return palette2;
        finally {
            this.myPaletteLock.readLock().unlock();
        }
    }

    @NotNull
    private static List<String> readFavoriteItems() {
        Object[] favorites = PropertiesComponent.getInstance().getValues(FAVORITE_ITEMS);
        if (favorites == null) {
            favorites = new String[]{"TextView", "Button", "ImageView", SdkConstants.RECYCLER_VIEW.oldName(), SdkConstants.RECYCLER_VIEW.newName(), "fragment", "ScrollView", "Switch"};
        }
        ArrayList arrayList = Lists.newArrayList((Object[])favorites);
        if (arrayList == null) {
            DataModel.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private void update(@NotNull NlPaletteModel paletteModel, @NotNull DesignerEditorFileType layoutType) {
        if (paletteModel == null) {
            DataModel.$$$reportNull$$$0(15);
        }
        if (layoutType == null) {
            DataModel.$$$reportNull$$$0(16);
        }
        if (this.myPaletteModel != paletteModel || layoutType != this.myLayoutType || this.myDisposed) {
            return;
        }
        this.myPaletteLock.writeLock().lock();
        try {
            this.myPalette = paletteModel.getPalette(this.myLayoutType);
            this.myDependencyManager.setPalette(this.myPalette, paletteModel.getModule());
        }
        finally {
            this.myPaletteLock.writeLock().unlock();
        }
        this.update();
    }

    private void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myLayoutType != null);
        final boolean isUserSearch = this.myFilterPattern.hasPattern();
        final ArrayList<Palette.Group> groups = new ArrayList<Palette.Group>();
        final ArrayList<Integer> matchCounts = isUserSearch ? new ArrayList<Integer>() : Collections.emptyList();
        groups.add(isUserSearch ? RESULTS : COMMON);
        if (isUserSearch) {
            matchCounts.add(0);
        }
        this.getPalette().accept(new Palette.Visitor(){
            private Palette.Group currentGroup;
            private int matchCount;
            {
                this.currentGroup = isUserSearch ? RESULTS : COMMON;
            }

            @Override
            public void visit(@NotNull Palette.Group group2) {
                if (group2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.currentGroup = group2;
                this.matchCount = 0;
            }

            @Override
            public void visit(@NotNull Palette.Item item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.currentGroup.equals(item.getParent()) && DataModel.this.myFilterCondition.value((Object)item)) {
                    ++this.matchCount;
                }
            }

            @Override
            public void visitAfter(@NotNull Palette.Group group2) {
                if (group2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.matchCount > 0) {
                    groups.add(group2);
                    if (isUserSearch) {
                        matchCounts.add(this.matchCount);
                        matchCounts.set(0, (Integer)matchCounts.get(0) + this.matchCount);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/DataModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAfter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myListModel.update(groups, matchCounts);
    }

    private void onDependenciesChanged() {
        this.update();
        this.categorySelectionChanged(this.myCurrentSelectedGroup);
    }

    private void createFilteredItems(@NotNull Palette.Group selectedGroup) {
        if (selectedGroup == null) {
            DataModel.$$$reportNull$$$0(17);
        }
        ArrayList<Palette.Item> items2 = new ArrayList<Palette.Item>();
        Palette.Visitor visitor = item -> {
            if (this.myFilterCondition.value((Object)item)) {
                items2.add(item);
            }
        };
        if (selectedGroup != COMMON && selectedGroup != RESULTS) {
            selectedGroup.accept(visitor);
        } else if (this.myListModel.getSize() <= 1 || selectedGroup == RESULTS) {
            this.getPalette().accept(visitor);
        } else {
            Palette palette = this.getPalette();
            for (String id : this.myFavoriteItems) {
                Palette.Item item2 = palette.getItemById(id);
                if (item2 == null) continue;
                visitor.visit(item2);
            }
        }
        this.updateItemModel(items2);
    }

    private void updateItemModel(@NotNull List<Palette.Item> items2) {
        if (items2 == null) {
            DataModel.$$$reportNull$$$0(18);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myItemModel.update(items2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/DataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedGroup";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paletteModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/DataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryListModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemListModel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setLayoutTypeAsync";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readFavoriteItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutTypeAsync";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFilterPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "categorySelectionChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFavoriteItem";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFavoriteItem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFavoriteItem";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredItems";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateItemModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

