/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.CustomViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NlPaletteModel
implements Disposable {
    private boolean myDisposed;
    @VisibleForTesting
    static final String PROJECT_GROUP = "Project";
    private static final Function<Project, Query<PsiClass>> VIEW_CLASSES_QUERY = project -> {
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
        if (viewClass == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
    };
    private final Map<LayoutEditorFileType, Palette> myTypeToPalette;
    private final Module myModule;
    private final List<UpdateListener> myListeners;

    public void dispose() {
        this.myListeners.clear();
        this.myTypeToPalette.clear();
        this.myDisposed = true;
    }

    @TestOnly
    public List<UpdateListener> getUpdateListeners() {
        return this.myListeners;
    }

    public static NlPaletteModel get(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            NlPaletteModel.$$$reportNull$$$0(0);
        }
        return (NlPaletteModel)facet2.getModule().getService(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Module module) {
        if (module == null) {
            NlPaletteModel.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createConcurrentList();
        this.myTypeToPalette = Collections.synchronizedMap(new HashMap());
        this.myModule = module;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            NlPaletteModel.$$$reportNull$$$0(2);
        }
        return module;
    }

    @Slow
    @NotNull
    public Palette getPalette(@NotNull LayoutEditorFileType type) {
        Palette palette;
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(3);
        }
        if ((palette = this.myTypeToPalette.get(type)) == null) {
            palette = this.loadPalette(type);
            this.myTypeToPalette.put(type, palette);
            this.registerAdditionalComponents(type);
        }
        Palette palette2 = palette;
        if (palette2 == null) {
            NlPaletteModel.$$$reportNull$$$0(4);
        }
        return palette2;
    }

    private void registerAdditionalComponents(@NotNull LayoutEditorFileType type) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(5);
        }
        this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY);
        AndroidProjectBuildNotifications.subscribe(this.myModule.getProject(), this, context -> this.loadAdditionalComponents(type, VIEW_CLASSES_QUERY));
    }

    public void addUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.add(updateListener);
    }

    public void removeUpdateListener(@Nullable UpdateListener updateListener) {
        this.myListeners.remove(updateListener);
    }

    private void notifyUpdateListener(@NotNull LayoutEditorFileType layoutType) {
        if (layoutType == null) {
            NlPaletteModel.$$$reportNull$$$0(6);
        }
        if (!this.myListeners.isEmpty()) {
            this.myListeners.forEach(listener2 -> ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myDisposed) {
                    listener2.update(this, layoutType);
                }
            }));
        }
    }

    @VisibleForTesting
    @NotNull
    public static String getPaletteFileNameFromId(@NotNull String id) {
        if (id == null) {
            NlPaletteModel.$$$reportNull$$$0(7);
        }
        String string = id + "_palette.xml";
        if (string == null) {
            NlPaletteModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    @Slow
    @NotNull
    private Palette loadPalette(@NotNull LayoutEditorFileType type) {
        String id;
        block11: {
            if (type == null) {
                NlPaletteModel.$$$reportNull$$$0(9);
            }
            id = type.getPaletteId();
            if (id != null) break block11;
            Logger.getInstance(NlPaletteModel.class).warn(type + " has no palette id. No palette will be used.");
            Palette palette = Palette.EMPTY;
            if (palette == null) {
                NlPaletteModel.$$$reportNull$$$0(10);
            }
            return palette;
        }
        URL url = NlPaletteModel.class.getResource(NlPaletteModel.getPaletteFileNameFromId(id));
        URLConnection connection = url.openConnection();
        InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myModule.getProject()));
        ((Reader)reader).close();
        Palette palette2 = palette;
        if (palette2 == null) {
            NlPaletteModel.$$$reportNull$$$0(11);
        }
        return palette2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | JAXBException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @VisibleForTesting
    void loadAdditionalComponents(@NotNull LayoutEditorFileType type, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(12);
        }
        if (viewClasses == null) {
            NlPaletteModel.$$$reportNull$$$0(13);
        }
        Application application = ApplicationManager.getApplication();
        Project project = this.myModule.getProject();
        ReadAction.nonBlocking(() -> CustomViewInfo.fromPsiClasses((Query<PsiClass>)((Query)viewClasses.apply(project)))).expireWhen(() -> Disposer.isDisposed((Disposable)this)).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService()).onSuccess(viewInfos -> application.executeOnPooledThread(() -> this.replaceProjectComponents(type, (Collection<CustomViewInfo>)viewInfos))).onError(error -> NlPaletteModel.getLogger().error(error));
    }

    @Slow
    private void replaceProjectComponents(@NotNull LayoutEditorFileType type, Collection<CustomViewInfo> viewInfos) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(14);
        }
        Palette palette = this.loadPalette(type);
        viewInfos.forEach(viewInfo -> this.addAdditionalComponent(type, PROJECT_GROUP, palette, StudioIcons.LayoutEditor.Palette.CUSTOM_VIEW, viewInfo.tagName, viewInfo.className, null, null, "", null, Collections.emptyList(), Collections.emptyList()));
        this.myTypeToPalette.put(type, palette);
        this.notifyUpdateListener(type);
    }

    @VisibleForTesting
    boolean addAdditionalComponent(@NotNull LayoutEditorFileType type, @NotNull String groupName, @NotNull Palette palette, @Nullable Icon icon16, @NotNull String tagName, @NotNull String className, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties, @NotNull List<String> layoutProperties) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(15);
        }
        if (groupName == null) {
            NlPaletteModel.$$$reportNull$$$0(16);
        }
        if (palette == null) {
            NlPaletteModel.$$$reportNull$$$0(17);
        }
        if (tagName == null) {
            NlPaletteModel.$$$reportNull$$$0(18);
        }
        if (className == null) {
            NlPaletteModel.$$$reportNull$$$0(19);
        }
        if (libraryCoordinate == null) {
            NlPaletteModel.$$$reportNull$$$0(20);
        }
        if (properties == null) {
            NlPaletteModel.$$$reportNull$$$0(21);
        }
        if (layoutProperties == null) {
            NlPaletteModel.$$$reportNull$$$0(22);
        }
        if (tagName.indexOf(46) < 0 || !NlComponentHelper.INSTANCE.viewClassToTag(tagName).equals(tagName) || SdkConstants.CONSTRAINT_LAYOUT.isEquals(tagName)) {
            return false;
        }
        ViewHandler handler = this.findOrCreateCustomHandler(tagName, icon16, className, xml, previewXml, libraryCoordinate, preferredProperty, properties, layoutProperties);
        if (type != LayoutFileType.INSTANCE || handler == null || handler instanceof PreferenceHandler || handler instanceof PreferenceCategoryHandler || handler instanceof MenuHandler || handler instanceof ActionMenuViewHandler) {
            return false;
        }
        List<Palette.BaseItem> groups = palette.getItems();
        Palette.Group group2 = groups.stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> groupName.equals(g.getName())).findFirst().orElse(null);
        if (group2 == null) {
            group2 = new Palette.Group(groupName);
            groups.add(group2);
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        Palette.Item item = new Palette.Item(tagName, handler);
        group2.getItems().add(item);
        item.setUp(palette, manager);
        item.setParent(group2);
        return true;
    }

    @Nullable
    private ViewHandler findOrCreateCustomHandler(@NotNull String tagName, @Nullable Icon icon16, @NotNull String className, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties, @NotNull List<String> layoutProperties) {
        ViewHandler handler;
        if (tagName == null) {
            NlPaletteModel.$$$reportNull$$$0(23);
        }
        if (className == null) {
            NlPaletteModel.$$$reportNull$$$0(24);
        }
        if (libraryCoordinate == null) {
            NlPaletteModel.$$$reportNull$$$0(25);
        }
        if (properties == null) {
            NlPaletteModel.$$$reportNull$$$0(26);
        }
        if (layoutProperties == null) {
            NlPaletteModel.$$$reportNull$$$0(27);
        }
        if ((handler = BuiltinViewHandlerProvider.INSTANCE.findHandler(tagName)) != null) {
            return handler;
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        handler = manager.getHandlerOrDefault(tagName);
        if (handler instanceof ConstraintHelperHandler) {
            return null;
        }
        if (handler instanceof CustomViewGroupHandler && ((CustomViewGroupHandler)handler).getTagName().equals(tagName)) {
            return handler;
        }
        if (handler instanceof CustomViewHandler && ((CustomViewHandler)handler).getTagName().equals(tagName)) {
            return handler;
        }
        handler = handler instanceof ViewGroupHandler ? new CustomViewGroupHandler((ViewGroupHandler)handler, icon16, tagName, className, xml, previewXml, libraryCoordinate, preferredProperty, properties, layoutProperties) : new CustomViewHandler(handler, icon16, tagName, className, xml, previewXml, libraryCoordinate, preferredProperty, properties);
        manager.registerHandler(tagName, handler);
        return handler;
    }

    private static Logger getLogger() {
        return Logger.getInstance(NlPaletteModel.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClasses";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryCoordinate";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaletteFileNameFromId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPalette";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPalette";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalComponents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyUpdateListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPaletteFileNameFromId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPalette";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalComponents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceProjectComponents";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalComponent";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateCustomHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UpdateListener {
        public void update(@NotNull NlPaletteModel var1, @NotNull LayoutEditorFileType var2);
    }

    private static class CustomViewInfo {
        public final String description;
        public final String tagName;
        public final String className;

        CustomViewInfo(String description, String tagName, String className) {
            this.description = description;
            this.tagName = tagName;
            this.className = className;
        }

        static Collection<CustomViewInfo> fromPsiClasses(Query<PsiClass> psiClasses) {
            ArrayList<CustomViewInfo> componentInfos = new ArrayList<CustomViewInfo>();
            psiClasses.forEach(psiClass -> {
                String description = psiClass.getName();
                String tagName = psiClass.getQualifiedName();
                String className = PackageClassConverter.getQualifiedName(psiClass);
                if (description == null || tagName == null || className == null) {
                    return;
                }
                componentInfos.add(new CustomViewInfo(description, tagName, className));
            });
            return componentInfos;
        }
    }
}

