/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.AttributeBrowser;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import com.android.tools.property.ptable.PTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BoxLayout;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowsePanel
extends AdtSecondaryPanel {
    private final Context myContext;
    private final ActionButton myBrowseButton;
    private final ActionButton myDesignButton;
    private PropertyDesignState myDesignState;

    public BrowsePanel() {
        this(null, true);
    }

    public BrowsePanel(@Nullable Context context, boolean showDesignButton) {
        this.myContext = context;
        this.myBrowseButton = BrowsePanel.createActionButton(new BrowseAction(context));
        this.myDesignButton = showDesignButton ? BrowsePanel.createActionButton(this.createDesignAction()) : null;
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.add((Component)this.myBrowseButton);
        this.myBrowseButton.setFocusable(true);
        if (this.myDesignButton != null) {
            this.add((Component)this.myDesignButton);
            this.myDesignButton.setFocusable(true);
        }
    }

    public void setDesignState(@NotNull PropertyDesignState designState) {
        if (designState == null) {
            BrowsePanel.$$$reportNull$$$0(0);
        }
        this.myDesignState = designState;
    }

    public void setProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(1);
        }
        this.myBrowseButton.setVisible(BrowsePanel.hasBrowseDialog(property2));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (event == null) {
            BrowsePanel.$$$reportNull$$$0(2);
        }
        if (rectRightColumn == null) {
            BrowsePanel.$$$reportNull$$$0(3);
        }
        if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth()) {
            this.myDesignButton.click();
        } else if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth()) {
            this.myBrowseButton.click();
        }
    }

    public void mouseMoved(@NotNull PTable table2, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (table2 == null) {
            BrowsePanel.$$$reportNull$$$0(4);
        }
        if (event == null) {
            BrowsePanel.$$$reportNull$$$0(5);
        }
        if (rectRightColumn == null) {
            BrowsePanel.$$$reportNull$$$0(6);
        }
        table2.setExpandableItemsEnabled((double)event.getX() < rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth());
    }

    private int getDesignButtonWidth() {
        return this.myDesignButton != null ? this.myDesignButton.getWidth() : 0;
    }

    private int getBrowseButtonWidth() {
        return this.myBrowseButton.isVisible() ? this.myBrowseButton.getWidth() : 0;
    }

    @NotNull
    private static ActionButton createActionButton(@NotNull AnAction action2) {
        if (action2 == null) {
            BrowsePanel.$$$reportNull$$$0(7);
        }
        return new ActionButton(action2, action2.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
    }

    private static ChooseResourceDialog showResourceChooser(@NotNull NlProperty property2, @NotNull XmlTag tag) {
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(8);
        }
        if (tag == null) {
            BrowsePanel.$$$reportNull$$$0(9);
        }
        Module module = property2.getModel().getModule();
        Set<ResourceType> types = BrowsePanel.getResourceTypes(property2);
        boolean onlyLayoutType = types.size() == 1 && types.contains(ResourceType.LAYOUT);
        String propertyName = property2.getName();
        ResourceType defaultResourceType = BrowsePanel.getDefaultResourceType(propertyName);
        boolean isImageViewDrawable = "ImageView".equals(property2.getTagName()) && ("srcCompat".equals(propertyName) || "src".equals(propertyName));
        return ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(property2.getValue()).setTag(tag).setDefaultType(defaultResourceType).setFilterColorStateLists(isImageViewDrawable).setShowSampleDataPicker(!onlyLayoutType && "http://schemas.android.com/tools".equals(property2.getNamespace())).build();
    }

    public static boolean hasBrowseDialog(@NotNull NlProperty property2) {
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(10);
        }
        return property2 != EmptyProperty.INSTANCE && (BrowsePanel.getBrowser(property2) != null || !BrowsePanel.getResourceTypes(property2).isEmpty());
    }

    @Nullable
    public static String showBrowseDialog(@NotNull NlProperty property2) {
        ChooseResourceDialog dialog2;
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(11);
        }
        AttributeBrowser browser = BrowsePanel.getBrowser(property2);
        XmlTag tag = property2.getTag();
        if (browser != null) {
            ViewEditorImpl editor2 = new ViewEditorImpl(property2.getModel());
            return browser.browse(editor2, property2.getValue());
        }
        if (!BrowsePanel.getResourceTypes(property2).isEmpty() && tag != null && (dialog2 = BrowsePanel.showResourceChooser(property2, tag)).showAndGet()) {
            return dialog2.getResourceName();
        }
        return null;
    }

    @Nullable
    private static AttributeBrowser getBrowser(@NotNull NlProperty property2) {
        Project project;
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(12);
        }
        if ((project = property2.getModel().getProject()).isDisposed()) {
            return null;
        }
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
        for (NlComponent component3 : property2.getComponents()) {
            AttributeBrowser browser;
            ViewHandler handler = viewHandlerManager.getHandler(component3);
            if (handler == null || (browser = handler.getBrowser(property2.getName())) == null) continue;
            return browser;
        }
        return null;
    }

    @NotNull
    public static Set<ResourceType> getResourceTypes(@NotNull NlProperty property2) {
        String propertyName;
        if (property2 == null) {
            BrowsePanel.$$$reportNull$$$0(13);
        }
        if ((propertyName = property2.getName()).equals("id")) {
            EnumSet<ResourceType> enumSet = EnumSet.noneOf(ResourceType.class);
            if (enumSet == null) {
                BrowsePanel.$$$reportNull$$$0(14);
            }
            return enumSet;
        }
        AttributeDefinition definition = property2.getDefinition();
        Set<AttributeFormat> formats = definition != null ? definition.getFormats() : EnumSet.allOf(AttributeFormat.class);
        Collection<ResourceType> types = AndroidDomUtil.getSpecialResourceTypes(propertyName);
        Set<ResourceType> set = types.isEmpty() ? BrowsePanel.matchingTypes(formats) : EnumSet.copyOf(types);
        if (set == null) {
            BrowsePanel.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static Set<ResourceType> matchingTypes(Set<AttributeFormat> formats) {
        EnumSet<ResourceType> types = EnumSet.noneOf(ResourceType.class);
        for (AttributeFormat format : formats) {
            if (format == AttributeFormat.REFERENCE) {
                types.add(ResourceType.COLOR);
                types.add(ResourceType.DRAWABLE);
                types.add(ResourceType.MIPMAP);
                types.add(ResourceType.STRING);
                types.add(ResourceType.ID);
                types.add(ResourceType.STYLE);
                types.add(ResourceType.ARRAY);
                continue;
            }
            types.addAll(format.getMatchingTypes());
        }
        return types;
    }

    @Nullable
    private static ResourceType getDefaultResourceType(@NotNull String propertyName) {
        String lowerCaseProperty;
        if (propertyName == null) {
            BrowsePanel.$$$reportNull$$$0(16);
        }
        if ((lowerCaseProperty = StringUtil.toLowerCase((String)propertyName)).contains("color") || lowerCaseProperty.contains("tint")) {
            return ResourceType.COLOR;
        }
        if (lowerCaseProperty.contains("drawable") || propertyName.equals("src") || propertyName.equals("srcCompat")) {
            return ResourceType.DRAWABLE;
        }
        return null;
    }

    private AnAction createDesignAction() {
        return new AnAction(){

            public void update(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Presentation presentation = event.getPresentation();
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        presentation.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                        presentation.setText("Specify Design Property");
                        presentation.setEnabledAndVisible(true);
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        presentation.setIcon(AllIcons.Actions.Cancel);
                        presentation.setText("Remove this Design Property");
                        presentation.setEnabledAndVisible(true);
                        break;
                    }
                    default: {
                        presentation.setIcon(null);
                        presentation.setText(Presentation.NULL_STRING);
                        presentation.setEnabledAndVisible(false);
                    }
                }
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (BrowsePanel.this.myContext == null) {
                    return;
                }
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.addDesignProperty();
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.removeDesignProperty();
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designState";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectRightColumn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDesignState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showResourceChooser";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasBrowseDialog";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showBrowseDialog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBrowser";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResourceType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class BrowseAction
    extends AnAction {
        private final Context myContext;

        private BrowseAction(@Nullable Context context) {
            this.myContext = context;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Ellipsis);
            presentation.setText("Pick a Resource");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                BrowseAction.$$$reportNull$$$0(0);
            }
            if (this.myContext == null) {
                return;
            }
            NlProperty property2 = this.myContext.getProperty();
            if (property2 == null) {
                return;
            }
            String newValue = BrowsePanel.showBrowseDialog(property2);
            this.myContext.cancelEditing();
            if (newValue != null) {
                this.myContext.stopEditing(newValue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$BrowseAction", "actionPerformed"));
        }
    }

    public static class ContextDelegate
    implements Context {
        private NlComponentEditor myEditor;

        @Override
        @Nullable
        public NlProperty getProperty() {
            return this.myEditor != null ? this.myEditor.getProperty() : null;
        }

        public void setEditor(@NotNull NlComponentEditor editor2) {
            if (editor2 == null) {
                ContextDelegate.$$$reportNull$$$0(0);
            }
            this.myEditor = editor2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$ContextDelegate", "setEditor"));
        }
    }

    public static interface Context {
        @Nullable
        public NlProperty getProperty();

        default public void cancelEditing() {
        }

        default public void stopEditing(@Nullable Object newValue) {
            NlProperty property2 = this.getProperty();
            if (property2 != null) {
                property2.setValue(newValue);
            }
        }

        default public void addDesignProperty() {
            throw new UnsupportedOperationException();
        }

        default public void removeDesignProperty() {
            throw new UnsupportedOperationException();
        }
    }
}

