/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.property.NlProperty;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Quantity
implements Comparable<Quantity> {
    private static final Pattern QUANTITY_PATTERN = Pattern.compile("^(-?\\d+(\\.\\d+)?)(.*)$");
    private final int myValue;
    private final String myUnit;

    @Nullable
    public static Quantity parse(@NotNull String value2) {
        Matcher matcher;
        if (value2 == null) {
            Quantity.$$$reportNull$$$0(0);
        }
        if (!(matcher = QUANTITY_PATTERN.matcher(value2)).matches()) {
            return null;
        }
        try {
            return new Quantity(Integer.parseInt(matcher.group(1)), matcher.group(3).trim());
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @NotNull
    public static String addUnit(@NotNull NlProperty property2, @NotNull String value2) {
        AttributeDefinition definition;
        boolean isDimension;
        if (property2 == null) {
            Quantity.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            Quantity.$$$reportNull$$$0(2);
        }
        boolean bl = isDimension = (definition = property2.getDefinition()) != null && definition.getFormats().contains(AttributeFormat.DIMENSION);
        if (!isDimension) {
            String string = value2;
            if (string == null) {
                Quantity.$$$reportNull$$$0(3);
            }
            return string;
        }
        Quantity quantity = Quantity.parse(value2);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            String string = value2;
            if (string == null) {
                Quantity.$$$reportNull$$$0(4);
            }
            return string;
        }
        switch (property2.getName()) {
            case "textSize": 
            case "lineSpacingExtra": {
                String string = quantity.myValue + "sp";
                if (string == null) {
                    Quantity.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        String string = quantity.myValue + "dp";
        if (string == null) {
            Quantity.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static String addUnit(@NotNull ResourceType type, @NotNull String value2) {
        if (type == null) {
            Quantity.$$$reportNull$$$0(7);
        }
        if (value2 == null) {
            Quantity.$$$reportNull$$$0(8);
        }
        if (type != ResourceType.DIMEN) {
            return value2;
        }
        Quantity quantity = Quantity.parse(value2);
        if (quantity == null || !quantity.myUnit.isEmpty()) {
            return value2;
        }
        return quantity.myValue + "dp";
    }

    private Quantity(int value2, @NotNull String unit) {
        if (unit == null) {
            Quantity.$$$reportNull$$$0(9);
        }
        this.myValue = value2;
        this.myUnit = unit;
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public String getUnit() {
        String string = this.myUnit;
        if (string == null) {
            Quantity.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public int compareTo(@Nullable Quantity other) {
        if (other == null) {
            return -1;
        }
        return Comparator.comparing(Quantity::getUnit).thenComparing(Quantity::getValue).compare(this, other);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/Quantity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/Quantity";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addUnit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addUnit";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

