/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.Density;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    private final Supplier<RenderSettings> myRenderSettingsProvider;
    @Nullable
    private SceneView mySecondarySceneView;
    private int myDpi;
    private final SelectionChangeListener mySelectionChangeListener;
    private final ModelChangeListener myModelChangeListener;
    private final ConfigurationListener myConfigurationChangeListener;
    private boolean myAreListenersRegistered;
    private final Object myProgressLock;
    @GuardedBy(value="myProgressLock")
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final Object myRenderingQueueLock;
    @GuardedBy(value="myRenderingQueueLock")
    private MergingUpdateQueue myRenderingQueue;
    private static final int RENDER_DELAY_MS = 10;
    private RenderTask myRenderTask;
    private final Object myRenderingTaskLock;
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock;
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myRenderResult;
    private String myPreviousDeviceName;
    private Locale myPreviousLocale;
    private String myPreviousVersion;
    private String myPreviousTheme;
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private long myElapsedFrameTimeMs;
    private final LinkedList<CompletableFuture<Void>> myRenderFutures;
    private final Semaphore myUpdateHierarchyLock;
    @NotNull
    private final ViewEditor myViewEditor;
    private final ListenerCollection<RenderListener> myRenderListeners;
    @NotNull
    private final Executor myRenderTaskDisposerExecutor;
    private final AtomicBoolean myIsCurrentlyRendering;
    private boolean useTransparentRendering;
    private boolean useShrinkRendering;
    private final AtomicBoolean myForceInflate;
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    protected LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull Supplier<RenderSettings> settingsProvider2, @NotNull Executor renderTaskDisposerExecutor) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(0);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(1);
        }
        if (settingsProvider2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(2);
        }
        if (renderTaskDisposerExecutor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(3);
        }
        super(model2, designSurface, settingsProvider2);
        this.myDpi = 0;
        this.mySelectionChangeListener = new SelectionChangeListener();
        this.myModelChangeListener = new ModelChangeListener();
        this.myConfigurationChangeListener = new ConfigurationChangeListener();
        this.myProgressLock = new Object();
        this.myRenderingQueueLock = new Object();
        this.myRenderingTaskLock = new Object();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myElapsedFrameTimeMs = -1L;
        this.myRenderFutures = new LinkedList();
        this.myUpdateHierarchyLock = new Semaphore(1);
        this.myRenderListeners = ListenerCollection.createWithDirectExecutor();
        this.myIsCurrentlyRendering = new AtomicBoolean(false);
        this.useTransparentRendering = false;
        this.useShrinkRendering = false;
        this.myForceInflate = new AtomicBoolean(false);
        this.myRenderSettingsProvider = settingsProvider2;
        this.myRenderTaskDisposerExecutor = renderTaskDisposerExecutor;
        this.createSceneView();
        this.updateTrackingConfiguration();
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        Scene scene = this.getScene();
        this.myViewEditor = new ViewEditorImpl(model2, scene);
        model2.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            List<SceneComponent> hierarchy = this.createHierarchy(rootComponent);
            SceneComponent root2 = hierarchy.isEmpty() ? null : hierarchy.get(0);
            this.updateFromComponent(root2, new HashSet<SceneComponent>());
            scene.setRoot(root2);
            this.updateTargets();
            scene.setAnimated(previous);
        }
        model2.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), (List<NlComponent>)this.getDesignSurface().getSelectionModel().getSelection());
    }

    public LayoutlibSceneManager(@NotNull NlModel model2, @NotNull DesignSurface designSurface, @NotNull Supplier<RenderSettings> renderSettingsProvider) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(4);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(5);
        }
        if (renderSettingsProvider == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(6);
        }
        this(model2, designSurface, renderSettingsProvider, AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public ViewEditor getViewEditor() {
        ViewEditor viewEditor = this.myViewEditor;
        if (viewEditor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(7);
        }
        return viewEditor;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component3) {
        if (component3 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(8);
        }
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component3);
        tempComponent.setTargetProvider(sceneComponent -> ImmutableList.of((Object)new ConstraintDragDndTarget()));
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.updateFromComponent(tempComponent);
        scene.setAnimated(true);
        TemporarySceneComponent temporarySceneComponent = tempComponent;
        if (temporarySceneComponent == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(9);
        }
        return temporarySceneComponent;
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        SceneDecoratorFactory sceneDecoratorFactory = DECORATOR_FACTORY;
        if (sceneDecoratorFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(10);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public float getSceneScalingFactor() {
        return (float)this.getModel().getConfiguration().getDensity().getDpiValue() / (float)Density.DEFAULT_DENSITY;
    }

    @Override
    public void dispose() {
        if (this.myAreListenersRegistered) {
            NlModel model2 = this.getModel();
            this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
            model2.getConfiguration().removeListener(this.myConfigurationChangeListener);
            model2.removeListener(this.myModelChangeListener);
            model2.removeListener(this.myModelChangeListener);
        }
        this.myRenderListeners.clear();
        this.stopProgressIndicator();
        super.dispose();
        this.myRenderTaskDisposerExecutor.execute(this::disposeRenderTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeRenderTask() {
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null) {
                this.myRenderTask.dispose();
                this.myRenderTask = null;
            }
        }
        this.myRenderResultLock.writeLock().lock();
        try {
            if (this.myRenderResult != null) {
                this.myRenderResult.dispose();
            }
            this.myRenderResult = null;
        }
        finally {
            this.myRenderResultLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProgressIndicator() {
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator != null) {
                this.myCurrentIndicator.stop();
                this.myCurrentIndicator = null;
            }
        }
    }

    @Override
    @NotNull
    protected NlDesignSurface getDesignSurface() {
        NlDesignSurface nlDesignSurface = (NlDesignSurface)super.getDesignSurface();
        if (nlDesignSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(11);
        }
        return nlDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType type = model2.getType();
        if (type == MenuFileType.INSTANCE) {
            SceneView sceneView = this.createSceneViewsForMenu();
            if (sceneView == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(12);
            }
            return sceneView;
        }
        SceneMode mode = this.getDesignSurface().getSceneMode();
        ScreenView primarySceneView = mode.createPrimarySceneView(this.getDesignSurface(), this);
        this.mySecondarySceneView = mode.createSecondarySceneView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(primarySceneView.getPreferredSize());
        ScreenView screenView = primarySceneView;
        if (screenView == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(13);
        }
        return screenView;
    }

    private SceneView createSceneViewsForMenu() {
        NlModel model2 = this.getModel();
        XmlTag tag = model2.getFile().getRootTag();
        ScreenView sceneView = tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view") ? new NavigationViewSceneView(this.getDesignSurface(), this) : new ScreenView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(sceneView.getPreferredSize());
        return sceneView;
    }

    @Override
    @NotNull
    public ImmutableList<Layer> getLayers() {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        builder2.addAll(super.getLayers());
        if (this.mySecondarySceneView != null) {
            builder2.addAll(this.mySecondarySceneView.getLayers());
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(14);
        }
        return immutableList;
    }

    @Nullable
    public SceneView getSecondarySceneView() {
        return this.mySecondarySceneView;
    }

    @Override
    protected void updateFromComponent(SceneComponent sceneComponent) {
        super.updateFromComponent(sceneComponent);
        NlComponent component3 = sceneComponent.getNlComponent();
        boolean animate = this.getScene().isAnimated() && !sceneComponent.hasNoDimension();
        SceneManager manager = sceneComponent.getScene().getSceneManager();
        if (animate) {
            long time2 = System.currentTimeMillis();
            sceneComponent.setPositionTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component3)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component3)), time2);
            sceneComponent.setSizeTarget(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component3)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component3)), time2);
        } else {
            sceneComponent.setPosition(Coordinates.pxToDp(manager, NlComponentHelperKt.getX(component3)), Coordinates.pxToDp(manager, NlComponentHelperKt.getY(component3)));
            sceneComponent.setSize(Coordinates.pxToDp(manager, NlComponentHelperKt.getW(component3)), Coordinates.pxToDp(manager, NlComponentHelperKt.getH(component3)));
        }
    }

    public void updateTargets() {
        SceneComponent root2 = this.getScene().getRoot();
        if (root2 != null) {
            LayoutlibSceneManager.updateTargetProviders(root2);
            root2.updateTargets();
        }
    }

    private static void updateTargetProviders(@NotNull SceneComponent component3) {
        if (component3 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(15);
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component3.getNlComponent());
        component3.setTargetProvider(handler);
        for (SceneComponent child : component3.getChildren()) {
            LayoutlibSceneManager.updateTargetProviders(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletableFuture<Void> requestRender(final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        LinkedList<CompletableFuture<Void>> linkedList = this.myRenderFutures;
        synchronized (linkedList) {
            this.myRenderFutures.add(callback2);
        }
        if (this.myIsCurrentlyRendering.get()) {
            CompletableFuture<Void> completableFuture = callback2;
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(16);
            }
            return completableFuture;
        }
        this.getRenderingQueue().queue(new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.render(trigger);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
        CompletableFuture<Void> completableFuture = callback2;
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        return this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    @NotNull
    public CompletableFuture<Void> requestUserInitiatedRender() {
        this.forceReinflate();
        return this.requestRender(LayoutEditorRenderResult.Trigger.USER);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestLayoutAndRender(boolean animate) {
        if (this.getDesignSurface().getSceneMode() == SceneMode.BLUEPRINT) {
            CompletableFuture<Void> completableFuture = this.requestLayout(animate);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(18);
            }
            return completableFuture;
        }
        if (this.getDesignSurface().isRenderingSynchronously()) {
            CompletionStage completionStage = this.render(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType())).thenRun(() -> this.notifyListenersModelLayoutComplete(animate));
            if (completionStage == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(19);
            }
            return completionStage;
        }
        CompletableFuture<Void> completableFuture = this.doRequestLayoutAndRender(animate);
        if (completableFuture == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(20);
        }
        return completableFuture;
    }

    @NotNull
    CompletableFuture<Void> doRequestLayoutAndRender(boolean animate) {
        CompletionStage completionStage = this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType())).whenCompleteAsync((result2, ex) -> this.notifyListenersModelLayoutComplete(animate), (Executor)AppExecutorUtil.getAppExecutorService());
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(21);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestModelUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator == null) {
                this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
                this.myCurrentIndicator.start();
            }
        }
        this.getRenderingQueue().queue(new Update("model.update", 10){

            public void run() {
                NlModel model2 = LayoutlibSceneManager.this.getModel();
                Project project = model2.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model2.getVirtualFile().isValid() && !model2.getFacet().isDisposed()) {
                        LayoutlibSceneManager.this.updateModel().whenComplete((result2, ex) -> LayoutlibSceneManager.this.stopProgressIndicator());
                    } else {
                        LayoutlibSceneManager.this.stopProgressIndicator();
                    }
                });
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        // MONITORENTER : object
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
            this.myRenderingQueue.setRestartTimerOnAdd(true);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myRenderingQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        LayoutlibSceneManager.$$$reportNull$$$0(22);
        return mergingUpdateQueue;
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    public void setTransparentRendering(boolean enabled) {
        this.useTransparentRendering = enabled;
    }

    public void setShrinkRendering(boolean enabled) {
        this.useShrinkRendering = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public CompletableFuture<Void> requestLayout(boolean animate) {
        Object object = this.myRenderingTaskLock;
        // MONITORENTER : object
        if (this.myRenderTask == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : object
            if (completableFuture != null) return completableFuture;
            LayoutlibSceneManager.$$$reportNull$$$0(23);
            return completableFuture;
        }
        CompletionStage completionStage = this.myRenderTask.layout().thenAccept(result2 -> {
            if (result2 != null) {
                this.updateHierarchy((RenderResult)result2);
                this.notifyListenersModelLayoutComplete(animate);
            }
        });
        // MONITOREXIT : object
        if (completionStage != null) return completionStage;
        LayoutlibSceneManager.$$$reportNull$$$0(24);
        return completionStage;
    }

    @Override
    public void layout(boolean animate) {
        try {
            this.requestLayout(animate).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Logger.getInstance(LayoutlibSceneManager.class).warn("Unable to run layout()", (Throwable)e);
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, Map<ResourceReference, ResourceValue>> map2 = Collections.emptyMap();
            Map<Object, Map<ResourceReference, ResourceValue>> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(25);
            }
            return map3;
        }
        Map<Object, Map<ResourceReference, ResourceValue>> map4 = this.myRenderResult.getDefaultProperties();
        Map<Object, Map<ResourceReference, ResourceValue>> map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(26);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, String> getDefaultStyles() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, String> map2 = Collections.emptyMap();
            Map<Object, String> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(27);
            }
            return map3;
        }
        Map<Object, String> map4 = this.myRenderResult.getDefaultStyles();
        Map<Object, String> map5 = map4;
        if (map5 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(28);
        }
        return map5;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result2) {
        try {
            this.myUpdateHierarchyLock.acquire();
            try {
                if (result2 == null || !result2.getRenderResult().isSuccess()) {
                    LayoutlibSceneManager.updateHierarchy(Collections.emptyList(), this.getModel());
                } else {
                    LayoutlibSceneManager.updateHierarchy(this.getRootViews(result2), this.getModel());
                }
            }
            finally {
                this.myUpdateHierarchyLock.release();
            }
            this.getModel().checkStructure();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    private List<ViewInfo> getRootViews(@NotNull RenderResult result2) {
        if (result2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(29);
        }
        ImmutableList<ViewInfo> immutableList = this.getModel().getType() == MenuFileType.INSTANCE ? result2.getSystemRootViews() : result2.getRootViews();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(30);
        }
        return immutableList;
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        if (rootTag == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(31);
        }
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(32);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(33);
        }
        model2.syncWithPsi(rootTag, rootViews.stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList()));
        LayoutlibSceneManager.updateBounds(rootViews, model2);
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        XmlTag root2;
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(34);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(35);
        }
        if ((root2 = LayoutlibSceneManager.getRootTag(model2)) != null) {
            LayoutlibSceneManager.updateHierarchy(root2, rootViews, model2);
        }
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model2) {
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(36);
        }
        if (Disposer.isDisposed((Disposable)model2)) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely((XmlFile)model2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> inflate(boolean force) {
        long startInflateTimeMs = System.currentTimeMillis();
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed()) {
            return CompletableFuture.completedFuture(false);
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                return CompletableFuture.completedFuture(false);
            }
        }
        AndroidFacet facet2 = this.getModel().getFacet();
        this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(facet2, (PsiFile)this.getModel().getFile(), configuration);
        RenderService renderService = RenderService.getInstance(this.getModel().getProject());
        RenderLogger logger2 = renderService.createLogger(facet2);
        RenderService.RenderTaskBuilder renderTaskBuilder = renderService.taskBuilder(facet2, configuration).withPsiFile((PsiFile)this.getModel().getFile()).withLogger(logger2);
        return this.setupRenderTaskBuilder(renderTaskBuilder).build().thenCompose(newTask -> {
            if (newTask != null) {
                newTask.getLayoutlibCallback().setAdaptiveIconMaskPath(this.getDesignSurface().getAdaptiveIconShape().getPathDescription());
                return ((CompletableFuture)((CompletableFuture)newTask.inflate().whenComplete((result2, exception) -> {
                    if (exception != null) {
                        Logger.getInstance(LayoutlibSceneManager.class).warn(exception);
                    }
                    if (result2 == null || !result2.getRenderResult().isSuccess()) {
                        newTask.dispose();
                    } else {
                        Object object = this.myRenderingTaskLock;
                        synchronized (object) {
                            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                                this.myRenderTask.dispose();
                            }
                            this.myRenderTask = newTask;
                        }
                    }
                })).thenApply(result2 -> {
                    if (result2 != null) {
                        CommonUsageTracker.Companion.getInstance(this.getDesignSurface()).logRenderResult(null, (RenderResult)result2, System.currentTimeMillis() - startInflateTimeMs, true);
                        return result2;
                    }
                    return RenderResult.createBlank((PsiFile)this.getModel().getFile());
                })).thenApply(result2 -> {
                    if (project.isDisposed()) {
                        return false;
                    }
                    this.updateHierarchy((RenderResult)result2);
                    this.myRenderResultLock.writeLock().lock();
                    try {
                        this.updateCachedRenderResult((RenderResult)result2);
                    }
                    finally {
                        this.myRenderResultLock.writeLock().unlock();
                    }
                    return true;
                });
            }
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                    this.myRenderTask.dispose();
                }
            }
            RenderResult result3 = RenderResult.createRenderTaskErrorResult((PsiFile)this.getModel().getFile(), logger2);
            this.myRenderResultLock.writeLock().lock();
            try {
                this.updateCachedRenderResult(result3);
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
            return CompletableFuture.completedFuture(false);
        });
    }

    @GuardedBy(value="myRenderResultLock")
    private void updateCachedRenderResult(RenderResult result2) {
        if (this.myRenderResult != null && this.myRenderResult != result2) {
            this.myRenderResult.dispose();
        }
        this.myRenderResult = result2;
    }

    @VisibleForTesting
    @NotNull
    protected RenderService.RenderTaskBuilder setupRenderTaskBuilder(@NotNull RenderService.RenderTaskBuilder taskBuilder) {
        RenderSettings settings;
        if (taskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(37);
        }
        if (!(settings = this.myRenderSettingsProvider.get()).getUseLiveRendering()) {
            taskBuilder.disableImagePool();
        }
        if (settings.getQuality() < 1.0f) {
            taskBuilder.withDownscaleFactor(settings.getQuality());
        }
        if (!settings.getShowDecorations()) {
            taskBuilder.disableDecorations();
        }
        if (this.useShrinkRendering) {
            taskBuilder.withRenderingMode(SessionParams.RenderingMode.SHRINK);
        }
        if (this.useTransparentRendering) {
            taskBuilder.useTransparentBackground();
        }
        if (!this.getDesignSurface().getPreviewWithToolsAttributes()) {
            taskBuilder.disableToolsAttributes();
        }
        RenderService.RenderTaskBuilder renderTaskBuilder = taskBuilder;
        if (renderTaskBuilder == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(38);
        }
        return renderTaskBuilder;
    }

    protected CompletableFuture<Void> updateModel() {
        return ((CompletableFuture)this.inflate(true).whenCompleteAsync((result2, exception) -> this.notifyListenersModelUpdateComplete(), (Executor)AppExecutorUtil.getAppExecutorService())).thenApply(result2 -> null);
    }

    protected void notifyListenersModelLayoutComplete(boolean animate) {
        this.getModel().notifyListenersModelChangedOnLayout(animate);
    }

    protected void notifyListenersModelUpdateComplete() {
        this.getModel().notifyListenersModelDerivedDataChanged();
    }

    private void logConfigurationChange(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(39);
        }
        Configuration configuration = this.getModel().getConfiguration();
        if (this.getModel().getConfigurationModificationCount() != configuration.getModificationCount()) {
            NlAnalyticsManager analyticsManager = ((NlDesignSurface)surface2).getAnalyticsManager();
            if (!StringUtil.equals((CharSequence)configuration.getTheme(), (CharSequence)this.myPreviousTheme)) {
                this.myPreviousTheme = configuration.getTheme();
                analyticsManager.trackThemeChange();
            } else if (configuration.getTarget() != null && !StringUtil.equals((CharSequence)configuration.getTarget().getVersionName(), (CharSequence)this.myPreviousVersion)) {
                this.myPreviousVersion = configuration.getTarget().getVersionName();
                analyticsManager.trackApiLevelChange();
            } else if (!configuration.getLocale().equals(this.myPreviousLocale)) {
                this.myPreviousLocale = configuration.getLocale();
                analyticsManager.trackLanguageChange();
            } else if (configuration.getDevice() != null && !StringUtil.equals((CharSequence)configuration.getDevice().getDisplayName(), (CharSequence)this.myPreviousDeviceName)) {
                this.myPreviousDeviceName = configuration.getDevice().getDisplayName();
                analyticsManager.trackDeviceChange();
            }
        }
    }

    @NotNull
    protected CompletableFuture<RenderResult> render(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletionStage completionStage;
        this.myIsCurrentlyRendering.set(true);
        try {
            NlDesignSurface surface2 = this.getDesignSurface();
            this.logConfigurationChange(surface2);
            this.getModel().resetLastChange();
            long renderStartTimeMs = System.currentTimeMillis();
            completionStage = this.renderImpl(trigger).thenApply(result2 -> {
                if (result2 == null) {
                    this.completeRender();
                    return null;
                }
                this.myRenderResultLock.writeLock().lock();
                try {
                    this.updateCachedRenderResult((RenderResult)result2);
                    if (!Disposer.isDisposed((Disposable)this)) {
                        this.update();
                    }
                    this.myRenderResultLock.readLock().lock();
                }
                finally {
                    this.myRenderResultLock.writeLock().unlock();
                }
                try {
                    long renderTimeMs = System.currentTimeMillis() - renderStartTimeMs;
                    NlDiagnosticsManager.getWriteInstance(surface2).recordRender(renderTimeMs, this.myRenderResult.getRenderedImage().getWidth() * this.myRenderResult.getRenderedImage().getHeight() * 4);
                }
                finally {
                    this.myRenderResultLock.readLock().unlock();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!Disposer.isDisposed((Disposable)this)) {
                        this.update();
                    }
                });
                this.fireRenderListeners();
                this.completeRender();
                return result2;
            });
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                this.completeRender();
                throw e;
            }
            this.completeRender();
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(41);
            }
            return completableFuture;
        }
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(40);
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRender() {
        ImmutableList callbacks;
        LinkedList<CompletableFuture<Void>> linkedList = this.myRenderFutures;
        synchronized (linkedList) {
            callbacks = ImmutableList.copyOf(this.myRenderFutures);
            this.myRenderFutures.clear();
        }
        callbacks.forEach(callback2 -> callback2.complete(null));
        this.myIsCurrentlyRendering.set(false);
    }

    @NotNull
    private CompletableFuture<RenderResult> renderImpl(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        CompletionStage completionStage = ((CompletableFuture)this.inflate(this.myForceInflate.getAndSet(false)).whenCompleteAsync((result2, ex) -> {
            if (ex != null) {
                Logger.getInstance(LayoutlibSceneManager.class).warn(ex);
            }
            if (result2.booleanValue()) {
                this.notifyListenersModelUpdateComplete();
            }
        }, (Executor)PooledThreadExecutor.INSTANCE)).thenCompose(inflated -> {
            long elapsedFrameTimeMs = this.myElapsedFrameTimeMs;
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask == null) {
                    this.getDesignSurface().updateErrorDisplay();
                    return CompletableFuture.completedFuture(null);
                }
                long startRenderTimeMs = System.currentTimeMillis();
                if (elapsedFrameTimeMs != -1L) {
                    this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(elapsedFrameTimeMs));
                }
                return this.myRenderTask.render().thenApply(result2 -> {
                    if (result2 != null && !inflated.booleanValue()) {
                        this.updateHierarchy((RenderResult)result2);
                    }
                    if (result2 != null) {
                        CommonUsageTracker.Companion.getInstance(this.getDesignSurface()).logRenderResult(trigger, (RenderResult)result2, System.currentTimeMillis() - startRenderTimeMs, false);
                    }
                    return result2;
                });
            }
        });
        if (completionStage == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(42);
        }
        return completionStage;
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    private void updateTrackingConfiguration() {
        Configuration configuration = this.getModel().getConfiguration();
        this.myPreviousDeviceName = configuration.getCachedDevice() != null ? configuration.getCachedDevice().getDisplayName() : null;
        this.myPreviousVersion = configuration.getTarget() != null ? configuration.getTarget().getVersionName() : null;
        this.myPreviousLocale = configuration.getLocale();
        this.myPreviousTheme = configuration.getTheme();
    }

    private static void clearDerivedData(@NotNull NlComponent component3) {
        if (component3 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(43);
        }
        NlComponentHelperKt.setBounds(component3, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component3, null);
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model2) {
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(44);
        }
        if (model2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(45);
        }
        model2.flattenComponents().forEach(LayoutlibSceneManager::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model2.flattenComponents().collect(Collectors.toMap(NlComponent::getTagDeprecated, Function.identity()));
        for (ViewInfo view : rootViews) {
            LayoutlibSceneManager.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            LayoutlibSceneManager.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void fixBounds(@NotNull NlComponent root2) {
        List<NlComponent> children;
        if (root2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(46);
        }
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root2) == -1 && NlComponentHelperKt.getH(root2) == -1) {
            computeBounds = true;
            NlComponent parent = root2.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root2, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root2.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                LayoutlibSceneManager.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root2), NlComponentHelperKt.getY(root2), NlComponentHelperKt.getW(root2), NlComponentHelperKt.getH(root2));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        if (view == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(47);
        }
        ViewInfo bounds = RenderService.getSafeBounds(view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component3 = snapshotToComponent.get(snapshot);
            if (component3 == null) {
                component3 = tagToComponent.get(snapshot.tag);
            }
            if (component3 != null && NlComponentHelperKt.getViewInfo(component3) == null) {
                NlComponentHelperKt.setViewInfo(component3, view);
                int left2 = parentX + bounds.getLeft();
                int top = parentY + bounds.getTop();
                int width = bounds.getRight() - bounds.getLeft();
                int height = bounds.getBottom() - bounds.getTop();
                NlComponentHelperKt.setBounds(component3, left2, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds.getLeft();
        parentY += bounds.getTop();
        for (ViewInfo child : view.getChildren()) {
            LayoutlibSceneManager.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    protected void fireRenderListeners() {
        this.myRenderListeners.forEach(RenderListener::onRenderCompleted);
    }

    public void addRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(48);
        }
        this.myRenderListeners.add(listener2);
    }

    public void removeRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(49);
        }
        this.myRenderListeners.remove(listener2);
    }

    public void forceReinflate() {
        this.myForceInflate.set(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTaskDisposerExecutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderSettingsProvider";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 8: 
            case 15: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 32: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskBuilder";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRender";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doRequestLayoutAndRender";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderingQueue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayout";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStyles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRenderTaskBuilder";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "renderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTargetProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRootViews";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setupRenderTaskBuilder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationChange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "clearDerivedData";
                break;
            }
            case 44: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fixBounds";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addRenderListener";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeRenderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ViewInfoTagSnapshotNode
    implements NlModel.TagSnapshotTreeNode {
        private final ViewInfo myViewInfo;

        public ViewInfoTagSnapshotNode(ViewInfo info) {
            this.myViewInfo = info;
        }

        @Override
        @Nullable
        public TagSnapshot getTagSnapshot() {
            Object result2 = this.myViewInfo.getCookie();
            return result2 instanceof TagSnapshot ? (TagSnapshot)result2 : null;
        }

        @Override
        @NotNull
        public List<NlModel.TagSnapshotTreeNode> getChildren() {
            List<NlModel.TagSnapshotTreeNode> list = this.myViewInfo.getChildren().stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList());
            if (list == null) {
                ViewInfoTagSnapshotNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ViewInfoTagSnapshotNode", "getChildren"));
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer2 = TimerUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            LayoutlibSceneManager.this.getDesignSurface().registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer2.setRepeats(false);
                timer2.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> LayoutlibSceneManager.this.getDesignSurface().unregisterIndicator((ProgressIndicator)this));
            }
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public boolean changed(int flags) {
            int newDpi;
            if ((flags & 2) != 0 && LayoutlibSceneManager.this.myDpi != (newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue())) {
                LayoutlibSceneManager.this.myDpi = newDpi;
                LayoutlibSceneManager.this.update();
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
            if (model2 == null) {
                SelectionChangeListener.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                SelectionChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.updateTargets();
            Scene scene = LayoutlibSceneManager.this.getScene();
            scene.needsRebuildList();
            scene.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$SelectionChangeListener";
            objectArray[2] = "selectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
            NlDesignSurface surface2 = LayoutlibSceneManager.this.getDesignSurface();
            LayoutlibSceneManager.this.requestRender(LayoutlibSceneManager.getTriggerFromChangeType(model2.getLastChangeType())).thenRunAsync(() -> LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(surface2.getSelectionModel(), (List<NlComponent>)surface2.getSelectionModel().getSelection()), (Executor)EdtExecutorService.getInstance());
        }

        @Override
        public void modelChanged(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), (List<NlComponent>)LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model2) {
            ResourceNotificationManager manager;
            ResourceNotificationManager.ResourceVersion version2;
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            if (!(version2 = (manager = ResourceNotificationManager.getInstance(LayoutlibSceneManager.this.getModel().getProject())).getCurrentVersion(LayoutlibSceneManager.this.getModel().getFacet(), (PsiFile)LayoutlibSceneManager.this.getModel().getFile(), LayoutlibSceneManager.this.getModel().getConfiguration())).equals(LayoutlibSceneManager.this.myRenderedVersion)) {
                LayoutlibSceneManager.this.requestModelUpdate();
                model2.updateTheme();
            } else {
                LayoutlibSceneManager.this.requestLayoutAndRender(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelDeactivated(@NotNull NlModel model2) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
            Object object = LayoutlibSceneManager.this.myRenderingQueueLock;
            synchronized (object) {
                if (LayoutlibSceneManager.this.myRenderingQueue != null) {
                    LayoutlibSceneManager.this.myRenderingQueue.cancelAllUpdates();
                }
            }
            LayoutlibSceneManager.this.disposeRenderTask();
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model2, boolean animate) {
            if (model2 == null) {
                ModelChangeListener.$$$reportNull$$$0(5);
            }
            LayoutlibSceneManager.this.requestLayoutAndRender(animate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelLiveUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

