/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.ConstrainedWidget;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;

public class Connection {
    public static final int PARENT_CONNECTION = -1;
    public static final int NO_CONNECTION = -2;
    private ConstrainedWidget myOriginWidget;
    private int myDestWidget;
    private ScoutWidget myDestRect;
    private Direction myOriginAnchor;
    private Direction myDestAnchor;
    private int myMargin;
    private double myDistanceX;
    private double myDistanceY;
    private double myCost;

    public Connection(int destWidget, Direction originAnchor, Direction destAnchor, ScoutWidget destRect) {
        this.myOriginAnchor = originAnchor;
        this.myDestRect = destRect;
        this.myDestWidget = destWidget;
        this.myDestAnchor = destAnchor;
        this.myMargin = 0;
    }

    public String toString() {
        if (this.myDestWidget == -1) {
            return "P";
        }
        if (this.myDestWidget == -2) {
            return "NULL";
        }
        Object result2 = Integer.toString(this.myDestWidget);
        result2 = (String)result2 + this.myDestAnchor.toString();
        return result2;
    }

    public int compareTo(Connection other) {
        int val = this.myCost < other.getCost() ? 1 : (this.myCost == other.getCost() ? 0 : -1);
        return val;
    }

    public void setMargin(int margin) {
        this.myMargin = margin;
    }

    public int getMargin() {
        return this.myMargin;
    }

    public int getAbsoluteMargin() {
        return Math.abs(this.myMargin);
    }

    public void setOriginWidget(ConstrainedWidget widget) {
        this.myOriginWidget = widget;
    }

    public Direction originDirection() {
        return this.myDestAnchor;
    }

    public ConstrainedWidget getOriginWidget() {
        return this.myOriginWidget;
    }

    public int destWidget() {
        return this.myDestWidget;
    }

    public Direction destDirection() {
        return this.myDestAnchor;
    }

    public void setDistanceX(double distanceX) {
        this.myDistanceX = distanceX;
    }

    public void setDistanceY(double distanceY) {
        this.myDistanceY = distanceY;
    }

    public double calculateCost() {
        this.myCost = this.myDistanceX * this.myDistanceX + this.myDistanceY * this.myDistanceY;
        this.myCost += (double)(this.myMargin * this.myMargin);
        if (this.isParentConnection()) {
            this.myCost += (double)(this.myMargin * this.myMargin);
        }
        return this.myCost;
    }

    public double getCost() {
        return this.myCost;
    }

    public boolean isConnected() {
        return this.myDestWidget != -2;
    }

    public boolean isParentConnection() {
        return this.myDestWidget == -1;
    }

    public String getDisplayString() {
        String res = String.format("%dx%dx%dx%d,%d", (int)this.myDestRect.getX(), (int)this.myDestRect.getY(), this.myDestRect.getWidthInt(), this.myDestRect.getHeightInt(), this.equivalentDirection(this.myDestAnchor));
        return res;
    }

    int equivalentDirection(Direction anchor) {
        switch (anchor) {
            case TOP: {
                return 2;
            }
            case BOTTOM: {
                return 3;
            }
            case RIGHT: {
                return 1;
            }
            case LEFT: {
                return 0;
            }
            case BASELINE: {
                return 0;
            }
        }
        return 0;
    }
}

