/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.utils.SdkUtils;
import com.android.utils.SparseIntArray;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeBadgeHandler {
    private static final int BADGE_MARGIN = 5;
    private static final int MESSAGE_WIDTH = 50;
    private static final int BADGE_ICON = 0;
    private static final int LOCK_ICON = 1;
    private static final String TOGGLE_LOCK_MESSAGE = "Toggle Tool Locking";
    private final BadgeMouseMotionListener myBadgeMouseMotionListener = new BadgeMouseMotionListener();
    private final JBLabel myHintLabel = new JBLabel();
    private final Point myHintLocation = new Point();
    @Nullable
    private LightweightHint myTooltipHint;
    @Nullable
    private TreePath myHoveredPath;
    private int myHoveredIcon = 0;
    private NlComponent myHoveredComponent;
    @Nullable
    private NlModel myNlModel;
    private int myBadgeX;
    private int myLockIconX;
    @Nullable
    private IssuePanel myIssuePanel;
    private final SparseIntArray myBadgeWidthForRows = new SparseIntArray();

    public void setNlModel(@Nullable NlModel nlModel) {
        this.myNlModel = nlModel;
    }

    public void setIssuePanel(@Nullable IssuePanel issuePanel) {
        this.myIssuePanel = issuePanel;
    }

    public void paintBadges(@NotNull Graphics2D g, @NotNull NlComponentTree tree) {
        if (g == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(1);
        }
        this.myBadgeX = Integer.MAX_VALUE;
        this.myBadgeWidthForRows.clear();
        if (this.myNlModel == null) {
            return;
        }
        LintAnnotationsModel lintAnnotationsModel = this.myNlModel.getLintAnnotationsModel();
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Icon firstIcon;
            TreePath path2 = tree.getPathForRow(i2);
            Object last = path2.getLastPathComponent();
            if (!(last instanceof NlComponent)) continue;
            NlComponent component3 = (NlComponent)last;
            Rectangle pathBounds = tree.getPathBounds(path2);
            if (pathBounds == null) continue;
            int y = pathBounds.y + pathBounds.height / 2;
            if (lintAnnotationsModel == null || (firstIcon = lintAnnotationsModel.getIssueIcon(component3, false, tree.isRowSelected(i2) && tree.hasFocus())) == null) continue;
            int x = tree.getWidth() - firstIcon.getIconWidth() - 5;
            int iy = y - firstIcon.getIconHeight() / 2;
            firstIcon.paintIcon((Component)((Object)tree), g, x, iy);
            this.myBadgeWidthForRows.put(i2, firstIcon.getIconWidth());
            this.myBadgeX = Math.min(x, this.myBadgeX);
        }
    }

    private void showErrorTooltip(@NotNull JTree tree, @NotNull TreePath path2, @NotNull String message2) {
        Window activeFrame;
        if (tree == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(3);
        }
        if (message2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(4);
        }
        if ((activeFrame = ComponentUtil.getWindow((Component)tree)) == null) {
            return;
        }
        Rectangle bounds = tree.getPathBounds(path2);
        if (bounds != null) {
            HintHint hint = this.createHint(tree);
            message2 = SdkUtils.wrap((String)message2, (int)50, null);
            message2 = HintUtil.prepareHintText((String)message2, (HintHint)hint);
            this.myHintLabel.setText(message2);
            this.myHintLocation.x = tree.getWidth() - 5;
            this.myHintLocation.y = bounds.y + bounds.height / 2;
            hint = this.ensureHintCanBeDisplayed(hint, message2, tree, activeFrame);
            if (hint == null) {
                return;
            }
            if (this.myTooltipHint == null) {
                this.myTooltipHint = new LightweightHint((JComponent)this.myHintLabel);
            }
            this.myTooltipHint.show((JComponent)tree, this.myHintLocation.x, this.myHintLocation.y, (JComponent)tree, hint);
        }
    }

    @Nullable
    private HintHint ensureHintCanBeDisplayed(@NotNull HintHint hint, @NotNull String message2, @NotNull Component component3, @NotNull Window activeFrame) {
        if (hint == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(5);
        }
        if (message2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(6);
        }
        if (component3 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(7);
        }
        if (activeFrame == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(8);
        }
        int labelWidth = this.myHintLabel.getFontMetrics(this.myHintLabel.getFont()).stringWidth(message2.substring(0, Math.min(message2.length(), 50)));
        int labelRight = component3.getLocationOnScreen().x + component3.getWidth() + labelWidth;
        int frameRight = activeFrame.getLocationOnScreen().x + activeFrame.getWidth();
        if (activeFrame.getWidth() < labelWidth) {
            return null;
        }
        if (frameRight < labelRight) {
            this.myHintLocation.x = 5;
            hint.setPreferredPosition(Balloon.Position.below);
        }
        return hint;
    }

    private HintHint createHint(@NotNull Component component3) {
        if (component3 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(9);
        }
        return new HintHint(component3, this.myHintLocation).setPreferredPosition(Balloon.Position.atRight).setBorderColor(JBColor.border()).setAwtTooltip(true).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true).setExplicitClose(true).setAnimationEnabled(true);
    }

    @Nullable
    private static String getIssueMessage(@NotNull TreePath path2) {
        Object last;
        if (path2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(10);
        }
        if (!((last = path2.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        NlComponent component3 = (NlComponent)last;
        LintAnnotationsModel lintAnnotationsModel = component3.getModel().getLintAnnotationsModel();
        if (lintAnnotationsModel != null) {
            return lintAnnotationsModel.getIssueMessage(component3, false);
        }
        return null;
    }

    @NotNull
    public MouseAdapter getBadgeMouseAdapter() {
        BadgeMouseMotionListener badgeMouseMotionListener = this.myBadgeMouseMotionListener;
        if (badgeMouseMotionListener == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(11);
        }
        return badgeMouseMotionListener;
    }

    public int getTotalBadgeWidth(int row) {
        return this.myBadgeWidthForRows.get(row, 0) + 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFrame";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBadgeMouseAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintBadges";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorTooltip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureHintCanBeDisplayed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BadgeMouseMotionListener
    extends MouseAdapter {
        private BadgeMouseMotionListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
                NlTreeBadgeHandler.this.myTooltipHint = null;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = null;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(0);
            }
            JTree tree = (JTree)event.getSource();
            this.handleShowBadge(event, tree);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.handleMouseClicked(event, (JTree)event.getSource());
        }

        private void handleMouseClicked(MouseEvent event, JTree tree) {
            Rectangle bounds;
            int limit = NlTreeBadgeHandler.this.myBadgeX;
            if (event.getX() < limit || NlTreeBadgeHandler.this.myIssuePanel == null) {
                return;
            }
            TreePath path2 = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path2 == null || (bounds = tree.getPathBounds(path2)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                return;
            }
            Object last = path2.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlComponent component3 = (NlComponent)last;
            if (event.getX() > NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myIssuePanel.showIssueForComponent(component3, true);
            }
        }

        private void toggleLocking(@NotNull NlComponent component3) {
            if (component3 == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(1);
            }
            boolean isLocked = SceneManager.isComponentLocked(component3);
            if (component3.getParent() == null) {
                return;
            }
            NlWriteCommandActionUtil.run(component3, "", () -> component3.setAttribute("http://schemas.android.com/tools", "locked", isLocked ? null : "true"));
        }

        private void handleShowBadge(@NotNull MouseEvent event, @NotNull JTree tree) {
            Rectangle bounds;
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(2);
            }
            if (tree == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(3);
            }
            if (event.getX() < NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            TreePath path2 = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path2 == null || (bounds = tree.getPathBounds(path2)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            Object last = path2.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = (NlComponent)last;
            boolean badgeIcon = true;
            if (NlTreeBadgeHandler.this.myHoveredPath == path2) {
                if (badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 0) {
                    return;
                }
                if (!badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 1) {
                    return;
                }
            }
            NlTreeBadgeHandler.this.myHoveredPath = path2;
            String message2 = null;
            if (badgeIcon) {
                message2 = NlTreeBadgeHandler.getIssueMessage(NlTreeBadgeHandler.this.myHoveredPath);
                NlTreeBadgeHandler.this.myHoveredIcon = 0;
            }
            if (message2 != null) {
                NlTreeBadgeHandler.this.showErrorTooltip(tree, NlTreeBadgeHandler.this.myHoveredPath, message2);
            }
        }

        private void hideTooltip() {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler$BadgeMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toggleLocking";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleShowBadge";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

