/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.SingleDirectionLayoutManagerKt;
import com.android.tools.idea.uibuilder.surface.SurfaceLayoutManager;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J0\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J@\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J0\u0010\u0017\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\u0018\u001a\u00020\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J.\u0010\u001a\u001a\u00020\u001b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/surface/SingleDirectionLayoutManager;", "Lcom/android/tools/idea/uibuilder/surface/SurfaceLayoutManager;", "horizontalPadding", "", "verticalPadding", "horizontalViewDelta", "verticalViewDelta", "(IIII)V", "previousHorizontalPadding", "previousVerticalPadding", "getPreferredSize", "Ljava/awt/Dimension;", "sceneViews", "", "Lcom/android/tools/idea/common/surface/SceneView;", "availableWidth", "availableHeight", "dimension", "getRenderableBoundsForInvisibleComponents", "Ljava/awt/Rectangle;", "targetSceneView", "surfaceRect", "retRect", "getRequiredSize", "isVertical", "", "layout", "", "keepPreviousPadding", "intellij.android.designer"})
public final class SingleDirectionLayoutManager
implements SurfaceLayoutManager {
    private int previousHorizontalPadding;
    private int previousVerticalPadding;
    private final int horizontalPadding;
    private final int verticalPadding;
    private final int horizontalViewDelta;
    private final int verticalViewDelta;

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull List<? extends SceneView> sceneViews, int availableWidth, int availableHeight, @Nullable Dimension dimension2) {
        Intrinsics.checkNotNullParameter(sceneViews, (String)"sceneViews");
        Dimension dimension3 = dimension2;
        if (dimension3 == null) {
            dimension3 = new Dimension();
        }
        Dimension dim = dimension3;
        boolean vertical = this.isVertical(sceneViews, availableWidth, availableHeight);
        int preferredWidth = 0;
        int preferredHeight = 0;
        if (vertical) {
            Integer n = SingleDirectionLayoutManagerKt.access$maxOf(sceneViews, getPreferredSize.1.INSTANCE);
            preferredWidth = n != null ? n : 0;
            preferredHeight = SingleDirectionLayoutManagerKt.access$sumOf(sceneViews, (Function1)new Function1<SceneView, Integer>(this){
                final /* synthetic */ SingleDirectionLayoutManager this$0;

                public final int invoke(@NotNull SceneView $this$sumOf) {
                    Intrinsics.checkNotNullParameter((Object)$this$sumOf, (String)"$receiver");
                    return $this$sumOf.getNameLabelHeight() + $this$sumOf.getPreferredSize().height + SingleDirectionLayoutManager.access$getVerticalViewDelta$p(this.this$0);
                }
                {
                    this.this$0 = singleDirectionLayoutManager;
                    super(1);
                }
            }) - this.verticalViewDelta;
        } else {
            preferredWidth = SingleDirectionLayoutManagerKt.access$sumOf(sceneViews, (Function1)new Function1<SceneView, Integer>(this){
                final /* synthetic */ SingleDirectionLayoutManager this$0;

                public final int invoke(@NotNull SceneView $this$sumOf) {
                    Intrinsics.checkNotNullParameter((Object)$this$sumOf, (String)"$receiver");
                    return $this$sumOf.getPreferredSize().width + SingleDirectionLayoutManager.access$getHorizontalViewDelta$p(this.this$0);
                }
                {
                    this.this$0 = singleDirectionLayoutManager;
                    super(1);
                }
            }) - this.horizontalViewDelta;
            Integer n = SingleDirectionLayoutManagerKt.access$maxOf(sceneViews, getPreferredSize.4.INSTANCE);
            preferredHeight = n != null ? n : 0;
        }
        int n = 0;
        int n2 = 0;
        int width = Math.max(n, preferredWidth);
        n2 = 0;
        boolean bl = false;
        int height = Math.max(n2, preferredHeight);
        dim.setSize(width, height);
        return dim;
    }

    @Override
    @NotNull
    public Dimension getRequiredSize(@NotNull List<? extends SceneView> sceneViews, int availableWidth, int availableHeight, @Nullable Dimension dimension2) {
        Intrinsics.checkNotNullParameter(sceneViews, (String)"sceneViews");
        Dimension dimension3 = dimension2;
        if (dimension3 == null) {
            dimension3 = new Dimension();
        }
        Dimension dim = dimension3;
        int requiredWidth = 0;
        int requiredHeight = 0;
        if (this.isVertical(sceneViews, availableWidth, availableHeight)) {
            Integer n = SingleDirectionLayoutManagerKt.access$maxOf(sceneViews, getRequiredSize.1.INSTANCE);
            requiredWidth = n != null ? n : 0;
            requiredHeight = SingleDirectionLayoutManagerKt.access$sumOf(sceneViews, (Function1)new Function1<SceneView, Integer>(this){
                final /* synthetic */ SingleDirectionLayoutManager this$0;

                public final int invoke(@NotNull SceneView $this$sumOf) {
                    Intrinsics.checkNotNullParameter((Object)$this$sumOf, (String)"$receiver");
                    return $this$sumOf.getNameLabelHeight() + $this$sumOf.getSize().height + SingleDirectionLayoutManager.access$getVerticalViewDelta$p(this.this$0);
                }
                {
                    this.this$0 = singleDirectionLayoutManager;
                    super(1);
                }
            }) - this.verticalViewDelta;
        } else {
            requiredWidth = SingleDirectionLayoutManagerKt.access$sumOf(sceneViews, (Function1)new Function1<SceneView, Integer>(this){
                final /* synthetic */ SingleDirectionLayoutManager this$0;

                public final int invoke(@NotNull SceneView $this$sumOf) {
                    Intrinsics.checkNotNullParameter((Object)$this$sumOf, (String)"$receiver");
                    return $this$sumOf.getSize().width + SingleDirectionLayoutManager.access$getHorizontalViewDelta$p(this.this$0);
                }
                {
                    this.this$0 = singleDirectionLayoutManager;
                    super(1);
                }
            }) - this.horizontalViewDelta;
            Integer n = SingleDirectionLayoutManagerKt.access$maxOf(sceneViews, getRequiredSize.4.INSTANCE);
            requiredHeight = n != null ? n : 0;
        }
        int n = 0;
        int n2 = 0;
        int width = Math.max(n, requiredWidth);
        n2 = 0;
        boolean bl = false;
        int height = Math.max(n2, requiredHeight);
        dim.setSize(width, height);
        return dim;
    }

    private final boolean isVertical(List<? extends SceneView> sceneViews, int availableWidth, int availableHeight) {
        if (sceneViews.isEmpty()) {
            return false;
        }
        SceneView primary = sceneViews.get(0);
        return availableHeight > 3 * availableWidth / 2 || primary.getSize().width > primary.getSize().height;
    }

    @Override
    public void layout(@NotNull List<? extends SceneView> sceneViews, int availableWidth, int availableHeight, boolean keepPreviousPadding) {
        Intrinsics.checkNotNullParameter(sceneViews, (String)"sceneViews");
        if (sceneViews.isEmpty()) {
            return;
        }
        boolean vertical = this.isVertical(sceneViews, availableWidth, availableHeight);
        int startX = 0;
        int startY = 0;
        if (keepPreviousPadding) {
            startX = this.previousHorizontalPadding;
            startY = this.previousVerticalPadding;
        } else {
            Dimension requiredSize = this.getRequiredSize(sceneViews, availableWidth, availableHeight, null);
            int n = requiredSize.width;
            int requiredHeight = requiredSize.height;
            int n2 = (availableWidth - n) / 2;
            int n22 = this.horizontalPadding;
            boolean bl = false;
            startX = Math.max(n2, n22);
            n2 = (availableHeight - requiredHeight) / 2;
            n22 = this.verticalPadding;
            bl = false;
            startY = Math.max(n2, n22);
            this.previousHorizontalPadding = startX;
            this.previousVerticalPadding = startY;
        }
        if (vertical) {
            int nextY = startY;
            for (SceneView sceneView : sceneViews) {
                sceneView.setLocation(startX, nextY += sceneView.getNameLabelHeight());
                nextY += sceneView.getSize().height + this.verticalViewDelta;
            }
        } else {
            int nextX = startX;
            for (SceneView sceneView : sceneViews) {
                sceneView.setLocation(nextX, startY);
                nextX += sceneView.getSize().width + this.horizontalViewDelta;
            }
        }
    }

    @Override
    @NotNull
    public Rectangle getRenderableBoundsForInvisibleComponents(@NotNull SceneView targetSceneView, @NotNull List<? extends SceneView> sceneViews, int availableWidth, int availableHeight, @NotNull Rectangle surfaceRect, @Nullable Rectangle retRect) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)targetSceneView, (String)"targetSceneView");
        Intrinsics.checkNotNullParameter(sceneViews, (String)"sceneViews");
        Intrinsics.checkNotNullParameter((Object)surfaceRect, (String)"surfaceRect");
        Rectangle rectangle2 = retRect;
        if (rectangle2 == null) {
            rectangle2 = rectangle = new Rectangle();
        }
        if (sceneViews.size() == 1) {
            rectangle.setBounds(surfaceRect);
            return rectangle;
        }
        int index = sceneViews.indexOf(targetSceneView);
        if (index == -1) {
            rectangle.setBounds(0, 0, 0, 0);
            return rectangle;
        }
        int leftBound = surfaceRect.x;
        int topBound = surfaceRect.y;
        int rightBound = surfaceRect.x + surfaceRect.width;
        int bottomBound = surfaceRect.y + surfaceRect.height;
        int lastSceneViewIndex = sceneViews.size() - 1;
        if (this.isVertical(sceneViews, availableWidth, availableHeight)) {
            boolean bl;
            int n;
            rectangle.x = leftBound;
            rectangle.width = rightBound - leftBound;
            if (index == 0) {
                rectangle.y = topBound;
            } else {
                SceneView previousSceneView = sceneViews.get(index - 1);
                int previousBottom = previousSceneView.getY() + previousSceneView.getSize().height;
                n = (previousBottom + targetSceneView.getY() - targetSceneView.getNameLabelHeight()) / 2;
                bl = false;
                rectangle.y = Math.max(topBound, n);
            }
            if (index == lastSceneViewIndex) {
                rectangle.height = bottomBound - rectangle.y;
            } else {
                SceneView nextSceneView = sceneViews.get(index + 1);
                int bottom2 = targetSceneView.getY() + targetSceneView.getSize().height;
                n = (bottom2 + nextSceneView.getY() - nextSceneView.getNameLabelHeight()) / 2;
                bl = false;
                rectangle.height = Math.min(bottomBound, n) - rectangle.y;
            }
        } else {
            boolean bl;
            int n;
            rectangle.y = topBound;
            rectangle.height = bottomBound - topBound;
            if (index == 0) {
                rectangle.x = leftBound;
            } else {
                SceneView previousSceneView = sceneViews.get(index - 1);
                int previousRight = previousSceneView.getX() + previousSceneView.getSize().width;
                n = (previousRight + targetSceneView.getX()) / 2;
                bl = false;
                rectangle.x = Math.max(leftBound, n);
            }
            if (index == lastSceneViewIndex) {
                rectangle.width = rightBound - rectangle.x;
            } else {
                SceneView nextSceneView = sceneViews.get(index + 1);
                int right2 = targetSceneView.getX() + targetSceneView.getSize().width;
                n = (right2 + nextSceneView.getX()) / 2;
                bl = false;
                rectangle.width = Math.min(rightBound, n) - rectangle.x;
            }
        }
        return rectangle;
    }

    public SingleDirectionLayoutManager(int horizontalPadding, int verticalPadding, int horizontalViewDelta, int verticalViewDelta) {
        this.horizontalPadding = horizontalPadding;
        this.verticalPadding = verticalPadding;
        this.horizontalViewDelta = horizontalViewDelta;
        this.verticalViewDelta = verticalViewDelta;
    }

    public static final /* synthetic */ int access$getVerticalViewDelta$p(SingleDirectionLayoutManager $this) {
        return $this.verticalViewDelta;
    }

    public static final /* synthetic */ int access$getHorizontalViewDelta$p(SingleDirectionLayoutManager $this) {
        return $this.horizontalViewDelta;
    }
}

