/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.welcome.wizard.JdkSetupStep;
import com.android.tools.idea.welcome.wizard.JdkSetupStepKt;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/welcome/wizard/JdkSetupStep;", "Lcom/android/tools/idea/wizard/model/ModelWizardStep$WithoutModel;", "()V", "invalidPathMessage", "Lcom/android/tools/idea/observable/core/StringValueProperty;", "isValidJdkPath", "Lcom/android/tools/idea/observable/core/BoolValueProperty;", "jdkLocation", "Ljava/io/File;", "getJdkLocation", "()Ljava/io/File;", "jdkLocationComboBox", "Lcom/intellij/ui/ComboboxWithBrowseButton;", "jdkPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validatorPanel", "Lcom/android/tools/adtui/validation/ValidatorPanel;", "canGoForward", "Lcom/android/tools/idea/observable/core/ObservableBool;", "getComponent", "getPreferredFocusComponent", "onEntering", "", "onProceeding", "setJdkLocationComboBox", "path", "validateJdkPath", "file", "toSystemDependentName", "", "intellij.android.core"})
public final class JdkSetupStep
extends ModelWizardStep.WithoutModel {
    private final ComboboxWithBrowseButton jdkLocationComboBox = new ComboboxWithBrowseButton();
    private final DialogPanel jdkPanel;
    private final ValidatorPanel validatorPanel;
    private final StringValueProperty invalidPathMessage;
    private final BoolValueProperty isValidJdkPath;

    private final File getJdkLocation() {
        File file = IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.jdkLocationComboBox);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getLocationFromComboBoxW\u2026tton(jdkLocationComboBox)");
        return file;
    }

    @Override
    protected void onEntering() {
        this.validatorPanel.registerMessageSource((ObservableValue)this.invalidPathMessage);
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.isValidJdkPath;
    }

    @Override
    protected void onProceeding() {
        File path2 = FilePaths.toSystemDependentPath((String)this.getJdkLocation().getPath());
        ApplicationManager.getApplication().runWriteAction(new Runnable(path2){
            final /* synthetic */ File $path;

            public final void run() {
                IdeSdks ideSdks = IdeSdks.getInstance();
                File file = this.$path;
                Intrinsics.checkNotNull((Object)file);
                ideSdks.setJdkPath(file);
            }
            {
                this.$path = file;
            }
        });
    }

    @NotNull
    protected DialogPanel getPreferredFocusComponent() {
        return this.jdkPanel;
    }

    @NotNull
    protected ValidatorPanel getComponent() {
        return this.validatorPanel;
    }

    private final File validateJdkPath(File file) {
        File possiblePath = IdeSdks.getInstance().validateJdkPath(file);
        if (possiblePath != null) {
            this.setJdkLocationComboBox(possiblePath);
            this.isValidJdkPath.set(true);
            return possiblePath;
        }
        this.isValidJdkPath.set(false);
        return null;
    }

    private final void setJdkLocationComboBox(File path2) {
        JComboBox jComboBox = this.jdkLocationComboBox.getComboBox();
        Intrinsics.checkNotNullExpressionValue((Object)jComboBox, (String)"jdkLocationComboBox.comboBox");
        File file = path2;
        jComboBox.setSelectedItem(file != null ? this.toSystemDependentName(file) : null);
    }

    private final String toSystemDependentName(File $this$toSystemDependentName) {
        String string = FileUtilRt.toSystemDependentName((String)$this$toSystemDependentName.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.toSystemDependentName(path)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public JdkSetupStep() {
        super("Select default JDK location");
        void $this$panel;
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        JdkSetupStep jdkSetupStep = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)jdkPanel.1.1.INSTANCE, (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)jdkPanel.1.2.INSTANCE, (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkSetupStep this$0;
            {
                this.this$0 = jdkSetupStep;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)JdkSetupStep.access$getJdkLocationComboBox$p(this.this$0)), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        Unit unit = Unit.INSTANCE;
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        jdkSetupStep.jdkPanel = panel$iv;
        this.validatorPanel = new ValidatorPanel((Disposable)this, (JComponent)StudioWizardStepPanel.wrappedWithVScroll((JPanel)this.jdkPanel));
        this.invalidPathMessage = new StringValueProperty();
        this.isValidJdkPath = new BoolValueProperty(false);
        FileChooserDescriptor descriptor2 = JdkSetupStepKt.createSingleFolderDescriptor((Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ JdkSetupStep this$0;

            public final void invoke(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (JdkSetupStep.access$validateJdkPath(this.this$0, file) == null) {
                    throw (Throwable)new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
                }
                JdkSetupStep.access$setJdkLocationComboBox(this.this$0, file);
            }
            {
                this.this$0 = jdkSetupStep;
                super(1);
            }
        }));
        this.jdkLocationComboBox.addBrowseFolderListener(null, descriptor2);
        final JComboBox comboBox = this.jdkLocationComboBox.getComboBox();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.validateJdkPath(this.getJdkLocation());
            }
        });
        Function2<File, String, Unit> $fun$addJdkIfValid$2 = new Function2<File, String, Unit>(){

            public final void invoke(@Nullable File path2, @NotNull String label) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                if (path2 == null) {
                    return;
                }
                File file = this.validateJdkPath(path2);
                if (file == null) {
                    return;
                }
                File validatedPath = file;
                comboBox.addItem(new IdeSdksConfigurable.LabelAndFileForLocation(label, validatedPath));
            }
        };
        IdeSdks ideSdks = IdeSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideSdks, (String)"IdeSdks.getInstance()");
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        $fun$addJdkIfValid$2.invoke(embeddedPath, "Embedded JDK");
        String javaHomePath = IdeSdks.getJdkFromJavaHome();
        if (javaHomePath != null) {
            $fun$addJdkIfValid$2.invoke(new File(javaHomePath), "JAVA_HOME");
        }
        JComboBox jComboBox = comboBox;
        Intrinsics.checkNotNullExpressionValue((Object)jComboBox, (String)"comboBox");
        jComboBox.setEditable(true);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent event) {
                ItemEvent itemEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"event");
                final Object selectedItem = itemEvent.getItem();
                if (event.getStateChange() == 1 && selectedItem instanceof IdeSdksConfigurable.LabelAndFileForLocation) {
                    WelcomeUiUtils.invokeLater$default(null, (Function0)new Function0<Unit>(){

                        public final void invoke() {
                            this.setJdkLocationComboBox(((IdeSdksConfigurable.LabelAndFileForLocation)selectedItem).getFile());
                        }
                    }, 1, null);
                }
            }
        });
        this.setJdkLocationComboBox(embeddedPath);
    }

    public static final /* synthetic */ ComboboxWithBrowseButton access$getJdkLocationComboBox$p(JdkSetupStep $this) {
        return $this.jdkLocationComboBox;
    }
}

