/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.WizardStepHeaderPanel;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStep
extends ScopedDataBinder
implements Step {
    private static final Logger LOG = Logger.getInstance(DynamicWizardStep.class);
    static final String BLANK = " ";
    protected DynamicWizardPath myPath;
    private JPanel myRootPane;
    private boolean myUpdateInProgress;
    private boolean myIsValid;
    private boolean myInitialized;
    protected WizardStepHeaderPanel myHeader;
    @Nullable
    MergingUpdateQueue myUpdateQueue;

    public DynamicWizardStep() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    public final void attachToPath(@NotNull DynamicWizardPath path2) {
        if (path2 == null) {
            DynamicWizardStep.$$$reportNull$$$0(0);
        }
        this.myPath = path2;
        Map<String, Object> myCurrentValues = this.myState.flatten();
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, this.myPath.getState(), this);
        for (String keyName : myCurrentValues.keySet()) {
            this.myState.put(this.myState.createKey(keyName, Object.class), myCurrentValues.get(keyName));
        }
        this.myUpdateQueue = path2.getUpdateQueue();
    }

    public abstract void init();

    @Nullable
    public final Project getProject() {
        return this.myPath != null ? this.myPath.getProject() : null;
    }

    @Nullable
    protected final Module getModule() {
        return this.myPath != null ? this.myPath.getModule() : null;
    }

    @Nullable
    protected final DynamicWizard getWizard() {
        if (this.myPath != null) {
            return this.myPath.getWizard();
        }
        return null;
    }

    @Nullable
    private final Disposable getDisposable() {
        DynamicWizard wizard = this.getWizard();
        return wizard != null ? wizard.getDisposable() : null;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Deprecated
    public final void _init() {
        this.onEnterStep();
    }

    @Deprecated
    public final void _commit(boolean finishChosen) throws CommitStepException {
        this.commitStep();
    }

    public void onEnterStep() {
        if (!this.myInitialized) {
            this.init();
            this.myInitialized = true;
        }
        this.invokeUpdate(null);
    }

    public boolean commitStep() {
        return true;
    }

    public boolean isStepVisible() {
        return true;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.queue((Update)new StepUpdate(changedKey));
        } else {
            this.performUpdate(changedKey);
        }
    }

    private <T> void performUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (!this.myInitialized) {
            return;
        }
        super.invokeUpdate(changedKey);
        this.update();
        if (this.myPath != null) {
            this.myPath.updateButtons();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.updateModelFromUI();
            this.deriveValues(this.myState.getRecentUpdates());
            this.myIsValid = this.validate();
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void updateModelFromUI() {
    }

    public void deriveValues(Set<? extends ScopedStateStore.Key> modified) {
    }

    public boolean validate() {
        return true;
    }

    public boolean canGoNext() {
        return this.myIsValid;
    }

    public boolean canGoPrevious() {
        return true;
    }

    public final void setErrorHtml(@Nullable String errorMessage) {
        JLabel label;
        if (StringUtil.isEmpty((String)errorMessage)) {
            errorMessage = BLANK;
        }
        if ((label = this.getMessageLabel()) != null) {
            errorMessage = this.toHtml(errorMessage);
            label.setText(errorMessage);
        } else {
            LOG.debug("Message was displayed on a step without error label", (Throwable)new Exception());
        }
    }

    public String toString() {
        return this.getStepName();
    }

    @NotNull
    public final JComponent getComponent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRootPane == null) {
            this.myRootPane = new JPanel(new BorderLayout());
            this.myHeader = WizardStepHeaderPanel.create(this.getDisposable(), this.getHeaderColor(), this.getWizardIcon(), this.getStepIcon(), this.getStepTitle(), this.getStepDescription());
            this.myRootPane.add((Component)this.myHeader, "North");
            this.myRootPane.add(this.createStepBody(), "Center");
        }
        JPanel jPanel = this.myRootPane;
        if (jPanel == null) {
            DynamicWizardStep.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    protected JBColor getHeaderColor() {
        JBColor jBColor = WizardConstants.ANDROID_NPW_HEADER_COLOR;
        if (jBColor == null) {
            DynamicWizardStep.$$$reportNull$$$0(2);
        }
        return jBColor;
    }

    @Nullable
    protected Icon getStepIcon() {
        return null;
    }

    @NotNull
    protected abstract Component createStepBody();

    @Nullable
    protected Icon getWizardIcon() {
        DynamicWizard wizard = this.getWizard();
        return wizard == null ? null : wizard.getIcon();
    }

    @Nullable
    public abstract JLabel getMessageLabel();

    @NotNull
    public abstract String getStepName();

    @NotNull
    protected abstract String getStepTitle();

    @Nullable
    protected abstract String getStepDescription();

    @Nullable
    protected final String toHtml(@Nullable String text) {
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            text = String.format("<html>%1$s</html>", text.trim());
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/dynamic/DynamicWizardStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/dynamic/DynamicWizardStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachToPath";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StepUpdate
    extends Update {
        private final ScopedStateStore.Key<?> myChangedKey;

        public StepUpdate(ScopedStateStore.Key<?> changedKey) {
            super((Object)DynamicWizardStep.this);
            this.myChangedKey = changedKey;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{DynamicWizardStep.this, this.myChangedKey};
            if (objectArray == null) {
                StepUpdate.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public void run() {
            DynamicWizardStep.this.performUpdate(this.myChangedKey);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/dynamic/DynamicWizardStep$StepUpdate", "getEqualityObjects"));
        }
    }
}

