/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.model.InspectorPanelModel;
import com.android.tools.property.panel.impl.ui.CollapsibleLabelPanel;
import com.android.tools.property.panel.impl.ui.ExpandableLabel;
import com.android.tools.property.panel.impl.ui.InspectorLayoutManager;
import com.android.tools.property.panel.impl.ui.Placement;
import com.android.tools.property.panel.impl.ui.PropertyTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;", "Lcom/android/tools/adtui/common/AdtSecondaryPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/adtui/model/stdui/ValueChangedListener;", "model", "Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "parentDisposable", "(Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;Lcom/intellij/openapi/Disposable;)V", "expandableLabelHandler", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl$ExpandableLabelHandler;", "getModel", "()Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "addLineElement", "", "label", "Lcom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel;", "component", "Ljavax/swing/JComponent;", "addNotify", "dispose", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "valueChanged", "ExpandableLabelHandler", "intellij.android.layout-ui"})
public final class InspectorPanelImpl
extends AdtSecondaryPanel
implements Disposable,
ValueChangedListener {
    private final ExpandableLabelHandler expandableLabelHandler;
    @NotNull
    private final InspectorPanelModel model;

    public void addNotify() {
        super.addNotify();
        this.expandableLabelHandler.install(this);
    }

    public final void addLineElement(@NotNull JComponent component3) {
        Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
        this.add(component3, (Object)Placement.LINE);
    }

    public final void addLineElement(@NotNull CollapsibleLabelPanel label, @NotNull JComponent component3) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
        this.add(label, (Object)Placement.LEFT);
        this.add(component3, (Object)Placement.RIGHT);
    }

    public void dispose() {
        this.model.removeValueChangedListener(this);
    }

    public void valueChanged() {
        this.revalidate();
        this.repaint();
    }

    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)((Object)this));
        if (!this.contains(point)) {
            return null;
        }
        Component component3 = this.getComponentAt(point.x, point.y);
        if (!(component3 instanceof CollapsibleLabelPanel)) {
            component3 = null;
        }
        CollapsibleLabelPanel collapsibleLabelPanel = (CollapsibleLabelPanel)component3;
        if (collapsibleLabelPanel == null) {
            return null;
        }
        CollapsibleLabelPanel component4 = collapsibleLabelPanel;
        PropertyEditorModel propertyEditorModel = component4.getModel().getEditorModel();
        return PropertyTooltip.Companion.setToolTip((JComponent)((Object)this), event, propertyEditorModel != null ? propertyEditorModel.getProperty() : null, false, "");
    }

    @NotNull
    public final InspectorPanelModel getModel() {
        return this.model;
    }

    public InspectorPanelImpl(@NotNull InspectorPanelModel model2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super((LayoutManager)new InspectorLayoutManager());
        this.model = model2;
        this.expandableLabelHandler = new ExpandableLabelHandler(this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setBorder((Border)JBUI.Borders.empty());
        this.model.addValueChangedListener(this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0017j\u0004\u0018\u0001`\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001eH\u0014J\b\u0010#\u001a\u00020\rH\u0014J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl$ExpandableLabelHandler;", "Lcom/intellij/ui/AbstractExpandableItemsHandler;", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "Ljavax/swing/JPanel;", "component", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;", "(Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;)V", "expandedLabel", "mousePreprocessor", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl$ExpandableLabelHandler$MousePreprocessor;", "renderer", "Ljavax/swing/JLabel;", "doFillBackground", "", "height", "", "width", "g", "Ljava/awt/Graphics2D;", "getCellKeyForPoint", "point", "Ljava/awt/Point;", "getCellRendererAndBounds", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Component;", "Ljava/awt/Rectangle;", "Lcom/android/tools/property/panel/impl/ui/ComponentBounds;", "key", "getVisibleRect", "hideExpansion", "", "install", "parent", "Lcom/intellij/openapi/Disposable;", "isPaintBorder", "onFocusLost", "overlayBounds", "MousePreprocessor", "intellij.android.layout-ui"})
    private static final class ExpandableLabelHandler
    extends AbstractExpandableItemsHandler<ExpandableLabel, JPanel> {
        private final MousePreprocessor mousePreprocessor;
        private final JLabel renderer;
        private ExpandableLabel expandedLabel;

        public final void install(@NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"IdeGlassPaneUtil.find(myComponent)");
            IdeGlassPane glassPane = ideGlassPane;
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)this.mousePreprocessor, parent);
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull ExpandableLabel key) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
                if (Intrinsics.areEqual((Object)((Object)this.expandedLabel), (Object)((Object)key)) ^ true) {
                    this.hideExpansion();
                }
                if (key.getPreferredSize().width <= key.getWidth()) {
                    return null;
                }
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isActive()) {
                    return null;
                }
                this.renderer.setText(key.getText());
                this.renderer.setIcon(key.getIcon());
                this.renderer.setFont(key.getFont());
                this.renderer.setForeground(key.getForeground());
                this.renderer.setBackground(key.getBackground());
                this.expandedLabel = key;
                Object object = this.expandedLabel;
                if (object == null || (object = object.getPanel()) == null || (object = ((CollapsibleLabelPanel)object).getModel()) == null) break block3;
                ((CollapsibleLabelModel)object).setShowEllipses(false);
            }
            return Pair.create((Object)this.renderer, (Object)this.overlayBounds(key));
        }

        protected void onFocusLost() {
            super.onFocusLost();
            this.hideExpansion();
        }

        protected void doFillBackground(int height, int width, @NotNull Graphics2D g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Object object = this.expandedLabel;
            if (object == null || (object = object.getPanel()) == null) {
                return;
            }
            ExpandableLabel panel2 = object;
            g.setColor(((Component)((Object)panel2)).getBackground());
            g.fillRect(0, 0, width, height);
        }

        protected boolean isPaintBorder() {
            return false;
        }

        @NotNull
        protected Rectangle getVisibleRect(@NotNull ExpandableLabel key) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            Rectangle rectangle = SwingUtilities.convertRectangle((Component)((Object)key), key.getVisibleRect(), this.myComponent);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"SwingUtilities.convertRe\u2026visibleRect, myComponent)");
            return rectangle;
        }

        @Nullable
        protected ExpandableLabel getCellKeyForPoint(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Component component3 = ((JPanel)this.myComponent).getComponentAt(point.x, point.y);
            Component component4 = component3;
            if (!(component4 instanceof CollapsibleLabelPanel)) {
                component4 = null;
            }
            CollapsibleLabelPanel collapsibleLabelPanel = (CollapsibleLabelPanel)component4;
            return collapsibleLabelPanel != null ? collapsibleLabelPanel.getLabel() : null;
        }

        private final boolean hideExpansion() {
            boolean wasExpanded = this.expandedLabel != null;
            Object object = this.expandedLabel;
            if (object != null && (object = object.getPanel()) != null && (object = ((CollapsibleLabelPanel)object).getModel()) != null) {
                ((CollapsibleLabelModel)object).setShowEllipses(true);
            }
            this.expandedLabel = null;
            return wasExpanded;
        }

        private final Rectangle overlayBounds(ExpandableLabel key) {
            Dimension preferredSize = key.getPreferredSize();
            Rectangle bounds = new Rectangle(SwingUtilities.convertPoint(key.getPanel(), key.getLocation(), key.getPanel().getParent()), preferredSize);
            JComponent jComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
            LayoutManager layoutManager = ((JPanel)jComponent).getLayout();
            if (!(layoutManager instanceof InspectorLayoutManager)) {
                layoutManager = null;
            }
            InspectorLayoutManager inspectorLayoutManager = (InspectorLayoutManager)layoutManager;
            bounds.height = inspectorLayoutManager != null ? inspectorLayoutManager.getRowHeight((Component)((Object)key)) : preferredSize.height;
            bounds.width += JBUI.scale((int)6);
            return bounds;
        }

        public ExpandableLabelHandler(@NotNull InspectorPanelImpl component3) {
            Intrinsics.checkNotNullParameter((Object)((Object)component3), (String)"component");
            super((JComponent)((Object)component3));
            this.mousePreprocessor = new MousePreprocessor();
            this.renderer = new JLabel();
        }

        public static final /* synthetic */ JPanel access$getMyComponent$p(ExpandableLabelHandler $this) {
            return (JPanel)$this.myComponent;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl$ExpandableLabelHandler$MousePreprocessor;", "Ljava/awt/event/MouseMotionAdapter;", "(Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl$ExpandableLabelHandler;)V", "mouseMoved", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.android.layout-ui"})
        private final class MousePreprocessor
        extends MouseMotionAdapter {
            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Point pointInMyComponent = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), ExpandableLabelHandler.access$getMyComponent$p(ExpandableLabelHandler.this));
                if (ExpandableLabelHandler.access$getMyComponent$p(ExpandableLabelHandler.this).contains(pointInMyComponent)) {
                    Component component3 = ExpandableLabelHandler.access$getMyComponent$p(ExpandableLabelHandler.this).getComponentAt(pointInMyComponent.x, pointInMyComponent.y);
                    if (component3 instanceof CollapsibleLabelPanel) {
                        Point pointInLabelPanel = SwingUtilities.convertPoint(ExpandableLabelHandler.access$getMyComponent$p(ExpandableLabelHandler.this), pointInMyComponent, component3);
                        Component label = component3.getComponentAt(pointInLabelPanel.x, pointInLabelPanel.y);
                        if (Intrinsics.areEqual((Object)((Object)((CollapsibleLabelPanel)component3).getLabel()), (Object)label)) {
                            ExpandableLabelHandler.this.handleSelectionChange((Object)((CollapsibleLabelPanel)component3).getLabel(), true);
                        }
                    }
                } else if (ExpandableLabelHandler.this.hideExpansion()) {
                    MouseEvent fakeExited = new MouseEvent(event.getComponent(), 505, event.getWhen(), 0, -1, -1, 0, false);
                    ExpandableLabelHandler.access$getMyComponent$p(ExpandableLabelHandler.this).dispatchEvent(fakeExited);
                }
            }
        }
    }
}

