/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.tools.adtui.LightCalloutPopup;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ColorResourcePicker;
import com.android.tools.idea.ui.resourcechooser.HorizontalTabbedPanelBuilder;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilder;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialColorPaletteProvider;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.internal.MaterialGraphicalColorPipetteProvider;
import com.android.utils.HashCodes;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Color;
import java.awt.MouseInfo;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;

public class AndroidAnnotatorUtil {
    static final int MAX_ICON_SIZE = 5000;
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;

    @Nullable
    public static VirtualFile resolveDrawableFile(@NotNull ResourceValue resourceValue2, @NotNull ResourceResolver resourceResolver2, @NotNull AndroidFacet facet2) {
        Project project;
        VirtualFile file;
        if (resourceValue2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(0);
        }
        if (resourceResolver2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(1);
        }
        if (facet2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(2);
        }
        if ((file = ResourceHelper.resolveDrawable((RenderResources)resourceResolver2, resourceValue2, project = facet2.getModule().getProject())) != null && file.getPath().endsWith(".xml")) {
            file = AndroidAnnotatorUtil.pickBitmapFromXml(file, resourceResolver2, project, facet2, resourceValue2);
        }
        return AndroidAnnotatorUtil.pickBestBitmap(file);
    }

    @Nullable
    private static VirtualFile pickBitmapFromXml(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver2, @NotNull Project project, @NotNull AndroidFacet facet2, @NotNull ResourceValue resourceValue2) {
        if (file == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(3);
        }
        if (resourceResolver2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(5);
        }
        if (facet2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(6);
        }
        if (resourceValue2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(7);
        }
        try {
            String source;
            String tagName;
            XmlPullParser parser = FileResourceReader.createXmlPullParser(file);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet2);
                    List<ResourceItem> items2 = resourceRepository.getResources(resourceValue2.getNamespace(), resourceValue2.getResourceType(), resourceValue2.getName());
                    for (ResourceItem item : items2) {
                        Density density;
                        FolderConfiguration configuration = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return ResourceHelper.getSourceAsVirtualFile(item);
                    }
                    return file;
                }
                case "bitmap": 
                case "nine-patch": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                case "layer-list": 
                case "level-list": 
                case "selector": 
                case "shape": 
                case "transition": {
                    return file;
                }
                default: {
                    return null;
                }
            }
            if (source == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver2.findResValue(source, resourceValue2.isFramework());
            return resValue == null ? null : ResourceHelper.resolveDrawable((RenderResources)resourceResolver2, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickBestBitmap(@Nullable VirtualFile bitmap) {
        if (bitmap != null && bitmap.exists()) {
            VirtualFile smallest = AndroidAnnotatorUtil.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.getLength();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(@NotNull VirtualFile bitmap) {
        VirtualFile parentFile;
        if (bitmap == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(8);
        }
        if ((parentFile = bitmap.getParent()) == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i2 = densities.length;
            while (--i2 >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i2];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    public static Configuration pickConfiguration(@NotNull PsiFile file, @NotNull AndroidFacet facet2) {
        VirtualFile layout2;
        VirtualFile virtualFile;
        if (file == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(9);
        }
        if (facet2 == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(10);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        String parentName = parent.getName();
        if (!parentName.startsWith("layout")) {
            layout2 = ResourceHelper.pickAnyLayoutFile(facet2);
            if (layout2 == null) {
                return null;
            }
        } else {
            layout2 = virtualFile;
        }
        return ConfigurationManager.getOrCreateInstance(facet2.getModule()).getConfiguration(layout2);
    }

    @NotNull
    public static FileType getFileType(@NotNull PsiElement element) {
        if (element == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(11);
        }
        FileType fileType = (FileType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                return file.getFileType();
            }
            return UnknownFileType.INSTANCE;
        });
        if (fileType == null) {
            AndroidAnnotatorUtil.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceValue";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitmap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidAnnotatorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidAnnotatorUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveDrawableFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pickBitmapFromXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSmallestDpiVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pickConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;
        private final ResourceReference myResourceReference;
        private final Consumer<String> mySetColorTask;
        private final boolean myIncludeClickAction;
        @Nullable
        private final Configuration myConfiguration;

        public ColorRenderer(@NotNull PsiElement element, @Nullable Color color, @Nullable ResourceReference resourceReference, boolean includeClickAction, @Nullable Configuration configuration) {
            if (element == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myColor = color;
            this.myResourceReference = resourceReference;
            this.myIncludeClickAction = includeClickAction;
            this.mySetColorTask = ColorRenderer.createSetColorTask(this.myElement);
            this.myConfiguration = configuration;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            JBScalableIcon jBScalableIcon = color == null ? JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)8)) : JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(8, color));
            if (jBScalableIcon == null) {
                ColorRenderer.$$$reportNull$$$0(1);
            }
            return jBScalableIcon;
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (!this.myIncludeClickAction) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Editor editor2;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editor2 = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                        this.openColorPicker(this.getCurrentColor());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/AndroidAnnotatorUtil$ColorRenderer$1", "actionPerformed"));
                }
            };
        }

        private void openColorPicker(@Nullable Color currentColor) {
            JComponent popupContent;
            LightCalloutPopup dialog2 = new LightCalloutPopup();
            JComponent colorPicker2 = new ColorPickerBuilder().setOriginalColor(currentColor).addSaturationBrightnessComponent().addColorAdjustPanel(new MaterialGraphicalColorPipetteProvider()).addColorValuePanel().withFocus().addSeparator().addCustomComponent(MaterialColorPaletteProvider.INSTANCE).addColorPickerListener((color, source) -> this.setColorToAttribute(color)).focusWhenDisplay(true).setFocusCycleRoot(true).build();
            if (((Boolean)StudioFlags.NELE_RESOURCE_POPUP_PICKER.get()).booleanValue() && this.myConfiguration != null) {
                ColorResourcePicker resourcePicker = new ColorResourcePicker(this.myConfiguration, this.myResourceReference);
                resourcePicker.addColorResourcePickerListener(resource -> this.setColorStringAttribute(resource.getResourceUrl().toString()));
                popupContent = new HorizontalTabbedPanelBuilder().addTab("Resources", resourcePicker).addTab("Custom", colorPicker2).setDefaultPage(this.myResourceReference != null ? 0 : 1).build();
            } else {
                popupContent = colorPicker2;
            }
            dialog2.show(popupContent, null, MouseInfo.getPointerInfo().getLocation());
        }

        private void setColorToAttribute(@NotNull Color color) {
            if (color == null) {
                ColorRenderer.$$$reportNull$$$0(2);
            }
            this.setColorStringAttribute(ResourceHelper.colorToString(color));
        }

        private void setColorStringAttribute(@NotNull String colorString) {
            if (colorString == null) {
                ColorRenderer.$$$reportNull$$$0(3);
            }
            Project project = this.myElement.getProject();
            TransactionGuard.submitTransaction((Disposable)project, () -> WriteCommandAction.runWriteCommandAction((Project)project, (String)AndroidAnnotatorUtil.SET_COLOR_COMMAND_NAME, null, () -> this.mySetColorTask.consume((Object)colorString), (PsiFile[])new PsiFile[0]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (!Objects.equals(this.myColor, that.myColor)) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            return HashCodes.mix((int)this.myElement.hashCode(), (int)Objects.hashCode(this.myColor));
        }

        @VisibleForTesting
        public static Consumer<String> createSetColorTask(@NotNull PsiElement element) {
            XmlAttribute xmlAttribute;
            if (element == null) {
                ColorRenderer.$$$reportNull$$$0(4);
            }
            if (element instanceof XmlTag) {
                XmlTagValue xmlTagValue = ((XmlTag)element).getValue();
                return colorString -> xmlTagValue.setText(colorString);
            }
            if (element instanceof XmlAttributeValue && (xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null) {
                return colorString -> xmlAttribute.setValue(colorString);
            }
            return EmptyConsumer.getInstance();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidAnnotatorUtil$ColorRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidAnnotatorUtil$ColorRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setColorToAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setColorStringAttribute";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createSetColorTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

