/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidProblemFileHighlightingFilter
implements Condition<VirtualFile> {
    private final Project myProject;

    public AndroidProblemFileHighlightingFilter(Project project) {
        this.myProject = project;
    }

    public boolean value(VirtualFile file) {
        if (file.getFileType() != StdFileTypes.XML) {
            return false;
        }
        if ("AndroidManifest.xml".equals(file.getName())) {
            Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject);
            return module != null && AndroidFacet.getInstance((Module)module) != null;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return false;
        }
        if ((parent = parent.getParent()) == null) {
            return false;
        }
        return AndroidResourceUtil.isLocalResourceDirectory(parent, this.myProject);
    }
}

