/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.AndroidUsagesTargetProvider;
import org.jetbrains.android.ResourceFieldElementWrapper;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(0);
        }
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return false;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor2 == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof SchemaPrefix) {
            return false;
        }
        if (AndroidUsagesTargetProvider.findValueResourceTagInContext(editor2, file, true) != null) {
            return true;
        }
        if (AndroidRenameHandler.getResourceReferenceTarget(editor2) != null) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        return AndroidRenameHandler.isPackageAttributeInManifest(project, element);
    }

    @Nullable
    private static PsiElement getResourceReferenceTarget(@NotNull Editor editor2) {
        PsiReference reference2;
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(1);
        }
        if (!((reference2 = TargetElementUtil.findReference((Editor)editor2, (int)editor2.getCaretModel().getOffset())) instanceof AndroidResourceReference)) {
            return null;
        }
        Collection elements = TargetElementUtil.getInstance().getTargetCandidates(reference2);
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList<PsiElement> elementList = new ArrayList<PsiElement>(elements);
        elementList.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        return (PsiElement)elementList.get(0);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(3);
        }
        if (file == null || editor2 == null) {
            return;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor2, file, true);
        if (tag != null) {
            ResourceUrl url = AndroidRenameHandler.findResourceReferenceUnderCaret(editor2, file);
            if (url != null && !url.isFramework()) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor2, dataContext, file, url);
            } else {
                AndroidRenameHandler.performValueResourceRenaming(project, editor2, dataContext, tag);
            }
        } else {
            PsiElement element = AndroidRenameHandler.getResourceReferenceTarget(editor2);
            if (element != null) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor2, dataContext, element);
            } else {
                AndroidRenameHandler.performApplicationPackageRenaming(project, editor2, dataContext);
            }
        }
    }

    private static void performValueResourceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull XmlTag tag) {
        XmlAttribute nameAttribute;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            AndroidRenameHandler.$$$reportNull$$$0(7);
        }
        if ((nameAttribute = tag.getAttribute("name")) == null) {
            return;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, new ValueResourceElementWrapper(attributeValue), null, editor2));
    }

    private static void performResourceReferenceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull PsiFile file, @NotNull ResourceUrl url) {
        PsiField[] resourceFields;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(10);
        }
        if (file == null) {
            AndroidRenameHandler.$$$reportNull$$$0(11);
        }
        if (url == null) {
            AndroidRenameHandler.$$$reportNull$$$0(12);
        }
        assert (!url.isFramework());
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file);
        if (facet2 != null && (resourceFields = AndroidResourceUtil.findResourceFields(facet2, url.type.getName(), url.name, false)).length == 1) {
            Object element = resourceFields[0];
            if (element instanceof AndroidLightField) {
                element = new ResourceFieldElementWrapper((AndroidLightField)((Object)element));
            }
            RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, (PsiElement)element, null, editor2));
        }
    }

    private static void performResourceReferenceRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext dataContext, @NotNull PsiElement element) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(14);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(15);
        }
        if (element == null) {
            AndroidRenameHandler.$$$reportNull$$$0(16);
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new ResourceRenameDialog(project, element, null, editor2));
    }

    @Nullable
    private static ResourceUrl findResourceReferenceUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(17);
        }
        if (file == null) {
            AndroidRenameHandler.$$$reportNull$$$0(18);
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file);
        if (facet2 == null) {
            return null;
        }
        if (!AndroidResourceUtil.isInResourceSubdirectory(file, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (element instanceof XmlToken) {
            XmlAttribute attribute;
            XmlTag tag;
            IElementType tokenType = ((XmlToken)element).getTokenType();
            if (tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                XmlText text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class);
                if (text != null) {
                    return ResourceUrl.parse((String)text.getText().trim());
                }
            } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && tag.getLocalName().equals("item") && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null && attribute.getLocalName().equals("name")) {
                return ResourceUrl.parseAttrReference((String)element.getText());
            }
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Editor editor2;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(19);
        }
        if (elements == null) {
            AndroidRenameHandler.$$$reportNull$$$0(20);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(21);
        }
        if ((editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        this.invoke(project, editor2, file, dataContext);
    }

    public String getActionTitle() {
        return "Rename Android value resource";
    }

    static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(22);
        }
        if (element == null) {
            return false;
        }
        PsiFile psiFile2 = element.getContainingFile();
        if (!(psiFile2 instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)psiFile2);
        if (facet2 == null) {
            return false;
        }
        VirtualFile vFile = psiFile2.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getPrimaryManifestFile(facet2))) {
            return false;
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    private static void performApplicationPackageRenaming(@NotNull Project project, @NotNull Editor editor2, @NotNull DataContext context) {
        PsiElement element;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            AndroidRenameHandler.$$$reportNull$$$0(24);
        }
        if (context == null) {
            AndroidRenameHandler.$$$reportNull$$$0(25);
        }
        if (!((element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) instanceof XmlAttributeValue)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)context, (RenameDialog)new RenameDialog(project, element, null, editor2){

            @NotNull
            protected String getLabelText() {
                String string = "Rename Android application package of module '" + module.getName() + "' to:";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void canRun() throws ConfigurationException {
                String name = this.getNewName();
                if (name.isEmpty()) {
                    throw new ConfigurationException(AndroidBundle.message("specify.package.name.error", new Object[0]));
                }
                if (!AndroidUtils.isValidAndroidPackageName(name)) {
                    throw new ConfigurationException(AndroidBundle.message("not.valid.package.name.error", name));
                }
                if (!AndroidBuildCommonUtils.contains2Identifiers((String)name)) {
                    throw new ConfigurationException(AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]));
                }
                super.canRun();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidRenameHandler$1", "getLabelText"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceReferenceTarget";
                break;
            }
            case 2: 
            case 3: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "performValueResourceRenaming";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "performResourceReferenceRenaming";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceReferenceUnderCaret";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isPackageAttributeInManifest";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "performApplicationPackageRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ResourceRenameDialog
    extends RenameDialog {
        ResourceRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2) {
            if (project == null) {
                ResourceRenameDialog.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                ResourceRenameDialog.$$$reportNull$$$0(1);
            }
            super(project, psiElement, nameSuggestionContext, editor2);
        }

        protected void canRun() throws ConfigurationException {
            String name = this.getNewName();
            String errorText = ValueResourceNameValidator.getErrorText((String)name, null);
            if (errorText != null) {
                throw new ConfigurationException(errorText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/AndroidRenameHandler$ResourceRenameDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

