/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidResourceExternalAnnotatorBase
extends ExternalAnnotator<FileAnnotationInfo, Map<PsiElement, GutterIconRenderer>> {
    private static final Logger LOG = Logger.getInstance(AndroidResourceExternalAnnotatorBase.class);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor2, boolean hasErrors) {
        if (file == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(1);
        }
        return this.collectInformation(file, editor2);
    }

    @Nullable
    protected abstract FileAnnotationInfo collectInformation(@NotNull PsiFile var1, @NotNull Editor var2);

    @Nullable
    public final FileAnnotationInfo collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    public Map<PsiElement, GutterIconRenderer> doAnnotate(@NotNull FileAnnotationInfo fileAnnotationsInfo) {
        if (fileAnnotationsInfo == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(3);
        }
        AndroidFacet facet2 = fileAnnotationsInfo.getFacet();
        Editor editor2 = fileAnnotationsInfo.getEditor();
        long timestamp = fileAnnotationsInfo.getTimestamp();
        Document document = editor2.getDocument();
        HashMap<PsiElement, GutterIconRenderer> rendererMap = new HashMap<PsiElement, GutterIconRenderer>();
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(fileAnnotationsInfo.getFile(), facet2);
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        for (FileAnnotationInfo.AnnotatableElement element : fileAnnotationsInfo.getElements()) {
            GutterIconRenderer gutterIconRenderer;
            ProgressManager.checkCanceled();
            if (editor2.isDisposed() || document.getModificationStamp() > timestamp) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Rendering icon for %s in %s.", element.getResource(), fileAnnotationsInfo.getFile()));
            }
            if (element.getResource() != null) {
                gutterIconRenderer = AndroidResourceExternalAnnotatorBase.getResourceGutterIconRender(element.getResource(), element.getPsiElement(), resolver, facet2, configuration);
            } else {
                assert (element.getColor() != null);
                Color color = element.getColor();
                gutterIconRenderer = new AndroidAnnotatorUtil.ColorRenderer(element.getPsiElement(), color, null, true, configuration);
            }
            if (gutterIconRenderer == null) continue;
            rendererMap.put(element.getPsiElement(), gutterIconRenderer);
        }
        return rendererMap;
    }

    @Nullable
    private static GutterIconRenderer getResourceGutterIconRender(@NotNull ResourceReference reference2, @NotNull PsiElement element, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        ResourceType type;
        if (reference2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(6);
        }
        if (facet2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(8);
        }
        if ((type = reference2.getResourceType()) == ResourceType.COLOR) {
            return AndroidResourceExternalAnnotatorBase.getColorGutterIconRenderer(resolver, reference2, facet2, element, configuration);
        }
        assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
        return AndroidResourceExternalAnnotatorBase.getDrawableGutterIconRenderer(resolver, reference2, facet2, configuration);
    }

    @Nullable
    private static GutterIconRenderer getDrawableGutterIconRenderer(@NotNull ResourceResolver resourceResolver2, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        ResourceValue drawable;
        if (resourceResolver2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(9);
        }
        if (reference2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(10);
        }
        if (facet2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(12);
        }
        if ((drawable = resourceResolver2.getResolvedResource(reference2)) == null) {
            return null;
        }
        VirtualFile bitmap = AndroidAnnotatorUtil.resolveDrawableFile(drawable, resourceResolver2, facet2);
        if ((bitmap = AndroidAnnotatorUtil.pickBestBitmap(bitmap)) == null) {
            return null;
        }
        GutterIconCache.getInstance().getIcon(bitmap, (RenderResources)resourceResolver2, facet2);
        return new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, facet2, bitmap, configuration);
    }

    @Nullable
    private static GutterIconRenderer getColorGutterIconRenderer(@NotNull ResourceResolver resourceResolver2, @NotNull ResourceReference reference2, @NotNull AndroidFacet facet2, @NotNull PsiElement element, @NotNull Configuration configuration) {
        ResourceValue colorValue;
        Color color;
        if (resourceResolver2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(13);
        }
        if (reference2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(14);
        }
        if (facet2 == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(15);
        }
        if (element == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(16);
        }
        if (configuration == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(17);
        }
        if ((color = ResourceHelper.resolveColor((RenderResources)resourceResolver2, colorValue = resourceResolver2.getResolvedResource(reference2), facet2.getModule().getProject())) == null) {
            return null;
        }
        boolean isClickable = AndroidAnnotatorUtil.getFileType(element) == XmlFileType.INSTANCE;
        return new AndroidAnnotatorUtil.ColorRenderer(element, color, reference2, isClickable, configuration);
    }

    public void apply(@NotNull PsiFile file, @NotNull Map<PsiElement, GutterIconRenderer> iconRendererMap, @NotNull AnnotationHolder holder) {
        if (file == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(18);
        }
        if (iconRendererMap == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(19);
        }
        if (holder == null) {
            AndroidResourceExternalAnnotatorBase.$$$reportNull$$$0(20);
        }
        iconRendererMap.forEach((k, v) -> {
            if (k.isValid()) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(k).gutterIconRenderer(v).create();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotationsInfo";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconRendererMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidResourceExternalAnnotatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAnnotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceGutterIconRender";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getDrawableGutterIconRenderer";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorGutterIconRenderer";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class FileAnnotationInfo {
        @NotNull
        private final AndroidFacet myFacet;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        private final long myTimestamp;
        @NotNull
        private final List<AnnotatableElement> myElements;

        public FileAnnotationInfo(@NotNull AndroidFacet facet2, @NotNull PsiFile file, @NotNull Editor editor2) {
            if (facet2 == null) {
                FileAnnotationInfo.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileAnnotationInfo.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                FileAnnotationInfo.$$$reportNull$$$0(2);
            }
            this.myFacet = facet2;
            this.myFile = file;
            this.myEditor = editor2;
            this.myTimestamp = this.myEditor.getDocument().getModificationStamp();
            this.myElements = new ArrayList<AnnotatableElement>();
        }

        @NotNull
        public AndroidFacet getFacet() {
            AndroidFacet androidFacet = this.myFacet;
            if (androidFacet == null) {
                FileAnnotationInfo.$$$reportNull$$$0(3);
            }
            return androidFacet;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile2 = this.myFile;
            if (psiFile2 == null) {
                FileAnnotationInfo.$$$reportNull$$$0(4);
            }
            return psiFile2;
        }

        @NotNull
        public List<AnnotatableElement> getElements() {
            List<AnnotatableElement> list = this.myElements;
            if (list == null) {
                FileAnnotationInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor2 = this.myEditor;
            if (editor2 == null) {
                FileAnnotationInfo.$$$reportNull$$$0(6);
            }
            return editor2;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidResourceExternalAnnotatorBase$FileAnnotationInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidResourceExternalAnnotatorBase$FileAnnotationInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFacet";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class AnnotatableElement {
            @Nullable
            private final ResourceReference myReference;
            @NotNull
            private final PsiElement myPsiElement;
            @Nullable
            private final Color myColor;

            public AnnotatableElement(@NotNull ResourceReference reference2, @NotNull PsiElement element) {
                if (reference2 == null) {
                    AnnotatableElement.$$$reportNull$$$0(0);
                }
                if (element == null) {
                    AnnotatableElement.$$$reportNull$$$0(1);
                }
                this.myReference = reference2;
                this.myPsiElement = element;
                this.myColor = null;
            }

            AnnotatableElement(@NotNull Color color, @NotNull PsiElement element) {
                if (color == null) {
                    AnnotatableElement.$$$reportNull$$$0(2);
                }
                if (element == null) {
                    AnnotatableElement.$$$reportNull$$$0(3);
                }
                this.myReference = null;
                this.myPsiElement = element;
                this.myColor = color;
            }

            @Nullable
            public ResourceReference getResource() {
                return this.myReference;
            }

            @NotNull
            public PsiElement getPsiElement() {
                PsiElement psiElement = this.myPsiElement;
                if (psiElement == null) {
                    AnnotatableElement.$$$reportNull$$$0(4);
                }
                return psiElement;
            }

            @Nullable
            public Color getColor() {
                return this.myColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "color";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/android/AndroidResourceExternalAnnotatorBase$FileAnnotationInfo$AnnotatableElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/android/AndroidResourceExternalAnnotatorBase$FileAnnotationInfo$AnnotatableElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPsiElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

