/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.ValueXmlHelper;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.TextFieldWithColorPickerKt;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.CreateXmlResourceSubdirPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourcePanelImpl
implements CreateXmlResourcePanel,
CreateXmlResourceSubdirPanel.Parent {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JPanel myValueFieldContainer;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel myFileNameLabel;
    @Nullable
    private final Module myModule;
    @NotNull
    private final ResourceType myResourceType;
    @NotNull
    private final ResourceFolderType myFolderType;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private JTextField myValueField;
    private CreateXmlResourceSubdirPanel mySubdirPanel;
    private IdeResourceNameValidator myResourceNameValidator;

    public CreateXmlResourcePanelImpl(@NotNull Module module, @NotNull ResourceType resourceType, @NotNull ResourceFolderType folderType, @Nullable String resourceName, @Nullable String resourceValue2, boolean chooseName, boolean chooseValue, boolean chooseFilename, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile, @NotNull Function<Module, IdeResourceNameValidator> nameValidatorFactory) {
        String defaultFileName;
        if (module == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(1);
        }
        if (folderType == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(2);
        }
        if (nameValidatorFactory == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(3);
        }
        this.$$$setupUI$$$();
        this.setChangeNameVisible(false);
        this.setChangeValueVisible(false);
        this.setChangeFileNameVisible(chooseFilename);
        this.myFolderType = folderType;
        if (chooseName) {
            this.setChangeNameVisible(true);
            resourceName = ResourceHelper.prependResourcePrefix(module, resourceName, folderType);
        }
        if (!StringUtil.isEmpty((String)resourceName)) {
            this.myNameField.setText(resourceName);
        }
        if (resourceType == ResourceType.COLOR) {
            Color defaultColor = ResourceHelper.parseColor(resourceValue2);
            this.myValueFieldContainer.removeAll();
            this.myValueFieldContainer.add(TextFieldWithColorPickerKt.wrapWithColorPickerIcon(this.myValueField, defaultColor));
        }
        if (chooseValue) {
            this.myValueField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CreateXmlResourcePanelImpl.this.myValueField.setFont(FontUtil.getFontAbleToDisplay((String)CreateXmlResourcePanelImpl.this.myValueField.getText(), (Font)CreateXmlResourcePanelImpl.this.myValueField.getFont()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/actions/CreateXmlResourcePanelImpl$1", "textChanged"));
                }
            });
            this.setChangeValueVisible(true);
            if (!StringUtil.isEmpty((String)resourceValue2)) {
                String value2 = resourceType == ResourceType.STRING ? ValueXmlHelper.escapeResourceString((String)resourceValue2, (boolean)false) : resourceValue2;
                this.myValueField.setText(value2);
            }
        }
        this.myResourceType = resourceType;
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (!modulesSet.isEmpty());
        if (modulesSet.size() == 1) {
            this.myModule = module;
            this.setChangeModuleVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules(modulesSet);
            this.myModuleCombo.setSelectedModule(module);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, modulesSet.size() == 1 ? AndroidFacet.getInstance((Module)((Module)modulesSet.iterator().next())) : null);
        if (defaultFile == null && (defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesPanel);
        this.mySubdirPanel = new CreateXmlResourceSubdirPanel(module.getProject(), folderType, this.myDirectoriesPanel, this);
        this.myResourceNameValidator = nameValidatorFactory.apply(this.getModule());
        this.myModuleCombo.addActionListener(e -> {
            this.mySubdirPanel.updateDirectories(true, this.getResourceDirectory());
            this.myResourceNameValidator = (IdeResourceNameValidator)nameValidatorFactory.apply(this.getModule());
        });
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module.getProject());
        }
    }

    private void createUIComponents() {
        this.myValueField = new JTextField();
        this.myValueFieldContainer = new JPanel();
        this.myValueFieldContainer.setFocusable(false);
        this.myValueFieldContainer.setLayout(new BoxLayout(this.myValueFieldContainer, 1));
        this.myValueFieldContainer.setUI(null);
        this.myValueFieldContainer.setBorder((Border)JBUI.Borders.empty());
        this.myValueFieldContainer.setOpaque(false);
        this.myValueFieldContainer.add(this.myValueField);
    }

    @Override
    public void resetToDefault() {
        String defaultFileName;
        if (this.myModule == null) {
            this.myModuleCombo.setSelectedModule(this.getRootModule());
        }
        if ((defaultFileName = AndroidResourceUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.mySubdirPanel.resetToDefault();
    }

    @NotNull
    private Module getRootModule() {
        assert (this.myModule == null);
        ComboBoxModel model2 = this.myModuleCombo.getModel();
        Module root2 = null;
        int moduleDependencyCount = -1;
        for (int c = 0; c < model2.getSize(); ++c) {
            Module otherModule = (Module)model2.getElementAt(c);
            int otherModuleDependencyCount = AndroidUtils.getAllAndroidDependencies(otherModule, true).size();
            if (otherModuleDependencyCount <= moduleDependencyCount) continue;
            moduleDependencyCount = otherModuleDependencyCount;
            root2 = otherModule;
        }
        assert (root2 != null);
        Module module = root2;
        if (module == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(4);
        }
        return module;
    }

    @Override
    public void resetFromFile(@NotNull VirtualFile file, @NotNull Project project) {
        Module moduleForFile;
        if (file == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(6);
        }
        if ((moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        this.mySubdirPanel.resetFromFile(parent);
        this.myFileNameCombo.getEditor().setItem(file.getName());
        this.myPanel.repaint();
    }

    @Override
    public ValidationInfo doValidate() {
        String resourceName = this.getResourceName();
        String resourceValue2 = this.getValue();
        Module selectedModule = this.getModule();
        VirtualFile resourceDir = this.getResourceDirectory();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (this.myNameField.isVisible() && resourceName.isEmpty()) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (this.myNameField.isVisible() && !AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.isEmpty()) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.isEmpty()) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesPanel);
        }
        if (resourceName.equals(ResourceHelper.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule.getProject(), resourceDir, resourceName, resourceValue2, this.myResourceType, directoryNames, fileName);
    }

    @Override
    @NotNull
    public IdeResourceNameValidator getResourceNameValidator() {
        IdeResourceNameValidator ideResourceNameValidator = this.myResourceNameValidator;
        if (ideResourceNameValidator == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(7);
        }
        return ideResourceNameValidator;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        String name = this.myNameField.getText();
        if (name.isEmpty() || this.myValueField.isVisible() && !this.myValueField.getText().isEmpty() || name.equals(ResourceHelper.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    @Override
    @NotNull
    public String getResourceName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myResourceType;
        if (resourceType == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(9);
        }
        return resourceType;
    }

    @Override
    @NotNull
    public List<String> getDirNames() {
        List<String> list = this.mySubdirPanel.getDirNames();
        if (list == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = ((String)this.myFileNameCombo.getEditor().getItem()).trim();
        if (string == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getValue() {
        String value2 = this.myValueField.getText();
        String string = this.myResourceType == ResourceType.STRING ? ValueXmlHelper.unescapeResourceString((String)value2, (boolean)false, (boolean)false) : value2;
        if (string == null) {
            CreateXmlResourcePanelImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private IdeaSourceProvider getSourceProvider() {
        return CreateResourceDialogUtils.getSourceProvider(this.mySourceSetCombo);
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Override
    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        PsiDirectory resDirectory = CreateResourceDialogUtils.getResourceDirectory(this.getSourceProvider(), module);
        return resDirectory != null ? resDirectory.getVirtualFile() : null;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    private void setChangeFileNameVisible(boolean isVisible) {
        this.myFileNameLabel.setVisible(isVisible);
        this.myFileNameCombo.setVisible(isVisible);
    }

    private void setChangeValueVisible(boolean isVisible) {
        this.myValueFieldContainer.setVisible(isVisible);
        this.myValueLabel.setVisible(isVisible);
    }

    private void setChangeNameVisible(boolean isVisible) {
        this.myNameField.setVisible(isVisible);
        this.myNameLabel.setVisible(isVisible);
    }

    private void setChangeModuleVisible(boolean isVisible) {
        this.myModuleLabel.setVisible(isVisible);
        this.myModuleCombo.setVisible(isVisible);
    }

    @Override
    public void updateFilesCombo(List<VirtualFile> directories) {
        Object oldItem = this.myFileNameCombo.getEditor().getItem();
        HashSet<String> fileNameSet = new HashSet<String>();
        for (VirtualFile dir : directories) {
            for (VirtualFile file : dir.getChildren()) {
                fileNameSet.add(file.getName());
            }
        }
        ArrayList fileNames = new ArrayList(fileNameSet);
        Collections.sort(fileNames);
        this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
        this.myFileNameCombo.getEditor().setItem(oldItem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValidatorFactory";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/CreateXmlResourcePanelImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/CreateXmlResourcePanelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNameValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        ModulesComboBox modulesComboBox;
        JTextField jTextField;
        JBLabel jBLabel6;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        this.myNameLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resource name:");
        jBLabel6.setDisplayedMnemonic('N');
        jBLabel6.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Module:");
        jBLabel5.setDisplayedMnemonic('M');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("File name:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoriesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoriesLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Create the resource in directories:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource value:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameCombo = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = this.myValueFieldContainer;
        ((Component)jPanel3).setEnabled(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel6.setLabelFor(jTextField);
        jBLabel5.setLabelFor((Component)modulesComboBox);
        jBLabel4.setLabelFor(jComboBox2);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

