/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class AndroidBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    private static boolean isProGuardUsed(@NotNull Project project, @NotNull CompileScope scope) {
        if (project == null) {
            AndroidBuildTargetScopeProvider.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AndroidBuildTargetScopeProvider.$$$reportNull$$$0(1);
        }
        for (Module module : scope.getAffectedModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null || !facet2.getProperties().RUN_PROGUARD) continue;
            return true;
        }
        String proguardCfgPathsStr = (String)scope.getUserData(AndroidCompileUtil.PROGUARD_CFG_PATHS_KEY);
        if (proguardCfgPathsStr != null && !proguardCfgPathsStr.isEmpty()) {
            return true;
        }
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)scope, (boolean)false);
        for (Artifact artifact : artifacts) {
            AndroidApplicationArtifactProperties p;
            ArtifactProperties properties;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) || !(p = (AndroidApplicationArtifactProperties)properties).isRunProGuard()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull Project project, boolean forceBuild) {
        if (baseScope == null) {
            AndroidBuildTargetScopeProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AndroidBuildTargetScopeProvider.$$$reportNull$$$0(3);
        }
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID) || AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list = Collections.emptyList();
            if (list == null) {
                AndroidBuildTargetScopeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<String> appTargetIds = new ArrayList<String>();
        ArrayList<String> libTargetIds = new ArrayList<String>();
        ArrayList<String> allTargetIds = new ArrayList<String>();
        ArrayList<String> manifestMergingTargetIds = new ArrayList<String>();
        boolean fullBuild = AndroidCompileUtil.isFullBuild(baseScope);
        for (Module module : baseScope.getAffectedModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null) continue;
            allTargetIds.add(module.getName());
            if (!fullBuild) continue;
            if (((AndroidFacetConfiguration)facet2.getConfiguration()).canBeDependency()) {
                libTargetIds.add(module.getName());
                continue;
            }
            if (facet2.getProperties().ENABLE_MANIFEST_MERGING) {
                manifestMergingTargetIds.add(module.getName());
            }
            appTargetIds.add(module.getName());
        }
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> result2 = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        result2.add(CmdlineProtoUtil.createTargetsScope((String)"android-manifest-merging", manifestMergingTargetIds, (boolean)forceBuild));
        if (fullBuild && !AndroidBuildTargetScopeProvider.isProGuardUsed(project, baseScope)) {
            result2.add(CmdlineProtoUtil.createTargetsScope((String)"android-pre-dex", Collections.singletonList("only"), (boolean)forceBuild));
        }
        result2.addAll(Arrays.asList(CmdlineProtoUtil.createTargetsScope((String)"android-aar-deps", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-dex", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-resource-caching", allTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-resource-packaging", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-packaging", appTargetIds, (boolean)forceBuild), CmdlineProtoUtil.createTargetsScope((String)"android-library-packaging", libTargetIds, (boolean)forceBuild)));
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> arrayList = result2;
        if (arrayList == null) {
            AndroidBuildTargetScopeProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidBuildTargetScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidBuildTargetScopeProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTargetScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isProGuardUsed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTargetScopes";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

