/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProGuardConfigFilesPanel
extends JPanel {
    private final JBList myList;
    private CollectionListModel<String> myModel = new CollectionListModel((Object[])new String[0]);

    public ProGuardConfigFilesPanel() {
        super(new BorderLayout());
        this.myList = new JBList(this.myModel);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                String path2 = ProGuardConfigFilesPanel.this.chooseFile();
                if (path2 != null) {
                    ProGuardConfigFilesPanel.this.myModel.add((Object)path2);
                }
            }
        });
        JPanel tablePanel = decorator.setPreferredSize(new Dimension(-1, JBUI.scale((int)120))).createPanel();
        tablePanel.setMinimumSize(new Dimension(-1, JBUI.scale((int)120)));
        this.add((Component)tablePanel, "Center");
        JBLabel label = new JBLabel("Config file paths:");
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)5, (int)0));
        this.add((Component)label, "North");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component3 : this.getComponents()) {
            UIUtil.setEnabled((Component)component3, (boolean)enabled, (boolean)true);
        }
    }

    private String chooseFile() {
        AndroidFacet facet2 = this.getFacet();
        if (facet2 == null) {
            return null;
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        VirtualFile contentRoot = AndroidRootUtil.getMainContentRoot(facet2);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)this, (Project)facet2.getModule().getProject(), (VirtualFile)contentRoot);
        return file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : null;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> paths = this.getOsPaths();
        if (paths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ProGuardConfigFilesPanel.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(paths.size());
        for (String path2 : paths) {
            String url = VfsUtilCore.pathToUrl((String)path2);
            String sdkHome = this.getCanonicalSdkHome();
            if (sdkHome != null) {
                url = StringUtil.replace((String)url, (String)sdkHome, (String)"%MODULE_SDK_HOME%");
            }
            result2.add(url);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ProGuardConfigFilesPanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getOsPaths() {
        List list = this.myModel.getItems();
        if (list == null) {
            ProGuardConfigFilesPanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            ProGuardConfigFilesPanel.$$$reportNull$$$0(3);
        }
        this.setOsPaths(AndroidUtils.urlsToOsPaths(urls, this.getCanonicalSdkHome()));
    }

    public void setOsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            ProGuardConfigFilesPanel.$$$reportNull$$$0(4);
        }
        this.myModel = new CollectionListModel(paths);
        this.myList.setModel(this.myModel);
    }

    @Nullable
    private String getCanonicalSdkHome() {
        AndroidFacet facet2 = this.getFacet();
        if (facet2 == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)facet2.getModule()).getSdk();
        if (sdk == null) {
            return null;
        }
        String homePath = sdk.getHomePath();
        return homePath != null ? FileUtil.toCanonicalPath((String)homePath) : null;
    }

    @Nullable
    protected abstract AndroidFacet getFacet();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/ProGuardConfigFilesPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOsPaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/ProGuardConfigFilesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setOsPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

