/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public final class FileDescriptionUtils {
    private FileDescriptionUtils() {
    }

    public static boolean isResourceOfTypeWithRootTag(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        if (file == null) {
            FileDescriptionUtils.$$$reportNull$$$0(0);
        }
        if (folderType == null) {
            FileDescriptionUtils.$$$reportNull$$$0(1);
        }
        if (rootTags == null) {
            FileDescriptionUtils.$$$reportNull$$$0(2);
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file, folderType, rootTags));
    }

    @NotNull
    private static Stream<XmlTag> asStream(@NotNull XmlTag rootTag) {
        if (rootTag == null) {
            FileDescriptionUtils.$$$reportNull$$$0(3);
        }
        Stream<XmlTag> stream = Stream.concat(Stream.of(rootTag), Arrays.stream(rootTag.getSubTags()).filter(XmlTag.class::isInstance).map(XmlTag.class::cast).flatMap(FileDescriptionUtils::asStream));
        if (stream == null) {
            FileDescriptionUtils.$$$reportNull$$$0(4);
        }
        return stream;
    }

    public static boolean isResourceOfTypeContainingTag(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> tagNames) {
        if (file == null) {
            FileDescriptionUtils.$$$reportNull$$$0(5);
        }
        if (folderType == null) {
            FileDescriptionUtils.$$$reportNull$$$0(6);
        }
        if (tagNames == null) {
            FileDescriptionUtils.$$$reportNull$$$0(7);
        }
        Condition tagCondition = tagNames.isEmpty() ? Conditions.alwaysTrue() : rootTag -> FileDescriptionUtils.asStream(rootTag).anyMatch(tag -> tagNames.contains(tag.getName()));
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)tagCondition));
    }

    @NotNull
    private static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Condition<XmlTag> tagVerifier) {
        if (file == null) {
            FileDescriptionUtils.$$$reportNull$$$0(8);
        }
        if (folderType == null) {
            FileDescriptionUtils.$$$reportNull$$$0(9);
        }
        if (tagVerifier == null) {
            FileDescriptionUtils.$$$reportNull$$$0(10);
        }
        Computable computable = () -> {
            if (file.getProject().isDisposed()) {
                return false;
            }
            if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, folderType.getName())) {
                return false;
            }
            XmlTag rootTag = file.getRootTag();
            assert (rootTag != null);
            return tagVerifier.value((Object)rootTag);
        };
        if (computable == null) {
            FileDescriptionUtils.$$$reportNull$$$0(11);
        }
        return computable;
    }

    @NotNull
    @VisibleForTesting
    static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        if (file == null) {
            FileDescriptionUtils.$$$reportNull$$$0(12);
        }
        if (folderType == null) {
            FileDescriptionUtils.$$$reportNull$$$0(13);
        }
        if (rootTags == null) {
            FileDescriptionUtils.$$$reportNull$$$0(14);
        }
        return rootTags.isEmpty() ? FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)Conditions.alwaysTrue()) : FileDescriptionUtils.newResourceTypeVerifier(file, folderType, (Condition<XmlTag>)((Condition)element -> rootTags.contains(element.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTags";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/FileDescriptionUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagVerifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/FileDescriptionUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newResourceTypeVerifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isResourceOfTypeWithRootTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asStream";
                break;
            }
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResourceOfTypeContainingTag";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newResourceTypeVerifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

