/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"findStartDestination", "Lcom/intellij/psi/xml/XmlTag;", "root", "getStartDestLayoutId", "", "navResourceId", "project", "Lcom/intellij/openapi/project/Project;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "intellij.android.core"})
public final class NavXmlHelperKt {
    @Nullable
    public static final String getStartDestLayoutId(@NotNull String navResourceId, @NotNull Project project, @NotNull ResourceResolver resourceResolver2) {
        Intrinsics.checkNotNullParameter((Object)navResourceId, (String)"navResourceId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resourceResolver2, (String)"resourceResolver");
        if (!StringsKt.startsWith$default((String)navResourceId, (String)"@navigation/", (boolean)false, (int)2, null)) {
            return null;
        }
        Object object = resourceResolver2.findResValue(navResourceId, false);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object fileName = object;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath((String)fileName);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026(fileName) ?: return null");
        VirtualFile file = virtualFile;
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file);
        if (!(psiFile2 instanceof XmlFile)) {
            psiFile2 = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile2;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile3 = xmlFile;
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(psiFile3){
            final /* synthetic */ XmlFile $psiFile;

            public final String compute() {
                XmlTag xmlTag = NavXmlHelperKt.access$findStartDestination(this.$psiFile.getRootTag());
                return xmlTag != null ? xmlTag.getAttributeValue("layout", "http://schemas.android.com/tools") : null;
            }
            {
                this.$psiFile = xmlFile;
            }
        });
    }

    private static final XmlTag findStartDestination(XmlTag root2) {
        XmlTag current = root2;
        while (true) {
            Object v4;
            block7: {
                String string;
                block9: {
                    block8: {
                        XmlTag xmlTag = current;
                        if (!Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"navigation")) break;
                        string = current.getAttributeValue("startDestination", "http://schemas.android.com/apk/res-auto");
                        if (string == null) break block8;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String p1 = string2;
                        boolean bl3 = false;
                        string = ResourcesUtil.stripPrefixFromId((String)p1);
                        if (string != null) break block9;
                    }
                    return null;
                }
                String startDestId = string;
                Object[] objectArray = current.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"current\n      .children");
                Iterable $this$firstOrNull$iv = ArraysKt.filterIsInstance((Object[])objectArray, XmlTag.class);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String string3;
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl = false;
                    if (it.getAttributeValue("id", "http://schemas.android.com/apk/res/android") != null) {
                        String string4;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        String p1 = string4;
                        boolean bl6 = false;
                        string3 = ResourcesUtil.stripPrefixFromId((String)p1);
                    } else {
                        string3 = null;
                    }
                    if (!Intrinsics.areEqual(string3, (Object)startDestId)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            current = v4;
        }
        return current;
    }

    public static final /* synthetic */ XmlTag access$findStartDestination(XmlTag root2) {
        return NavXmlHelperKt.findStartDestination(root2);
    }
}

