/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.sdklib.BuildToolInfo;
import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildActionUtil;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.ExportEncryptedPrivateKeyTool;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.gradle.tooling.BuildAction;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.exportSignedPackage.ApkStep;
import org.jetbrains.android.exportSignedPackage.ChooseBundleOrApkStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    public static final String BUNDLE = "bundle";
    public static final String APK = "apk";
    private static final String ENCRYPTED_PRIVATE_KEY_FILE = "private_key.pepk";
    private static final String GOOGLE_PUBLIC_KEY = "eb10fe8f7c7c9df715022017b00c6471f8ba8170b13049a11e6c09ffe3056a104a3bbe4ac5a955f4ba4fe93fc8cef27558a3eb9d2a529a2092761fb833b656cd48b9de6a";
    @NotNull
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private boolean mySigned;
    private CompileScope myCompileScope;
    private String myApkPath;
    private boolean myV1Signature;
    private boolean myV2Signature;
    private String myExportKeyPath;
    @NotNull
    private String myTargetType;
    @NotNull
    private ExportEncryptedPrivateKeyTool myEncryptionTool;
    private boolean myExportPrivateKey;
    private List<String> myBuildVariants;
    private GradleSigningInfo myGradleSigningInfo;

    private static Logger getLog() {
        return Logger.getInstance(ExportSignedPackageWizard.class);
    }

    public ExportSignedPackageWizard(@NotNull Project project, @NotNull List<AndroidFacet> facets, boolean signed, Boolean showBundle, @NotNull ExportEncryptedPrivateKeyTool encryptionTool) {
        if (project == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(0);
        }
        if (facets == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(1);
        }
        if (encryptionTool == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(2);
        }
        super(AndroidBundle.message(showBundle != false ? "android.export.package.wizard.bundle.title" : "android.export.package.wizard.title", new Object[0]), project);
        this.myTargetType = APK;
        this.myProject = project;
        this.mySigned = signed;
        this.myEncryptionTool = encryptionTool;
        assert (!facets.isEmpty());
        this.myFacet = facets.get(0);
        if (showBundle.booleanValue()) {
            this.addStep((Step)new ChooseBundleOrApkStep(this));
        }
        boolean useGradleToSign = AndroidModel.isRequired(this.myFacet);
        if (signed) {
            this.addStep((Step)new KeystoreStep(this, useGradleToSign, facets));
        }
        if (useGradleToSign) {
            this.addStep((Step)new GradleSignStep(this));
        } else {
            this.addStep((Step)new ApkStep(this));
        }
        this.init();
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doOKAction();
        assert (this.myFacet != null);
        if (AndroidModel.isRequired(this.myFacet)) {
            this.buildAndSignGradleProject();
        } else {
            this.buildAndSignIntellijProject();
        }
    }

    private void buildAndSignIntellijProject() {
        CompilerManager.getInstance((Project)this.myProject).make(this.myCompileScope, (aborted, errors, warnings, compileContext) -> {
            if (aborted || errors != 0) {
                return;
            }
            String title = AndroidBundle.message("android.extract.package.task.title", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ExportSignedPackageWizard.this.createAndAlignApk(ExportSignedPackageWizard.this.myApkPath);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$1", "run"));
                }
            });
        });
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating Signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleFacet gradleFacet;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((gradleFacet = GradleFacet.getInstance(ExportSignedPackageWizard.this.myFacet.getModule())) == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                String gradleProjectPath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)ExportSignedPackageWizard.this.myFacet.getModule());
                if (StringUtil.isEmpty((String)rootProjectPath)) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle root project path for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    return;
                }
                AndroidModuleModel androidModel = AndroidModuleModel.get(ExportSignedPackageWizard.this.myFacet);
                if (androidModel == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to obtain Android project model. Did the last Gradle sync complete successfully?");
                    return;
                }
                if (ExportSignedPackageWizard.this.myBuildVariants == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to find required information. Please check the previous steps are completed.");
                    return;
                }
                List<String> gradleTasks = ExportSignedPackageWizard.getGradleTasks(gradleProjectPath, androidModel, ExportSignedPackageWizard.this.myBuildVariants, ExportSignedPackageWizard.this.myTargetType);
                ArrayList<String> projectProperties = new ArrayList<String>();
                projectProperties.add(this.createProperty("android.injected.signing.store.file", ExportSignedPackageWizard.this.myGradleSigningInfo.keyStoreFilePath));
                projectProperties.add(this.createProperty("android.injected.signing.store.password", new String(ExportSignedPackageWizard.this.myGradleSigningInfo.keyStorePassword)));
                projectProperties.add(this.createProperty("android.injected.signing.key.alias", ExportSignedPackageWizard.this.myGradleSigningInfo.keyAlias));
                projectProperties.add(this.createProperty("android.injected.signing.key.password", new String(ExportSignedPackageWizard.this.myGradleSigningInfo.keyPassword)));
                projectProperties.add(this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
                projectProperties.add(this.createProperty("android.injected.signing.v1-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV1Signature)));
                projectProperties.add(this.createProperty("android.injected.signing.v2-enabled", Boolean.toString(ExportSignedPackageWizard.this.myV2Signature)));
                assert (this.myProject != null);
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
                ImmutableList modules = ImmutableList.of((Object)ExportSignedPackageWizard.this.myFacet.getModule());
                if (ExportSignedPackageWizard.this.myTargetType.equals(ExportSignedPackageWizard.BUNDLE)) {
                    File exportedKeyFile = null;
                    if (ExportSignedPackageWizard.this.myExportPrivateKey) {
                        exportedKeyFile = ExportSignedPackageWizard.this.generatePrivateKeyPath();
                        try {
                            ExportSignedPackageWizard.this.myEncryptionTool.run(ExportSignedPackageWizard.this.myGradleSigningInfo.keyStoreFilePath, ExportSignedPackageWizard.this.myGradleSigningInfo.keyAlias, ExportSignedPackageWizard.GOOGLE_PUBLIC_KEY, exportedKeyFile.getPath(), ExportSignedPackageWizard.this.myGradleSigningInfo.keyStorePassword, ExportSignedPackageWizard.this.myGradleSigningInfo.keyPassword);
                            GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(this.myProject);
                            settings.EXPORT_PRIVATE_KEY = false;
                        }
                        catch (Exception e) {
                            ExportSignedPackageWizard.getLog().error("Something went wrong with the encryption tool", (Throwable)e);
                            return;
                        }
                    }
                    gradleBuildInvoker.add(new GoToBundleLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed Bundle", ExportSignedPackageWizard.this.myBuildVariants, exportedKeyFile, ExportSignedPackageWizard.this.myApkPath));
                } else {
                    gradleBuildInvoker.add(new GoToApkLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed APK", ExportSignedPackageWizard.this.myBuildVariants, ExportSignedPackageWizard.this.myApkPath));
                }
                gradleBuildInvoker.executeTasks(new File(rootProjectPath), gradleTasks, projectProperties, (BuildAction)OutputBuildActionUtil.create((List<? extends Module>)modules));
                ExportSignedPackageWizard.getLog().info("Export " + StringUtil.toUpperCase((String)ExportSignedPackageWizard.this.myTargetType) + " command: " + Joiner.on((char)',').join(gradleTasks) + ", destination: " + this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
            }

            private String createProperty(@NotNull String name, @NotNull String value2) {
                if (name == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (value2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return AndroidGradleSettings.createProjectProperty((String)name, (String)value2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @VisibleForTesting
    @NotNull
    public static File getApkLocation(@NotNull String apkFolderPath, @NotNull String buildType) {
        if (apkFolderPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(3);
        }
        if (buildType == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(4);
        }
        return new File(apkFolderPath, buildType);
    }

    @VisibleForTesting
    @NotNull
    public static List<String> getGradleTasks(@NotNull String gradleProjectPath, @NotNull AndroidModuleModel androidModuleModel, @NotNull List<String> buildVariants, @NotNull String targetType) {
        if (gradleProjectPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(5);
        }
        if (androidModuleModel == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(6);
        }
        if (buildVariants == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(7);
        }
        if (targetType == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(8);
        }
        ArrayList gradleTasks = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        IdeVariant selectedVariant = androidModuleModel.getSelectedVariant();
        String selectedTaskName = ExportSignedPackageWizard.getTaskName((Variant)selectedVariant, targetType);
        String selectedVariantName = selectedVariant.getName();
        if (selectedTaskName == null) {
            ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + selectedVariantName);
            List<String> list = Collections.emptyList();
            if (list == null) {
                ExportSignedPackageWizard.$$$reportNull$$$0(9);
            }
            return list;
        }
        for (String variantName : buildVariants) {
            String taskName = ExportSignedPackageWizard.replaceVariantFromTask(selectedTaskName, selectedVariantName, variantName);
            if (taskName != null) {
                gradleTasks.add(GradleTaskFinder.getInstance().createBuildTask(gradleProjectPath, taskName));
                continue;
            }
            ExportSignedPackageWizard.getLog().warn("Could not replace variant " + selectedVariantName + " with " + variantName + " for task " + selectedTaskName + ".");
        }
        ArrayList arrayList = gradleTasks;
        if (arrayList == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public static String replaceVariantFromTask(@NotNull String task2, @NotNull String oldVariant, @NotNull String newVariant) {
        if (task2 == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(11);
        }
        if (oldVariant == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(12);
        }
        if (newVariant == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(13);
        }
        if (task2.indexOf(oldVariant = StringUtil.decapitalize((String)oldVariant)) == 1) {
            newVariant = StringUtil.decapitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        if (task2.contains(oldVariant = StringUtil.capitalize((String)oldVariant))) {
            newVariant = StringUtil.capitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        return null;
    }

    private static String getTaskName(Variant v, String targetType) {
        if (targetType.equals(BUNDLE)) {
            return v.getMainArtifact().getBundleTaskName();
        }
        return v.getMainArtifact().getAssembleTaskName();
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result2 = super.getNextStep(stepIndex);
        if (result2 != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result2))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result2;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step = this.getCurrentStep();
        ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step));
        this.getFinishButton().setEnabled(currentStep.canFinish());
        super.updateStep();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.getRootPane().setDefaultButton(this.getNextButton());
            JComponent component3 = currentStep.getPreferredFocusedComponent();
            if (component3 != null) {
                component3.requestFocus();
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step != null) {
            return step.getHelpId();
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(14);
        }
        return project;
    }

    public void setFacet(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(15);
        }
        this.myFacet = facet2;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        if (privateKey == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(16);
        }
        this.myPrivateKey = privateKey;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(17);
        }
        this.myCertificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCompileScope(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(18);
        }
        this.myCompileScope = compileScope;
    }

    public void setApkPath(@NotNull String apkPath) {
        if (apkPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(19);
        }
        this.myApkPath = apkPath;
    }

    public void setV1Signature(boolean v1Signature) {
        this.myV1Signature = v1Signature;
    }

    public void setV2Signature(boolean v2Signature) {
        this.myV2Signature = v2Signature;
    }

    public void setGradleOptions(@NotNull List<String> buildVariants) {
        if (buildVariants == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(20);
        }
        this.myBuildVariants = buildVariants;
    }

    public void setTargetType(@NotNull String targetType) {
        if (targetType == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(21);
        }
        this.myTargetType = targetType;
    }

    @NotNull
    public String getTargetType() {
        String string = this.myTargetType;
        if (string == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(22);
        }
        return string;
    }

    private void createAndAlignApk(String apkPath) {
        File realDestFile;
        String message2;
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getFacet().getModule());
        assert (platform != null);
        BuildToolInfo buildTool = platform.getTarget().getBuildToolInfo();
        String zipAlignPath = buildTool.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
        File zipalign = new File(zipAlignPath);
        boolean runZipAlign = zipalign.isFile();
        File destFile = null;
        try {
            destFile = runZipAlign ? FileUtil.createTempFile((String)"android", (String)".apk") : new File(apkPath);
            this.createApk(destFile);
        }
        catch (Exception e) {
            this.showErrorInDispatchThread(e.getMessage());
        }
        if (destFile == null) {
            return;
        }
        if (runZipAlign && (message2 = AndroidBuildCommonUtils.executeZipAlign((String)zipAlignPath, (File)destFile, (File)(realDestFile = new File(apkPath)))) != null) {
            this.showErrorInDispatchThread(message2);
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            String title = AndroidBundle.message("android.export.package.wizard.title", new Object[0]);
            Project project = this.getProject();
            File apkFile = new File(apkPath);
            VirtualFile vApkFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(apkFile);
            if (vApkFile != null) {
                vApkFile.refresh(true, false);
            }
            if (!runZipAlign) {
                Messages.showWarningDialog((Project)project, (String)AndroidCommonBundle.message((String)"android.artifact.building.cannot.find.zip.align.error", (Object[])new Object[0]), (String)title);
            }
            if (RevealFileAction.isSupported()) {
                if (Messages.showOkCancelDialog((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile.getName()), (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
                    RevealFileAction.openFile((File)apkFile);
                }
            } else {
                Messages.showInfoMessage((Project)project, (String)AndroidBundle.message("android.export.package.success.message", apkFile), (String)title);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private void createApk(@NotNull File destFile) throws IOException, GeneralSecurityException {
        if (destFile == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(23);
        }
        String srcApkPath = AndroidCompileUtil.getUnsignedApkPath(this.getFacet());
        assert (srcApkPath != null);
        File srcApk = new File(FileUtil.toSystemDependentName((String)srcApkPath));
        if (this.isSigned()) {
            AndroidBuildCommonUtils.signApk((File)srcApk, (File)destFile, (PrivateKey)this.getPrivateKey(), (X509Certificate)this.getCertificate());
        } else {
            FileUtil.copy((File)srcApk, (File)destFile);
        }
    }

    @NotNull
    private File generatePrivateKeyPath() {
        return new File(this.myExportKeyPath, ENCRYPTED_PRIVATE_KEY_FILE);
    }

    private void showErrorInDispatchThread(@NotNull String message2) {
        if (message2 == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(24);
        }
        UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.getProject(), (String)("Error: " + message2), (String)CommonBundle.getErrorTitle()));
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }

    public void setExportPrivateKey(boolean exportPrivateKey) {
        this.myExportPrivateKey = exportPrivateKey;
    }

    public void setExportKeyPath(@NotNull String exportKeyPath) {
        if (exportKeyPath == null) {
            ExportSignedPackageWizard.$$$reportNull$$$0(25);
        }
        this.myExportKeyPath = exportKeyPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encryptionTool";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFolderPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariants";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldVariant";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVariant";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileScope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportKeyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/exportSignedPackage/ExportSignedPackageWizard";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleTasks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApkLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGradleTasks";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 22: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceVariantFromTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFacet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPrivateKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCertificate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setCompileScope";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setApkPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setGradleOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setTargetType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createApk";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showErrorInDispatchThread";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setExportKeyPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

