/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0012\u0010\u0011\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0007\u001a)\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00140\u00152\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0016\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u0017"}, d2={"allSourceFolderUrls", "Lkotlin/sequences/Sequence;", "", "Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "getAllSourceFolderUrls", "(Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;)Lkotlin/sequences/Sequence;", "allSourceFolders", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllSourceFolders", "getManifestFiles", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isManifestFile", "", "candidate", "isTestFile", "containsFile", "file", "findByFile", "T", "", "(Ljava/lang/Iterable;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/android/tools/idea/projectsystem/IdeaSourceProvider;", "intellij.android.core"})
@JvmName(name="IdeaSourceProviderUtil")
public final class IdeaSourceProviderUtil {
    public static final boolean containsFile(@NotNull IdeaSourceProvider $this$containsFile, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$containsFile, (String)"$this$containsFile");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($this$containsFile.getManifestFiles().contains(file) || $this$containsFile.getManifestDirectories().contains(file)) {
            return true;
        }
        for (VirtualFile container : IdeaSourceProviderUtil.getAllSourceFolders($this$containsFile)) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final <T extends IdeaSourceProvider> T findByFile(@NotNull Iterable<? extends T> $this$findByFile, @NotNull VirtualFile file) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$findByFile, (String)"$this$findByFile");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable<T> $this$firstOrNull$iv = $this$findByFile;
            boolean $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                IdeaSourceProvider it = (IdeaSourceProvider)element$iv;
                boolean bl = false;
                if (!IdeaSourceProviderUtil.containsFile(it, file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((IdeaSourceProvider)v0);
    }

    public static final boolean isTestFile(@NotNull AndroidFacet facet2, @NotNull VirtualFile candidate) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return IdeaSourceProviderUtil.containsFile(SourceProviderManager.Companion.getInstance(facet2).getUnitTestSources(), candidate) || IdeaSourceProviderUtil.containsFile(SourceProviderManager.Companion.getInstance(facet2).getAndroidTestSources(), candidate);
    }

    public static final boolean isManifestFile(@NotNull AndroidFacet facet2, @NotNull VirtualFile candidate) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return SourceProviderManager.Companion.getInstance(facet2).getSources().getManifestFiles().contains(candidate);
    }

    @NotNull
    public static final List<VirtualFile> getManifestFiles(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        return CollectionsKt.toList((Iterable)SourceProviderManager.Companion.getInstance(facet2).getSources().getManifestFiles());
    }

    @NotNull
    public static final Sequence<VirtualFile> getAllSourceFolders(@NotNull IdeaSourceProvider $this$allSourceFolders) {
        Intrinsics.checkNotNullParameter((Object)$this$allSourceFolders, (String)"$this$allSourceFolders");
        return SequencesKt.flattenSequenceOfIterable((Sequence)ArraysKt.asSequence((Object[])new Collection[]{$this$allSourceFolders.getJavaDirectories(), $this$allSourceFolders.getResDirectories(), $this$allSourceFolders.getAidlDirectories(), $this$allSourceFolders.getRenderscriptDirectories(), $this$allSourceFolders.getAssetsDirectories(), $this$allSourceFolders.getJniDirectories(), $this$allSourceFolders.getJniLibsDirectories()}));
    }

    @NotNull
    public static final Sequence<String> getAllSourceFolderUrls(@NotNull IdeaSourceProvider $this$allSourceFolderUrls) {
        Intrinsics.checkNotNullParameter((Object)$this$allSourceFolderUrls, (String)"$this$allSourceFolderUrls");
        return SequencesKt.flattenSequenceOfIterable((Sequence)ArraysKt.asSequence((Object[])new Collection[]{$this$allSourceFolderUrls.getJavaDirectoryUrls(), $this$allSourceFolderUrls.getResDirectoryUrls(), $this$allSourceFolderUrls.getAidlDirectoryUrls(), $this$allSourceFolderUrls.getRenderscriptDirectoryUrls(), $this$allSourceFolderUrls.getAssetsDirectoryUrls(), $this$allSourceFolderUrls.getJniDirectoryUrls(), $this$allSourceFolderUrls.getJniLibsDirectoryUrls()}));
    }
}

