/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidDeprecationInspection;
import org.jetbrains.android.inspections.VersionChecks;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeprecationFilter
extends AndroidDeprecationInspection.DeprecationFilter {
    private static final String ACTION_BAR_ACTIVITY = "android.support.v7.app.ActionBarActivity";
    private static final String APP_COMPAT_ACTIVITY = "android.support.v7.app.AppCompatActivity";

    private static int getDeprecatedIn(@Nullable Project project, @NotNull PsiElement deprecatedElement) {
        PsiClass containingClass;
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        if (apiLookup == null) {
            return -1;
        }
        if (deprecatedElement instanceof PsiClass) {
            String owner = ((PsiClass)deprecatedElement).getQualifiedName();
            if (owner != null) {
                return apiLookup.getClassDeprecatedIn(owner);
            }
        } else if (deprecatedElement instanceof PsiMember && (containingClass = ((PsiMember)deprecatedElement).getContainingClass()) != null) {
            DefaultJavaEvaluator evaluator = new DefaultJavaEvaluator(project, null);
            String owner = containingClass.getQualifiedName();
            if (owner != null) {
                if (deprecatedElement instanceof PsiField) {
                    String name = ((PsiField)deprecatedElement).getName();
                    return apiLookup.getFieldDeprecatedIn(owner, name);
                }
                if (deprecatedElement instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)deprecatedElement;
                    String name = Lint.getInternalMethodName((PsiMethod)method);
                    String desc = evaluator.getMethodDescription(method, false, false);
                    if (desc != null) {
                        return apiLookup.getMethodDeprecatedIn(owner, name, desc);
                    }
                }
            }
        }
        return -1;
    }

    @Override
    public boolean isExcluded(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        AndroidFacet facet2;
        Project project;
        int deprecatedIn;
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(1);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(2);
        }
        if ((deprecatedIn = AndroidDeprecationFilter.getDeprecatedIn(project = referenceElement.getProject(), deprecatedElement)) != -1 && (facet2 = AndroidFacet.getInstance((PsiElement)referenceElement)) != null && !facet2.isDisposed() && AndroidModuleInfo.getInstance(facet2).getMinSdkVersion().getApiLevel() < deprecatedIn) {
            return !VersionChecks.isPrecededByVersionCheckExit(referenceElement, deprecatedIn) && !VersionChecks.isWithinVersionCheckConditional(referenceElement, deprecatedIn);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDeprecationMessage(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName, @NotNull String defaultMessage) {
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(3);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(4);
        }
        if (defaultMessage == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(5);
        }
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            return "ActionBarActivity is deprecated; use `AppCompatActivity` instead";
        }
        int version2 = AndroidDeprecationFilter.getDeprecatedIn(referenceElement.getProject(), deprecatedElement);
        if (version2 != -1) {
            String string = defaultMessage + " as of " + SdkVersionInfo.getAndroidName((int)version2);
            if (string == null) {
                AndroidDeprecationFilter.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = defaultMessage;
        if (string == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        if (deprecatedElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(8);
        }
        if (referenceElement == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(9);
        }
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceSuperClassFix(referenceElement, APP_COMPAT_ACTIVITY)};
            if (localQuickFixArray == null) {
                AndroidDeprecationFilter.$$$reportNull$$$0(10);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            AndroidDeprecationFilter.$$$reportNull$$$0(11);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationFilter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecationMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedIn";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecationMessage";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceSuperClassFix
    implements LocalQuickFix {
        private final String myQualifiedName;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myElement;

        public ReplaceSuperClassFix(@NotNull PsiElement element, @NotNull String qualifiedName) {
            if (element == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(0);
            }
            if (qualifiedName == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(1);
            }
            this.myQualifiedName = qualifiedName;
            this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace With " + this.myQualifiedName.substring(this.myQualifiedName.lastIndexOf(46) + 1);
            if (string == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return "Replace deprecated code";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement replace;
            if (project == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ReplaceSuperClassFix.$$$reportNull$$$0(4);
            }
            if ((replace = this.myElement.getElement()) == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = facade.getElementFactory();
            boolean androidX = MigrateToAndroidxUtil.isAndroidx(project);
            String newName2 = androidX ? AndroidxNameUtils.getNewName((String)this.myQualifiedName) : this.myQualifiedName;
            PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(newName2, replace);
            newReference = replace.replace((PsiElement)newReference);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newReference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/inspections/AndroidDeprecationFilter$ReplaceSuperClassFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/inspections/AndroidDeprecationFilter$ReplaceSuperClassFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

